/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.scabaras.overlay;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.features.scabaras.ScabarasHelperMode;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidRoom;
import com.duckblade.osrs.toa.util.RaidState;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.NpcChanged;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ObeliskPuzzleSolver
implements PluginLifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(ObeliskPuzzleSolver.class);
    private static final int OBELISK_ID_INACTIVE = 11698;
    private static final int OBELISK_ID_ACTIVE = 11699;
    private final EventBus eventBus;
    private int activeObelisks = 0;
    private final List<LocalPoint> obeliskOrder = new ArrayList<LocalPoint>(6);

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState raidState) {
        return config.scabarasHelperMode() == ScabarasHelperMode.OVERLAY && raidState.getCurrentRoom() == RaidRoom.SCABARAS;
    }

    @Override
    public void startUp() {
        this.eventBus.register((Object)this);
        this.activeObelisks = 0;
        this.obeliskOrder.clear();
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister((Object)this);
    }

    @Subscribe
    public void onNpcChanged(NpcChanged e) {
        if (e.getNpc().getId() == 11699) {
            LocalPoint obeliskTile = e.getNpc().getLocalLocation();
            if (!this.obeliskOrder.contains(obeliskTile)) {
                this.obeliskOrder.add(obeliskTile);
            }
            ++this.activeObelisks;
        } else if (e.getNpc().getId() == 11698) {
            this.activeObelisks = 0;
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage e) {
        if (e.getMessage().startsWith("Your party failed to complete the challenge")) {
            this.activeObelisks = 0;
            this.obeliskOrder.clear();
        }
    }

    @Inject
    public ObeliskPuzzleSolver(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public int getActiveObelisks() {
        return this.activeObelisks;
    }

    public List<LocalPoint> getObeliskOrder() {
        return this.obeliskOrder;
    }
}

