/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.scabaras.overlay;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.features.scabaras.ScabarasHelperMode;
import com.duckblade.osrs.toa.features.scabaras.overlay.MatchingTile;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidRoom;
import com.duckblade.osrs.toa.util.RaidState;
import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MatchingPuzzleSolver
implements PluginLifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(MatchingPuzzleSolver.class);
    private static final Map<Integer, String> TILE_NAMES = ImmutableMap.builder().put((Object)45365, (Object)"Line").put((Object)45366, (Object)"Knives").put((Object)45367, (Object)"Crook").put((Object)45368, (Object)"Diamond").put((Object)45369, (Object)"Hand").put((Object)45370, (Object)"Star").put((Object)45371, (Object)"Bird").put((Object)45372, (Object)"W").put((Object)45373, (Object)"Boot").build();
    private static final Map<Integer, Color> TILE_COLORS = ImmutableMap.builder().put((Object)45365, (Object)Color.black).put((Object)45366, (Object)Color.red).put((Object)45367, (Object)Color.magenta).put((Object)45368, (Object)Color.blue).put((Object)45369, (Object)Color.lightGray).put((Object)45370, (Object)Color.cyan).put((Object)45371, (Object)Color.pink).put((Object)45372, (Object)Color.yellow).put((Object)45373, (Object)Color.green).build();
    private static final Map<Integer, Integer> MATCHED_OBJECT_IDS = ImmutableMap.builder().put((Object)45388, (Object)45365).put((Object)45389, (Object)45366).put((Object)45386, (Object)45367).put((Object)45391, (Object)45368).put((Object)45392, (Object)45369).put((Object)45387, (Object)45370).put((Object)45393, (Object)45371).put((Object)45394, (Object)45372).put((Object)45395, (Object)45373).build();
    private final EventBus eventBus;
    private final Map<LocalPoint, MatchingTile> discoveredTiles = new HashMap<LocalPoint, MatchingTile>(18);

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState raidState) {
        return config.scabarasHelperMode() == ScabarasHelperMode.OVERLAY && raidState.getCurrentRoom() == RaidRoom.SCABARAS;
    }

    @Override
    public void startUp() {
        this.eventBus.register((Object)this);
        this.discoveredTiles.clear();
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister((Object)this);
    }

    @Subscribe
    public void onGroundObjectSpawned(GroundObjectSpawned e) {
        int id = e.getGroundObject().getId();
        if (TILE_COLORS.containsKey(id)) {
            LocalPoint lp = e.getGroundObject().getLocalLocation();
            this.discoveredTiles.put(lp, new MatchingTile(lp, TILE_NAMES.getOrDefault(id, "Unknown"), TILE_COLORS.getOrDefault(id, Color.black)));
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned e) {
        int gameId = e.getGameObject().getId();
        if (MATCHED_OBJECT_IDS.containsKey(gameId)) {
            MatchingTile match = this.discoveredTiles.get(e.getGameObject().getLocalLocation());
            if (match == null) {
                log.debug("Failed to find discovered tile for game object id {}!", (Object)gameId);
                return;
            }
            match.setMatched(true);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage e) {
        if (e.getMessage().startsWith("Your party failed to complete the challenge")) {
            this.discoveredTiles.clear();
        }
    }

    @Inject
    public MatchingPuzzleSolver(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public Map<LocalPoint, MatchingTile> getDiscoveredTiles() {
        return this.discoveredTiles;
    }
}

