/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.scabaras.overlay;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.features.scabaras.ScabarasHelperMode;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidRoom;
import com.duckblade.osrs.toa.util.RaidState;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GroundObject;
import net.runelite.api.Point;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LightPuzzleSolver
implements PluginLifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(LightPuzzleSolver.class);
    private static final int GROUND_OBJECT_LIGHT_BACKGROUND = 45344;
    private static final int GAME_OBJECT_LIGHT_ENABLED = 45384;
    private static final Point[] SCENE_COORD_STARTS = new Point[]{new Point(36, 56), new Point(36, 44), new Point(53, 56), new Point(53, 44)};
    private static final int[] LIGHTS_PUZZLE_XOR_ARRAY = new int[]{117, 186, 205, 206, 115, 179, 93, 174};
    private final EventBus eventBus;
    private final Client client;
    private boolean solved;
    private int tileStates = -1;
    private Set<LocalPoint> flips = Collections.emptySet();

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState raidState) {
        return config.scabarasHelperMode() == ScabarasHelperMode.OVERLAY && raidState.getCurrentRoom() == RaidRoom.SCABARAS;
    }

    @Override
    public void startUp() {
        this.eventBus.register((Object)this);
        this.solved = false;
        this.solve();
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister((Object)this);
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned e) {
        if (e.getGameObject().getId() == 45384) {
            this.solved = false;
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned e) {
        if (e.getGameObject().getId() == 45384) {
            this.solved = false;
        }
    }

    @Subscribe
    public void onGameTick(GameTick e) {
        if (!this.solved) {
            this.solve();
        }
    }

    private void solve() {
        this.solved = true;
        Tile[][] sceneTiles = this.client.getScene().getTiles()[this.client.getPlane()];
        Point tl = this.findStartTile(sceneTiles);
        if (tl == null) {
            log.debug("Failed to locate start of light puzzle");
            return;
        }
        this.tileStates = this.readTileStates(sceneTiles, tl);
        this.flips = this.findSolution(tl);
    }

    private Point findStartTile(Tile[][] sceneTiles) {
        for (Point sceneCoordStart : SCENE_COORD_STARTS) {
            Tile startTile = sceneTiles[sceneCoordStart.getX()][sceneCoordStart.getY()];
            GroundObject groundObject = startTile.getGroundObject();
            if (groundObject == null || groundObject.getId() != 45344) continue;
            return sceneCoordStart;
        }
        return null;
    }

    private int readTileStates(Tile[][] sceneTiles, Point topLeft) {
        int tileStates = 0;
        for (int i = 0; i < 8; ++i) {
            int tileIx = i > 3 ? i + 1 : i;
            int x = tileIx % 3;
            int y = tileIx / 3;
            Tile lightTile = sceneTiles[topLeft.getX() + x * 2][topLeft.getY() - y * 2];
            boolean active = Arrays.stream(lightTile.getGameObjects()).filter(Objects::nonNull).mapToInt(TileObject::getId).anyMatch(id -> id == 45384);
            log.debug("Read light ({}, {}) as active={}", new Object[]{x, y, active});
            if (!active) continue;
            tileStates |= 1 << i;
        }
        return tileStates;
    }

    private Set<LocalPoint> findSolution(Point topLeft) {
        int xor = 0;
        for (int i = 0; i < 8; ++i) {
            int mask = 1 << i;
            if ((this.tileStates & mask) == mask) continue;
            xor ^= LIGHTS_PUZZLE_XOR_ARRAY[i];
        }
        HashSet<LocalPoint> points = new HashSet<LocalPoint>();
        for (int i = 0; i < 8; ++i) {
            int mask = 1 << i;
            if ((xor & mask) != mask) continue;
            int tileIx = i > 3 ? i + 1 : i;
            int x = tileIx % 3;
            int y = tileIx / 3;
            points.add(LocalPoint.fromScene((int)(topLeft.getX() + x * 2), (int)(topLeft.getY() - y * 2)));
        }
        return points;
    }

    @Inject
    public LightPuzzleSolver(EventBus eventBus, Client client) {
        this.eventBus = eventBus;
        this.client = client;
    }

    public Set<LocalPoint> getFlips() {
        return this.flips;
    }
}

