/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.scabaras.overlay;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.features.scabaras.ScabarasHelperMode;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidRoom;
import com.duckblade.osrs.toa.util.RaidState;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GroundObject;
import net.runelite.api.Point;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AdditionPuzzleSolver
implements PluginLifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(AdditionPuzzleSolver.class);
    private static final Set<Integer> GAME_OBJECT_IDS = Arrays.stream(AdditionTile.values()).map(AdditionTile::getGameObjectId).collect(Collectors.toSet());
    private static final Point[] SCENE_COORD_STARTS = new Point[]{new Point(36, 56), new Point(36, 44), new Point(53, 56), new Point(53, 44)};
    private static final Map<Integer, Set<Integer>> OPTIMAL_SOLUTIONS = ImmutableMap.builder().put((Object)20, (Object)ImmutableSet.of((Object)5, (Object)11, (Object)17)).put((Object)21, (Object)ImmutableSet.of((Object)10, (Object)11, (Object)17)).put((Object)22, (Object)ImmutableSet.of((Object)10, (Object)11, (Object)12, (Object)18, (Object)24)).put((Object)23, (Object)ImmutableSet.of((Object)5, (Object)6, (Object)7, (Object)8, (Object)14)).put((Object)24, (Object)ImmutableSet.of((Object)5, (Object)11, (Object)17, (Object)23)).put((Object)25, (Object)ImmutableSet.of((Object)10, (Object)11, (Object)12, (Object)13)).put((Object)26, (Object)ImmutableSet.of((Object)9, (Object)10, (Object)11, (Object)12, (Object)13)).put((Object)27, (Object)ImmutableSet.of((Object)5, (Object)6, (Object)7, (Object)8, (Object)4)).put((Object)28, (Object)ImmutableSet.of((Object)0, (Object)1, (Object)7, (Object)13, (Object)19)).put((Object)29, (Object)ImmutableSet.of((Object)10, (Object)11, (Object)12, (Object)13, (Object)19)).put((Object)30, (Object)ImmutableSet.of((Object)10, (Object)11, (Object)12, (Object)13, (Object)14)).put((Object)31, (Object)ImmutableSet.of((Object)0, (Object)6, (Object)12, (Object)13, (Object)14)).put((Object)32, (Object)ImmutableSet.of((Object)2, (Object)3, (Object)4, (Object)6, (Object)10)).put((Object)33, (Object)ImmutableSet.of((Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)9, (Object[])new Integer[]{14})).put((Object)34, (Object)ImmutableSet.of((Object)10, (Object)11, (Object)12, (Object)13, (Object)14, (Object)19, (Object[])new Integer[0])).put((Object)35, (Object)ImmutableSet.of((Object)9, (Object)10, (Object)11, (Object)12, (Object)13, (Object)14, (Object[])new Integer[]{19})).put((Object)36, (Object)ImmutableSet.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4, (Object)9, (Object[])new Integer[]{14})).put((Object)37, (Object)ImmutableSet.of((Object)10, (Object)11, (Object)12, (Object)13, (Object)14, (Object)19, (Object[])new Integer[]{24})).put((Object)38, (Object)ImmutableSet.of((Object)0, (Object)5, (Object)6, (Object)10, (Object)12, (Object)18, (Object[])new Integer[]{24})).put((Object)39, (Object)ImmutableSet.of((Object)2, (Object)3, (Object)4, (Object)7, (Object)10, (Object)11, (Object[])new Integer[]{12})).put((Object)40, (Object)ImmutableSet.of((Object)4, (Object)9, (Object)10, (Object)11, (Object)12, (Object)13, (Object[])new Integer[]{14})).put((Object)41, (Object)ImmutableSet.of((Object)0, (Object)4, (Object)6, (Object)9, (Object)12, (Object)13, (Object[])new Integer[]{14})).put((Object)42, (Object)ImmutableSet.of((Object)0, (Object)5, (Object)9, (Object)10, (Object)11, (Object)12, (Object[])new Integer[]{13})).put((Object)43, (Object)ImmutableSet.of((Object)0, (Object)1, (Object)5, (Object)7, (Object)10, (Object)13, (Object[])new Integer[]{19})).put((Object)44, (Object)ImmutableSet.of((Object)0, (Object)5, (Object)10, (Object)11, (Object)14, (Object)17, (Object[])new Integer[]{18})).put((Object)45, (Object)ImmutableSet.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object[])new Integer[]{10})).build();
    private static final Pattern TARGET_NUMBER_PATTERN = Pattern.compile("The number (\\d+) has been hastily chipped into the stone.");
    private final EventBus eventBus;
    private final Client client;
    private boolean solved;
    private Set<Integer> tileStates;
    private int targetNumber;
    private Set<LocalPoint> flips = Collections.emptySet();

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState raidState) {
        return config.scabarasHelperMode() == ScabarasHelperMode.OVERLAY && raidState.getCurrentRoom() == RaidRoom.SCABARAS;
    }

    @Override
    public void startUp() {
        this.eventBus.register((Object)this);
        this.targetNumber = 0;
        this.solved = false;
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister((Object)this);
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned e) {
        if (GAME_OBJECT_IDS.contains(e.getGameObject().getId())) {
            this.solved = false;
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned e) {
        if (GAME_OBJECT_IDS.contains(e.getGameObject().getId())) {
            this.solved = false;
        }
    }

    @Subscribe
    public void onGameTick(GameTick e) {
        if (!this.solved) {
            this.solve();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage e) {
        if (e.getMessage().startsWith("Your party failed to complete the challenge")) {
            this.targetNumber = 0;
            this.solved = false;
            return;
        }
        Matcher matcher = TARGET_NUMBER_PATTERN.matcher(Text.removeTags((String)e.getMessage()));
        if (!matcher.matches()) {
            return;
        }
        this.targetNumber = Integer.parseInt(matcher.group(1));
        this.solve();
    }

    private void solve() {
        this.solved = true;
        if (this.targetNumber < 20) {
            return;
        }
        Tile[][] sceneTiles = this.client.getScene().getTiles()[this.client.getPlane()];
        Point tl = this.findStartTile(sceneTiles);
        if (tl == null) {
            log.debug("Failed to locate start of addition puzzle");
            return;
        }
        this.tileStates = this.readTileStates(sceneTiles, tl);
        this.flips = this.findSolution(tl);
    }

    private Point findStartTile(Tile[][] sceneTiles) {
        for (Point sceneCoordStart : SCENE_COORD_STARTS) {
            Tile startTile = sceneTiles[sceneCoordStart.getX()][sceneCoordStart.getY()];
            GroundObject groundObject = startTile.getGroundObject();
            if (groundObject == null || groundObject.getId() != AdditionTile.FOOT.getGroundObjectId()) continue;
            return sceneCoordStart;
        }
        return null;
    }

    private Set<Integer> readTileStates(Tile[][] sceneTiles, Point topLeft) {
        HashSet<Integer> tileStates = new HashSet<Integer>();
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 5; ++x) {
                Tile additionTile = sceneTiles[topLeft.getX() + x][topLeft.getY() - y];
                boolean active = Arrays.stream(additionTile.getGameObjects()).filter(Objects::nonNull).mapToInt(TileObject::getId).anyMatch(GAME_OBJECT_IDS::contains);
                if (!active) continue;
                tileStates.add(y * 5 + x);
            }
        }
        return tileStates;
    }

    private Set<LocalPoint> findSolution(Point topLeft) {
        Sets.SetView remaining = Sets.difference(OPTIMAL_SOLUTIONS.get(this.targetNumber), this.tileStates);
        return remaining.stream().map(i -> LocalPoint.fromScene((int)(topLeft.getX() + i % 5), (int)(topLeft.getY() - i / 5))).collect(Collectors.toSet());
    }

    @Inject
    public AdditionPuzzleSolver(EventBus eventBus, Client client) {
        this.eventBus = eventBus;
        this.client = client;
    }

    public Set<LocalPoint> getFlips() {
        return this.flips;
    }

    static enum AdditionTile {
        LINE(1, 45345, 45388),
        KNIVES(2, 45346, 45389),
        TRIANGLE(3, 45347, 45390),
        DIAMOND(4, 45348, 45391),
        HAND(5, 45349, 45392),
        BIRD(6, 45350, 45393),
        CROOK(7, 45351, 45386),
        WIGGLE(8, 45352, 45394),
        FOOT(9, 45353, 45395);

        private final int value;
        private final int groundObjectId;
        private final int gameObjectId;

        private AdditionTile(int value, int groundObjectId, int gameObjectId) {
            this.value = value;
            this.groundObjectId = groundObjectId;
            this.gameObjectId = gameObjectId;
        }

        public int getValue() {
            return this.value;
        }

        public int getGroundObjectId() {
            return this.groundObjectId;
        }

        public int getGameObjectId() {
            return this.gameObjectId;
        }
    }
}

