/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.scabaras;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidRoom;
import com.duckblade.osrs.toa.util.RaidState;
import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.GameObject;
import net.runelite.api.Point;
import net.runelite.api.TileObject;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.outline.ModelOutlineRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SkipObeliskOverlay
extends Overlay
implements PluginLifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(SkipObeliskOverlay.class);
    private static final int OBELISK_ID = 43876;
    private static final Map<Point, State> QUADRANT_STATES = ImmutableMap.of((Object)new Point(36, 57), (Object)((Object)State.HIGHLIGHT_LOWER), (Object)new Point(53, 57), (Object)((Object)State.HIGHLIGHT_UPPER), (Object)new Point(36, 45), (Object)((Object)State.HIGHLIGHT_UPPER), (Object)new Point(53, 45), (Object)((Object)State.HIGHLIGHT_LOWER));
    private static final int FLAME_ID = 45135;
    private static final Point FLAME_UPPER_HALF_LOC = new Point(28, 54);
    private static final Point FLAME_LOWER_HALF_LOC = new Point(28, 42);
    private final EventBus eventBus;
    private final OverlayManager overlayManager;
    private final ModelOutlineRenderer modelOutlineRenderer;
    private State state = State.UNKNOWN;
    private GameObject flameLower;
    private GameObject flameUpper;
    private static final long BAD_RENDER_WARN_COOLDOWN = 10000L;
    private long renderWarnCooldown = System.currentTimeMillis();

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState raidState) {
        switch (config.scabarasHighlightSkipObeliskEntry()) {
            case ALWAYS: {
                return raidState.getCurrentRoom() == RaidRoom.SCABARAS;
            }
            case SOLO_ONLY: {
                return raidState.getCurrentRoom() == RaidRoom.SCABARAS && raidState.getPlayerCount() == 1;
            }
        }
        return false;
    }

    @Override
    public void startUp() {
        this.reset();
        this.eventBus.register((Object)this);
        this.overlayManager.add((Overlay)this);
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister((Object)this);
        this.overlayManager.removeIf(o -> o instanceof SkipObeliskOverlay);
    }

    private void reset() {
        this.state = State.UNKNOWN;
        this.flameLower = null;
        this.flameUpper = null;
    }

    public Dimension render(Graphics2D graphics) {
        GameObject toHighlight;
        if (this.state == State.UNKNOWN) {
            return null;
        }
        GameObject gameObject = toHighlight = this.state == State.HIGHLIGHT_LOWER ? this.flameLower : this.flameUpper;
        if (toHighlight == null && this.renderWarnCooldown < System.currentTimeMillis()) {
            log.warn("Called to render with state {} but null highlight", (Object)this.state);
            this.renderWarnCooldown = System.currentTimeMillis() + 10000L;
            return null;
        }
        this.modelOutlineRenderer.drawOutline((TileObject)toHighlight, 3, Color.green, 0);
        return null;
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned e) {
        this.checkForFlame(e.getGameObject());
        this.checkForObelisk(e.getGameObject());
    }

    @Subscribe
    public void onChatMessage(ChatMessage e) {
        if (e.getMessage().startsWith("Your party failed to complete the challenge")) {
            this.reset();
        }
    }

    private void checkForFlame(GameObject obj) {
        if (obj.getId() == 45135) {
            Point scenePoint = obj.getSceneMinLocation();
            log.debug("Found flame spawn ({}) at {}", (Object)obj.getId(), (Object)scenePoint);
            if (FLAME_UPPER_HALF_LOC.equals((Object)scenePoint)) {
                this.flameUpper = obj;
            } else if (FLAME_LOWER_HALF_LOC.equals((Object)scenePoint)) {
                this.flameLower = obj;
            }
        }
    }

    private void checkForObelisk(GameObject obj) {
        if (this.state != State.UNKNOWN || obj.getId() != 43876) {
            return;
        }
        log.debug("Found obelisk ({}) spawn at {}", (Object)obj.getId(), (Object)obj.getSceneMinLocation());
        State derivedState = QUADRANT_STATES.get(obj.getSceneMinLocation());
        if (derivedState != null) {
            log.debug("Determined that obelisk puzzle is avoided by {}", (Object)this.state);
            this.state = derivedState;
        }
    }

    @Inject
    public SkipObeliskOverlay(EventBus eventBus, OverlayManager overlayManager, ModelOutlineRenderer modelOutlineRenderer) {
        this.eventBus = eventBus;
        this.overlayManager = overlayManager;
        this.modelOutlineRenderer = modelOutlineRenderer;
    }

    static enum State {
        HIGHLIGHT_UPPER,
        HIGHLIGHT_LOWER,
        UNKNOWN;

    }

    public static enum EnableMode {
        SOLO_ONLY,
        ALWAYS,
        OFF;

    }
}

