/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.pointstracker;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.features.pointstracker.PartyPointsTracker;
import com.duckblade.osrs.toa.features.pointstracker.UniqueChanceCalculator;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidState;
import com.duckblade.osrs.toa.util.RaidStateChanged;
import com.duckblade.osrs.toa.util.RaidStateTracker;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.ItemSpawned;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PointsTracker
implements PluginLifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(PointsTracker.class);
    static final NumberFormat POINTS_FORMAT = NumberFormat.getInstance();
    static final NumberFormat PERCENT_FORMAT = new DecimalFormat("#.##%");
    private static final String START_MESSAGE = "You enter the Tombs of Amascut";
    private static final String DEATH_MESSAGE = "You have died";
    private static final String ROOM_FAIL_MESSAGE = "Your party failed to complete";
    private static final String ROOM_FINISH_MESSAGE = "Challenge complete";
    private static final int BASE_POINTS = 5000;
    private static final int MAX_ROOM_POINTS = 20000;
    private static final int MAX_TOTAL_POINTS = 69000;
    private static final int ANIMATION_ID_WARDEN_DOWN = 9670;
    private static final Map<Integer, Double> DAMAGE_POINTS_FACTORS = ImmutableMap.builder().put((Object)11770, (Object)0.0).put((Object)11771, (Object)0.0).put((Object)11772, (Object)0.0).put((Object)11782, (Object)0.0).put((Object)11783, (Object)0.0).put((Object)11709, (Object)1.2).put((Object)11712, (Object)1.2).put((Object)11710, (Object)1.2).put((Object)11713, (Object)1.2).put((Object)11711, (Object)1.2).put((Object)11714, (Object)1.2).put((Object)11715, (Object)1.2).put((Object)11716, (Object)1.2).put((Object)11717, (Object)1.2).put((Object)11718, (Object)1.2).put((Object)11778, (Object)2.0).put((Object)11779, (Object)2.0).put((Object)11780, (Object)2.0).put((Object)10680, (Object)1.5).put((Object)11730, (Object)1.5).put((Object)11732, (Object)1.5).put((Object)11733, (Object)1.5).put((Object)11725, (Object)0.5).put((Object)11724, (Object)0.5).put((Object)11726, (Object)0.5).put((Object)11707, (Object)2.5).put((Object)11750, (Object)1.5).put((Object)11751, (Object)1.5).put((Object)11752, (Object)1.5).put((Object)11746, (Object)0.0).put((Object)11748, (Object)0.0).put((Object)11747, (Object)0.0).put((Object)11749, (Object)0.0).put((Object)11759, (Object)0.0).put((Object)11760, (Object)0.0).put((Object)11753, (Object)2.0).put((Object)11754, (Object)2.0).put((Object)11755, (Object)0.0).put((Object)11756, (Object)2.0).put((Object)11757, (Object)2.0).put((Object)11758, (Object)0.0).put((Object)11761, (Object)2.5).put((Object)11763, (Object)2.5).put((Object)11762, (Object)2.5).put((Object)11764, (Object)2.5).build();
    private static final ImmutableSet<Integer> P2_WARDENS = ImmutableSet.of((Object)11753, (Object)11754, (Object)11755, (Object)11756, (Object)11757, (Object)11758, (Object[])new Integer[0]);
    private static final ImmutableSet<Integer> MVP_ITEMS = ImmutableSet.of((Object)27219, (Object)27214, (Object)27221, (Object)27223);
    private static final ImmutableSet<Integer> WARDEN_HITSPLAT_TYPES = ImmutableSet.of((Object)53, (Object)55);
    private final EventBus eventBus;
    private final Client client;
    private final TombsOfAmascutConfig config;
    private final PartyPointsTracker partyPointsTracker;
    private final RaidStateTracker raidStateTracker;
    private int personalRoomPoints;
    private int personalTotalPoints;
    private int nonPartyPoints;
    private final List<Integer> seenMvpItems = new ArrayList<Integer>(4);
    private int teamSize;
    private int raidLevel;
    private int wardenDowns;

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState raidState) {
        return raidState.isInRaid();
    }

    @Override
    public void startUp() {
        this.eventBus.register((Object)this);
        this.reset();
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister((Object)this);
    }

    @Subscribe
    public void onGameTick(GameTick e) {
        this.raidLevel = this.client.getVarbitValue(14380);
    }

    @Subscribe
    public void onRaidStateChanged(RaidStateChanged e) {
        this.teamSize = e.getNewState().getPlayerCount();
        if (e.getPreviousState() == null || e.getPreviousState().getCurrentRoom() == null) {
            return;
        }
        switch (e.getPreviousState().getCurrentRoom()) {
            case SCABARAS: {
                this.personalTotalPoints += 300;
                this.nonPartyPoints += 300;
                this.updatePersonalPartyPoints();
                break;
            }
            case APMEKEN: {
                this.personalTotalPoints += 450;
                this.nonPartyPoints += 300;
                this.updatePersonalPartyPoints();
                break;
            }
            case CRONDIS: {
                this.personalTotalPoints += 400;
                this.nonPartyPoints += 300;
                this.updatePersonalPartyPoints();
                break;
            }
            case HET: 
            case WARDENS: {
                this.nonPartyPoints += 300;
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage e) {
        if (e.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        if (e.getMessage().startsWith(START_MESSAGE)) {
            this.reset();
        } else if (e.getMessage().startsWith(DEATH_MESSAGE)) {
            this.personalTotalPoints = (int)((double)this.personalTotalPoints - Math.max(0.2 * (double)this.personalTotalPoints, 1000.0));
            if (this.personalTotalPoints < 0) {
                this.personalTotalPoints = 0;
            }
            this.updatePersonalPartyPoints();
        } else if (e.getMessage().startsWith(ROOM_FAIL_MESSAGE)) {
            this.wardenDowns = 0;
            this.personalRoomPoints = 0;
            this.updatePersonalPartyPoints();
        } else if (e.getMessage().startsWith(ROOM_FINISH_MESSAGE)) {
            this.personalTotalPoints = Math.min(69000, this.personalTotalPoints + this.personalRoomPoints);
            this.personalRoomPoints = 0;
            this.updatePersonalPartyPoints();
            if (e.getMessage().contains("Wardens") && this.config.pointsTrackerPostRaidMessage()) {
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", this.buildPointsMessage(), "", false);
            }
        }
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied e) {
        if (e.getHitsplat().getAmount() < 1 || !(e.getActor() instanceof NPC)) {
            return;
        }
        NPC target = (NPC)e.getActor();
        log.debug("Hitsplat type {} damage {} on {}", new Object[]{e.getHitsplat().getHitsplatType(), e.getHitsplat().getAmount(), target.getId()});
        if (P2_WARDENS.contains((Object)target.getId()) && this.wardenDowns > 3) {
            return;
        }
        double factor = DAMAGE_POINTS_FACTORS.getOrDefault(target.getId(), 1.0);
        if (e.getHitsplat().isMine() || WARDEN_HITSPLAT_TYPES.contains((Object)e.getHitsplat().getHitsplatType())) {
            this.personalRoomPoints = (int)Math.min(20000.0, (double)this.personalRoomPoints + (double)e.getHitsplat().getAmount() * factor);
            this.updatePersonalPartyPoints();
        }
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned e) {
        if (MVP_ITEMS.contains((Object)e.getItem().getId()) && !this.seenMvpItems.contains(e.getItem().getId())) {
            this.personalTotalPoints += 300 * this.teamSize;
            this.seenMvpItems.add(e.getItem().getId());
            this.updatePersonalPartyPoints();
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged e) {
        if (!(e.getActor() instanceof NPC) || !P2_WARDENS.contains((Object)((NPC)e.getActor()).getId())) {
            return;
        }
        if (e.getActor().getAnimation() == 9670) {
            ++this.wardenDowns;
        }
    }

    public int getPersonalTotalPoints() {
        return this.personalTotalPoints + this.personalRoomPoints - 5000;
    }

    public double getPersonalPercent() {
        if (this.raidStateTracker.getPlayerCount() == 1) {
            return 1.0;
        }
        return (double)this.getPersonalTotalPoints() / (double)this.getTotalPoints();
    }

    public int getTotalPoints() {
        if (this.partyPointsTracker.isInParty()) {
            return this.partyPointsTracker.getTotalPartyPoints();
        }
        return this.getPersonalTotalPoints() + this.nonPartyPoints;
    }

    public double getUniqueChance() {
        return UniqueChanceCalculator.getUniqueChance(this.raidLevel, this.getTotalPoints());
    }

    public double getPetChance() {
        return UniqueChanceCalculator.getPetChance(this.raidLevel, this.getTotalPoints());
    }

    private void reset() {
        this.personalTotalPoints = 5000;
        this.personalRoomPoints = 0;
        this.nonPartyPoints = 0;
        this.teamSize = 0;
        this.raidLevel = -1;
        this.wardenDowns = 0;
        this.seenMvpItems.clear();
        this.partyPointsTracker.clearPartyPointsMap();
        this.updatePersonalPartyPoints();
    }

    private void updatePersonalPartyPoints() {
        this.partyPointsTracker.sendPointsUpdate(Math.min(69000, this.personalTotalPoints + this.personalRoomPoints) - 5000);
    }

    private String buildPointsMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Total points: ");
        sb.append(ColorUtil.wrapWithColorTag((String)POINTS_FORMAT.format(this.getTotalPoints()), (Color)Color.red));
        sb.append(", Personal points: ");
        sb.append(ColorUtil.wrapWithColorTag((String)POINTS_FORMAT.format(this.getPersonalTotalPoints()), (Color)Color.red));
        sb.append(" (");
        sb.append(ColorUtil.wrapWithColorTag((String)PERCENT_FORMAT.format(this.getPersonalPercent()), (Color)Color.red));
        sb.append(")");
        return sb.toString();
    }

    @Inject
    public PointsTracker(EventBus eventBus, Client client, TombsOfAmascutConfig config, PartyPointsTracker partyPointsTracker, RaidStateTracker raidStateTracker) {
        this.eventBus = eventBus;
        this.client = client;
        this.config = config;
        this.partyPointsTracker = partyPointsTracker;
        this.raidStateTracker = raidStateTracker;
    }

    public int getPersonalRoomPoints() {
        return this.personalRoomPoints;
    }
}

