/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.invocationpresets;

import com.duckblade.osrs.toa.util.Invocation;
import com.duckblade.osrs.toa.util.RaidMode;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import net.runelite.client.util.ColorUtil;

public final class InvocationPreset {
    private final String name;
    private final Set<Invocation> invocations;

    public static InvocationPreset parse(String serialized) {
        String[] parts = serialized.trim().split(";");
        String name = parts[0];
        if (parts.length != 2) {
            if (serialized.endsWith(";")) {
                return new InvocationPreset(parts[0], Collections.emptySet());
            }
            throw new IllegalArgumentException("Invalid format");
        }
        Set<Invocation> invocations = Arrays.stream(parts[1].split(",")).map(Invocation::valueOf).collect(Collectors.toSet());
        return new InvocationPreset(name, invocations);
    }

    public String serialize() {
        return this.name + ";" + this.invocations.stream().map(Enum::name).collect(Collectors.joining(","));
    }

    public int getRaidLevel() {
        return this.invocations.stream().mapToInt(Invocation::getRaidLevel).sum();
    }

    public String toStringDecorated() {
        String nameColorTag = ColorUtil.colorTag((Color)new Color(255, 152, 31));
        String modeTag = ColorUtil.colorTag((Color)RaidMode.forRaidLevel(this.getRaidLevel()).getColor());
        return nameColorTag + this.name + " " + modeTag + "(Lvl " + this.getRaidLevel() + ")</col>";
    }

    public InvocationPreset(String name, Set<Invocation> invocations) {
        this.name = name;
        this.invocations = invocations;
    }

    public String getName() {
        return this.name;
    }

    public Set<Invocation> getInvocations() {
        return this.invocations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvocationPreset)) {
            return false;
        }
        InvocationPreset other = (InvocationPreset)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Set<Invocation> this$invocations = this.getInvocations();
        Set<Invocation> other$invocations = other.getInvocations();
        return !(this$invocations == null ? other$invocations != null : !((Object)this$invocations).equals(other$invocations));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Set<Invocation> $invocations = this.getInvocations();
        result = result * 59 + ($invocations == null ? 43 : ((Object)$invocations).hashCode());
        return result;
    }

    public String toString() {
        return "InvocationPreset(name=" + this.getName() + ", invocations=" + this.getInvocations() + ")";
    }
}

