/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.het.solver;

import com.duckblade.osrs.toa.features.het.solver.HetSolutionResult;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import net.runelite.api.GameObject;
import net.runelite.api.Point;

public class HetTileState {
    public static final int STATE_EMPTY = 0;
    public static final int STATE_MIRROR_MOVABLE = 1;
    public static final int STATE_MIRROR = 2;
    public static final int STATE_MIRROR_DIRTY = 3;
    public static final int STATE_WALL_BROKEN = 4;
    public static final int STATE_WALL_REMOVED = 5;
    public static final int STATE_WALL_STATIC = 6;
    public static final Map<Integer, Integer> OBJECT_ID_TO_STATE = ImmutableMap.builder().put((Object)45455, (Object)1).put((Object)45456, (Object)2).put((Object)45457, (Object)3).put((Object)45458, (Object)6).put((Object)45460, (Object)6).put((Object)45462, (Object)4).put((Object)45464, (Object)4).put((Object)45466, (Object)5).put((Object)29733, (Object)0).build();
    public static final int ORIENTATION_NORTH_EAST = 0;
    public static final int ORIENTATION_SOUTH_EAST = 1;
    public static final int ORIENTATION_SOUTH_WEST = 2;
    public static final int ORIENTATION_NORTH_WEST = 3;
    private final int x;
    private final int y;
    private final int state;
    private final int orientation;

    public HetTileState(int x, int y, int state) {
        this(x, y, state, 0);
    }

    public static HetTileState fromGameObject(GameObject o, Point puzzleBase) {
        Point p = o.getSceneMinLocation();
        return new HetTileState(p.getX() - puzzleBase.getX(), p.getY() - puzzleBase.getY(), OBJECT_ID_TO_STATE.getOrDefault(o.getId(), 0), (o.getConfig() & 0xC0) >> 6);
    }

    public HetSolutionResult conversionScoreTo(HetTileState other) {
        assert (other != null);
        assert (this.x == other.x);
        assert (this.y == other.y);
        if (this.state == other.state) {
            return this.orientation == other.orientation ? new HetSolutionResult(true, 0, 0, 0, Collections.emptyList()) : new HetSolutionResult(true, 0, 1, 0, other);
        }
        switch (this.state) {
            case 6: {
                return new HetSolutionResult(false, 0, 0, 0, other);
            }
            case 2: 
            case 3: {
                HetTileState maybeClean;
                HetTileState hetTileState = maybeClean = this.state == 3 ? other : null;
                if (other.state == 1 && this.orientation == other.orientation) {
                    return new HetSolutionResult(true, 0, maybeClean == null ? 0 : 1, 0, maybeClean);
                }
                return new HetSolutionResult(false, 0, 0, 0, other);
            }
            case 0: 
            case 4: 
            case 5: {
                HetTileState maybeWallRemove;
                HetTileState hetTileState = maybeWallRemove = this.state == 4 ? other : null;
                if (other.state == 0) {
                    return new HetSolutionResult(true, 0, 0, maybeWallRemove == null ? 0 : 1, maybeWallRemove);
                }
                if (other.state == 1) {
                    return new HetSolutionResult(true, 1, 0, maybeWallRemove == null ? 0 : 1, other);
                }
            }
            case 1: {
                return new HetSolutionResult(true, 0, 0, 0, other);
            }
        }
        return new HetSolutionResult(false, 0, 0, 0, other);
    }

    public boolean stateResetsSolution() {
        switch (this.state) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                return false;
            }
        }
        return true;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getState() {
        return this.state;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HetTileState)) {
            return false;
        }
        HetTileState other = (HetTileState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        if (this.getState() != other.getState()) {
            return false;
        }
        return this.getOrientation() == other.getOrientation();
    }

    protected boolean canEqual(Object other) {
        return other instanceof HetTileState;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        result = result * 59 + this.getState();
        result = result * 59 + this.getOrientation();
        return result;
    }

    public String toString() {
        return "HetTileState(x=" + this.getX() + ", y=" + this.getY() + ", state=" + this.getState() + ", orientation=" + this.getOrientation() + ")";
    }

    public HetTileState(int x, int y, int state, int orientation) {
        this.x = x;
        this.y = y;
        this.state = state;
        this.orientation = orientation;
    }
}

