/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.het.solver;

import com.duckblade.osrs.toa.features.het.solver.HetTileState;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class HetSolutionResult
implements Comparable<HetSolutionResult> {
    private static final int MAX_MIRRORS = 3;
    private static final Comparator<HetSolutionResult> COMPARATOR = Comparator.comparingInt(hs -> hs.completable ? Integer.MIN_VALUE : Integer.MAX_VALUE).thenComparingInt(HetSolutionResult::getMirrorsToMove).thenComparingInt(HetSolutionResult::getWallsToBreak).thenComparingInt(HetSolutionResult::getMirrorsToAlter);
    private boolean completable;
    private int mirrorsToMove;
    private int mirrorsToAlter;
    private int wallsToBreak;
    private List<HetTileState> incorrectStates;

    public HetSolutionResult(boolean completable, int mirrorsToMove, int mirrorsToAlter, int wallsToBreak, HetTileState wrongState) {
        this(completable, mirrorsToMove, mirrorsToAlter, wallsToBreak, wrongState != null ? Collections.singletonList(wrongState) : Collections.emptyList());
    }

    public void add(HetSolutionResult other) {
        this.mirrorsToMove += other.mirrorsToMove;
        this.mirrorsToAlter += other.mirrorsToAlter;
        this.wallsToBreak += other.wallsToBreak;
        this.completable = this.completable && other.completable && this.mirrorsToMove <= 3;
        this.incorrectStates.addAll(other.incorrectStates);
    }

    @Override
    public int compareTo(HetSolutionResult o) {
        return COMPARATOR.compare(this, o);
    }

    @VisibleForTesting
    public String getOverlayString() {
        if (!this.completable) {
            if (this.incorrectStates.isEmpty()) {
                return " FAIL ???";
            }
            HetTileState lastBadState = this.incorrectStates.get(this.incorrectStates.size() - 1);
            return " FAIL " + lastBadState.getX() + ", " + lastBadState.getY();
        }
        return "M" + this.mirrorsToMove + " / W" + this.wallsToBreak + " / A" + this.mirrorsToAlter;
    }

    public boolean isCompletable() {
        return this.completable;
    }

    public int getMirrorsToMove() {
        return this.mirrorsToMove;
    }

    public int getMirrorsToAlter() {
        return this.mirrorsToAlter;
    }

    public int getWallsToBreak() {
        return this.wallsToBreak;
    }

    public List<HetTileState> getIncorrectStates() {
        return this.incorrectStates;
    }

    public void setCompletable(boolean completable) {
        this.completable = completable;
    }

    public void setMirrorsToMove(int mirrorsToMove) {
        this.mirrorsToMove = mirrorsToMove;
    }

    public void setMirrorsToAlter(int mirrorsToAlter) {
        this.mirrorsToAlter = mirrorsToAlter;
    }

    public void setWallsToBreak(int wallsToBreak) {
        this.wallsToBreak = wallsToBreak;
    }

    public void setIncorrectStates(List<HetTileState> incorrectStates) {
        this.incorrectStates = incorrectStates;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HetSolutionResult)) {
            return false;
        }
        HetSolutionResult other = (HetSolutionResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCompletable() != other.isCompletable()) {
            return false;
        }
        if (this.getMirrorsToMove() != other.getMirrorsToMove()) {
            return false;
        }
        if (this.getMirrorsToAlter() != other.getMirrorsToAlter()) {
            return false;
        }
        if (this.getWallsToBreak() != other.getWallsToBreak()) {
            return false;
        }
        List<HetTileState> this$incorrectStates = this.getIncorrectStates();
        List<HetTileState> other$incorrectStates = other.getIncorrectStates();
        return !(this$incorrectStates == null ? other$incorrectStates != null : !((Object)this$incorrectStates).equals(other$incorrectStates));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HetSolutionResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCompletable() ? 79 : 97);
        result = result * 59 + this.getMirrorsToMove();
        result = result * 59 + this.getMirrorsToAlter();
        result = result * 59 + this.getWallsToBreak();
        List<HetTileState> $incorrectStates = this.getIncorrectStates();
        result = result * 59 + ($incorrectStates == null ? 43 : ((Object)$incorrectStates).hashCode());
        return result;
    }

    public String toString() {
        return "HetSolutionResult(completable=" + this.isCompletable() + ", mirrorsToMove=" + this.getMirrorsToMove() + ", mirrorsToAlter=" + this.getMirrorsToAlter() + ", wallsToBreak=" + this.getWallsToBreak() + ", incorrectStates=" + this.getIncorrectStates() + ")";
    }

    public HetSolutionResult(boolean completable, int mirrorsToMove, int mirrorsToAlter, int wallsToBreak, List<HetTileState> incorrectStates) {
        this.completable = completable;
        this.mirrorsToMove = mirrorsToMove;
        this.mirrorsToAlter = mirrorsToAlter;
        this.wallsToBreak = wallsToBreak;
        this.incorrectStates = incorrectStates;
    }
}

