/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.het.pickaxe;

import com.duckblade.osrs.toa.util.InventoryUtil;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;

public final class PickaxeUtil {
    private static final Set<Integer> PICKAXE_IDS = ImmutableSet.of((Object)1265, (Object)1267, (Object)1269, (Object)12297, (Object)1273, (Object)1271, (Object[])new Integer[]{1275, 11920, 12797, 23677, 25376, 13243, 25063, 13244, 25369, 23680, 23863, 23682, 20014, 23276, 25112});
    private static final int VARBIT_PICKAXE_STORAGE = 14440;

    public static boolean hasPickaxe(Client client) {
        ItemContainer inv = client.getItemContainer(InventoryID.INVENTORY);
        ItemContainer equip = client.getItemContainer(InventoryID.EQUIPMENT);
        if (inv == null && equip == null) {
            return false;
        }
        return inv != null && InventoryUtil.containsAny(inv, PICKAXE_IDS) || equip != null && InventoryUtil.containsAny(equip, PICKAXE_IDS);
    }

    public static boolean pickaxeIsInStorage(Client client) {
        return client.getVarbitValue(14440) != 0;
    }

    private PickaxeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

