/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.het.pickaxe;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.features.het.pickaxe.PickaxeUtil;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidRoom;
import com.duckblade.osrs.toa.util.RaidState;
import com.duckblade.osrs.toa.util.RaidStateTracker;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.IdentityHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.Point;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

@Singleton
public class DepositPickaxeOverlay
extends Overlay
implements PluginLifecycleComponent {
    private static final int OBJECT_AKKHA_ENTRY = 45131;
    private static final int OBJECT_RAID_ENTRY = 46089;
    private static final int OBJECT_EMPTY_CAVITY = 49566;
    private static final int OBJECT_STATUE = 45468;
    private static final Color OVERLAY_COLOR = new Color(225, 163, 12);
    private static final String WARNING_TEXT = "Deposit a pickaxe.";
    private final EventBus eventBus;
    private final OverlayManager overlayManager;
    private final Client client;
    private final RaidStateTracker raidStateTracker;
    private IdentityHashMap<GameObject, Boolean> highlightObjects;
    private GameObject entry;
    private boolean roomComplete;

    @Inject
    public DepositPickaxeOverlay(EventBus eventBus, OverlayManager overlayManager, Client client, RaidStateTracker raidStateTracker) {
        this.eventBus = eventBus;
        this.overlayManager = overlayManager;
        this.client = client;
        this.raidStateTracker = raidStateTracker;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState raidState) {
        return raidState.getCurrentRoom() == RaidRoom.HET && config.hetPickaxePuzzleOverlay() || raidState.isInLobby() && config.hetPickaxeLobbyOverlay();
    }

    @Override
    public void startUp() {
        this.entry = null;
        this.highlightObjects = new IdentityHashMap();
        this.roomComplete = false;
        this.eventBus.register((Object)this);
        this.overlayManager.add((Overlay)this);
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister((Object)this);
        this.overlayManager.removeIf(o -> o instanceof DepositPickaxeOverlay);
    }

    public Dimension render(Graphics2D graphics) {
        Point textPoint;
        if (PickaxeUtil.pickaxeIsInStorage(this.client)) {
            return null;
        }
        if (!(this.raidStateTracker.getCurrentState().getCurrentRoom() != RaidRoom.HET || this.roomComplete && PickaxeUtil.hasPickaxe(this.client))) {
            return null;
        }
        for (GameObject toHighlight : this.highlightObjects.keySet()) {
            Shape hull = toHighlight.getConvexHull();
            if (hull == null) continue;
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)hull, (Color)OVERLAY_COLOR);
        }
        if (this.entry != null && (textPoint = this.entry.getCanvasTextLocation(graphics, WARNING_TEXT, 0)) != null) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textPoint, (String)WARNING_TEXT, (Color)OVERLAY_COLOR);
        }
        return null;
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned e) {
        switch (e.getGameObject().getId()) {
            case 45468: 
            case 49566: {
                this.highlightObjects.put(e.getGameObject(), true);
                break;
            }
            case 45131: 
            case 46089: {
                this.entry = e.getGameObject();
            }
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned e) {
        switch (e.getGameObject().getId()) {
            case 45468: 
            case 49566: {
                this.highlightObjects.remove(e.getGameObject());
                break;
            }
            case 45131: 
            case 46089: {
                this.entry = null;
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage e) {
        if (e.getType() == ChatMessageType.GAMEMESSAGE && e.getMessage().startsWith("Challenge complete")) {
            this.roomComplete = true;
        }
    }
}

