/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.het.beamtimer;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidRoom;
import com.duckblade.osrs.toa.util.RaidState;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.api.events.NpcChanged;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;

@Singleton
public class BeamTimerTracker
implements PluginLifecycleComponent {
    private static final String CHALLENGE_START_MESSAGE = "Challenge started: Path of Het.";
    private static final String CHALLENGE_COMPLETE_MESSAGE = "Challenge complete: Path of Het.";
    private static final int BEAM_FIRE_RATE_TICKS = 9;
    private static final Set<Integer> BEAM_GRAPHICS_OBJECT_IDS = ImmutableSet.of((Object)2114, (Object)2064, (Object)2120);
    private final EventBus eventBus;
    private final Client client;
    private GameObject casterStatue;
    private int nextFireTick = -1;

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState raidState) {
        return config.hetBeamTimerEnable() && raidState.getCurrentRoom() == RaidRoom.HET;
    }

    @Override
    public void startUp() {
        this.eventBus.register((Object)this);
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister((Object)this);
    }

    @Subscribe
    public void onChatMessage(ChatMessage e) {
        if (e.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        if (e.getMessage().equals(CHALLENGE_START_MESSAGE)) {
            this.nextFireTick = this.client.getTickCount() + 9 + 1;
        } else if (e.getMessage().equals(CHALLENGE_COMPLETE_MESSAGE)) {
            this.nextFireTick = -1;
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned e) {
        if (e.getGameObject().getId() == 45486) {
            this.casterStatue = e.getGameObject();
        }
    }

    @Subscribe
    public void onGraphicsObjectCreated(GraphicsObjectCreated e) {
        if (BEAM_GRAPHICS_OBJECT_IDS.contains(e.getGraphicsObject().getId())) {
            this.nextFireTick = this.client.getTickCount() + 9;
        }
    }

    @Subscribe
    public void onNpcChanged(NpcChanged e) {
        if (e.getOld().getId() == 11707 && e.getNpc().getId() == 11706) {
            this.nextFireTick = this.client.getTickCount() + 9 + 1;
        } else if (e.getOld().getId() == 11706 && e.getNpc().getId() == 11707) {
            this.nextFireTick = -1;
        }
    }

    public double getProgress() {
        return (double)(this.nextFireTick - this.client.getTickCount()) / 9.0;
    }

    @Inject
    public BeamTimerTracker(EventBus eventBus, Client client) {
        this.eventBus = eventBus;
        this.client = client;
    }

    public GameObject getCasterStatue() {
        return this.casterStatue;
    }
}

