/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.apmeken;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.features.apmeken.ApmekenWavePanel;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidRoom;
import com.duckblade.osrs.toa.util.RaidState;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.SwingUtilities;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;

@Singleton
public class ApmekenWaveInstaller
implements PluginLifecycleComponent {
    private static final BufferedImage PANEL_ICON = ImageUtil.loadImageResource(ApmekenWaveInstaller.class, (String)"icon.png");
    private final ClientToolbar clientToolbar;
    private final ApmekenWavePanel apmekenWavePanel;
    private NavigationButton navButton;

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState raidState) {
        return config.apmekenWaveHelper() && raidState.getCurrentRoom() == RaidRoom.APMEKEN;
    }

    @Override
    public void startUp() {
        if (this.navButton == null) {
            this.navButton = NavigationButton.builder().icon(PANEL_ICON).panel((PluginPanel)this.apmekenWavePanel).priority(999).tooltip("Apmeken Waves").build();
        }
        this.openPanel();
    }

    @Override
    public void shutDown() {
        this.removePanel();
    }

    private void openPanel() {
        this.clientToolbar.addNavigation(this.navButton);
        SwingUtilities.invokeLater(() -> {
            if (!this.navButton.isSelected()) {
                this.navButton.getOnSelect().run();
            }
        });
    }

    private void removePanel() {
        this.navButton.setSelected(false);
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Inject
    public ApmekenWaveInstaller(ClientToolbar clientToolbar, ApmekenWavePanel apmekenWavePanel) {
        this.clientToolbar = clientToolbar;
        this.apmekenWavePanel = apmekenWavePanel;
    }
}

