/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidState;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.SpritePixels;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageCapture;
import net.runelite.client.util.ImageUploadStyle;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InvocationScreenshot
implements PluginLifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(InvocationScreenshot.class);
    private static final int INVOCATION_GROUP_ID = 774;
    private static final int INVOCATION_TITLE_CHILD_ID = 3;
    private static final int INVOCATION_CONTAINER_CHILD_ID = 52;
    private static final int INVOCATION_RIGHT_SIDE_CONTAINER_CHILD_ID = 57;
    private static final int INVOCATION_INFO_CONTAINER_CHILD_ID = 58;
    private static final int INVOCATION_REWARDS_CONTAINER_CHILD_ID = 87;
    private static final int REWARD_BUTTON_SELECTED_VARC = 1086;
    private static final int TOA_PARTY_WIDGET_SCRIPT_ID = 6617;
    private static final BufferedImage CAMERA_IMG = ImageUtil.loadImageResource(InvocationScreenshot.class, (String)"camera.png");
    private static final int CAMERA_OVERRIDE_SPRITE_IDX = -420;
    private static final int CAMERA_HOVER_OVERRIDE_SPRITE_IDX = -421;
    private final EventBus eventBus;
    private final Client client;
    private final TombsOfAmascutConfig config;
    private final ClientThread clientThread;
    private final SpriteManager spriteManager;
    private final ImageCapture imageCapture;
    private final ItemManager itemManager;
    private Widget button = null;

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState currentState) {
        return config.invocationScreenshotEnable();
    }

    @Override
    public void startUp() {
        this.eventBus.register((Object)this);
        this.clientThread.invokeLater(this::createButton);
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister((Object)this);
        this.button = null;
        this.removeCameraIconOverride();
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired e) {
        if (e.getScriptId() != 6617) {
            return;
        }
        this.createButton();
    }

    private void addCameraIconOverride() {
        this.client.getWidgetSpriteCache().reset();
        this.spriteManager.getSpriteAsync(170, 0, img -> {
            BufferedImage cameraImg = InvocationScreenshot.overlapImages(CAMERA_IMG, img);
            this.client.getSpriteOverrides().put(-420, ImageUtil.getImageSpritePixels((BufferedImage)cameraImg, (Client)this.client));
        });
        this.spriteManager.getSpriteAsync(179, 0, img -> {
            BufferedImage cameraImg = InvocationScreenshot.overlapImages(CAMERA_IMG, img);
            this.client.getSpriteOverrides().put(-421, ImageUtil.getImageSpritePixels((BufferedImage)cameraImg, (Client)this.client));
        });
    }

    private void removeCameraIconOverride() {
        this.client.getWidgetSpriteCache().reset();
        this.client.getSpriteOverrides().remove(-420);
        this.client.getSpriteOverrides().remove(-421);
    }

    private void createButton() {
        Widget parent = this.client.getWidget(774, 3);
        if (parent == null) {
            return;
        }
        Widget[] children = parent.getDynamicChildren();
        if (children == null || children.length == 0) {
            return;
        }
        for (Widget child : children) {
            if (!child.equals(this.button)) continue;
            return;
        }
        this.addCameraIconOverride();
        this.button = parent.createChild(-1, 5);
        this.button.setOriginalHeight(20);
        this.button.setOriginalWidth(20);
        this.button.setOriginalX(430);
        this.button.setOriginalY(8);
        this.button.setSpriteId(-420);
        this.button.setAction(0, "Screenshot Invocations");
        this.button.setOnOpListener(new Object[]{e -> this.clientThread.invokeLater(this::screenshot)});
        this.button.setHasListener(true);
        this.button.revalidate();
        this.button.setOnMouseOverListener(new Object[]{e -> this.button.setSpriteId(-421)});
        this.button.setOnMouseLeaveListener(new Object[]{e -> this.button.setSpriteId(-420)});
    }

    private void screenshot() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.client.getWidgetSpriteCache().reset();
        Widget container = this.client.getWidget(774, 52);
        if (container == null) {
            return;
        }
        Widget[] children = container.getDynamicChildren();
        if (children.length == 0) {
            return;
        }
        int height = children[0].getHeight() + children[0].getRelativeY();
        int y = 0;
        for (Widget invocation : children) {
            if (invocation.getRelativeY() <= y) continue;
            y = invocation.getRelativeY() + 2;
            height = y + invocation.getHeight();
        }
        int width = 287;
        boolean rewardButtonSelected = this.isRewardButtonSelected();
        if (!rewardButtonSelected) {
            width = container.getWidth();
        } else if (this.config.showRewardsSection()) {
            Widget rightSideContainer = this.client.getWidget(774, 57);
            assert (rightSideContainer != null);
            width += rightSideContainer.getWidth();
        }
        BufferedImage screenshot = new BufferedImage(width, height, 2);
        Graphics graphics = screenshot.getGraphics();
        BufferedImage background = this.getSprite(297);
        int x = screenshot.getWidth() / background.getWidth() + 1;
        y = screenshot.getHeight() / background.getHeight() + 1;
        for (int i = 0; i < x; ++i) {
            for (int z = 0; z < y; ++z) {
                graphics.drawImage(background, i * background.getWidth(), z * background.getHeight(), null);
            }
        }
        for (Widget w : children) {
            if (w.getType() == 3) continue;
            this.drawWidget(graphics, w, w.getRelativeX(), w.getRelativeY());
        }
        if (rewardButtonSelected && this.config.showRewardsSection()) {
            Widget rewardsContainer;
            Widget rightSideContainer = this.client.getWidget(774, 57);
            assert (rightSideContainer != null);
            Widget infoContainer = this.client.getWidget(774, 58);
            int infoContainerHeight = 5;
            if (infoContainer != null && infoContainer.getStaticChildren().length > 0) {
                infoContainerHeight += infoContainer.getHeight();
                Graphics layer = graphics.create(rightSideContainer.getRelativeX() - 30, rightSideContainer.getRelativeY() - 60, rightSideContainer.getWidth(), rightSideContainer.getHeight());
                Widget[] infoContainerChildren = infoContainer.getStaticChildren();
                infoContainerChildren[0] = null;
                infoContainerChildren[1] = null;
                this.drawWidgets(layer, infoContainerChildren);
                layer.dispose();
            }
            if ((rewardsContainer = this.client.getWidget(774, 87)) != null && rewardsContainer.getDynamicChildren().length > 0) {
                Graphics layer = graphics.create(rightSideContainer.getRelativeX() - 30, rightSideContainer.getRelativeY() - 60 + infoContainerHeight, rightSideContainer.getWidth(), rightSideContainer.getHeight());
                this.drawWidgets(layer, rewardsContainer.getDynamicChildren());
                layer.dispose();
            } else {
                log.warn("Couldn't find the invocation rewards container when it should have existed");
            }
        }
        BufferedImage out = InvocationScreenshot.toBufferedImageOfType(screenshot, 1);
        this.imageCapture.takeScreenshot(out, "invocationscreenshot", "invocations", true, ImageUploadStyle.CLIPBOARD);
        String message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("A screenshot of your current invocations was saved and inserted into your clipboard!").build();
        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", message, null);
    }

    private void drawWidgets(Graphics graphics, Widget[] widgets) {
        for (Widget w : widgets) {
            if (w == null) continue;
            if (w.getDynamicChildren().length > 0) {
                Graphics layer = graphics.create(w.getRelativeX(), w.getRelativeY(), w.getWidth(), w.getHeight());
                this.drawWidgets(layer, w.getDynamicChildren());
                layer.dispose();
                continue;
            }
            this.drawWidget(graphics, w, w.getRelativeX(), w.getRelativeY());
        }
    }

    private void drawWidget(Graphics graphics, Widget child, int x, int y) {
        if (child == null || child.getType() == 0) {
            return;
        }
        int width = child.getWidth();
        int height = child.getHeight();
        if (child.getSpriteId() > 0) {
            SpritePixels sp = this.getPixels(child.getSpriteId());
            assert (sp != null);
            BufferedImage childImage = sp.toBufferedImage();
            if (child.getSpriteTiling()) {
                Rectangle clips = graphics.getClipBounds();
                graphics.setClip(x, y, child.getWidth(), child.getHeight());
                for (int dx = x; dx < child.getWidth() + x; dx += sp.getMaxWidth()) {
                    for (int dy = y; dy < child.getHeight() + y; dy += sp.getMaxHeight()) {
                        this.drawAt(graphics, childImage, dx + sp.getOffsetX(), dy + sp.getOffsetY());
                    }
                }
                graphics.setClip(clips);
            } else if (width == childImage.getWidth() && height == childImage.getHeight()) {
                this.drawAt(graphics, childImage, x, y);
            } else {
                this.drawScaled(graphics, childImage, x, y, width, height);
            }
        } else if (child.getItemId() > 0) {
            Object image = this.itemManager.getImage(this.itemManager.canonicalize(child.getItemId()), 1, false);
            if (child.getOpacity() > 0) {
                image = ImageUtil.alphaOffset((Image)image, (float)((float)child.getOpacity() / 255.0f));
                BufferedImage copy = new BufferedImage(((BufferedImage)image).getWidth(), ((BufferedImage)image).getHeight(), 1);
                Graphics2D g = copy.createGraphics();
                g.setComposite(AlphaComposite.Src);
                g.setColor(new Color(0, 0, 0, child.getOpacity()));
                g.drawImage((Image)image, 0, 0, null);
                g.dispose();
            }
            graphics.drawImage((Image)image, child.getRelativeX(), child.getRelativeY(), null);
        } else if (child.getType() == 4) {
            String text = Text.removeTags((String)child.getText());
            Font font = FontManager.getRunescapeSmallFont();
            x = child.getRelativeX();
            y = child.getRelativeY();
            width = child.getWidth();
            height = child.getHeight();
            Graphics textLayer = graphics.create(x, y, width, height);
            textLayer.setFont(font);
            int xPos = 0;
            int yPos = 0;
            int textWidth = textLayer.getFontMetrics().stringWidth(text);
            if (child.getXTextAlignment() == 1) {
                xPos = (width - textWidth) / 2 + 1;
            }
            if (child.getYTextAlignment() == 0) {
                yPos = font.getSize() - 3;
            } else if (child.getYTextAlignment() == 1) {
                yPos = (height + font.getSize()) / 2 - 1;
            } else if (child.getYTextAlignment() == 2) {
                yPos = height;
            }
            if (child.getTextShadowed()) {
                textLayer.setColor(Color.BLACK);
                textLayer.drawString(text, xPos, yPos);
                --xPos;
                --yPos;
            }
            textLayer.setColor(new Color(child.getTextColor()));
            textLayer.drawString(text, xPos, yPos);
            textLayer.dispose();
        } else if (child.getType() == 3 || child.getType() == 5) {
            Color c = new Color(child.getTextColor());
            if (child.getOpacity() > 0) {
                c = new Color(c.getRed(), c.getGreen(), c.getBlue(), child.getOpacity());
            }
            graphics.setColor(c);
            Rectangle r = child.getBounds();
            graphics.drawRect(child.getRelativeX(), child.getRelativeY(), r.width, r.height);
        }
    }

    @Nullable
    private SpritePixels getPixels(int archive) {
        SpritePixels pixels;
        if (this.config.useResourcePack() && (pixels = (SpritePixels)this.client.getSpriteOverrides().get(archive)) != null) {
            return pixels;
        }
        SpritePixels[] sp = this.client.getSprites(this.client.getIndexSprites(), archive, 0);
        assert (sp != null);
        return sp[0];
    }

    private BufferedImage getSprite(int id) {
        SpritePixels sp = this.getPixels(id);
        assert (sp != null);
        return sp.toBufferedImage();
    }

    private void drawScaled(Graphics graphics, BufferedImage image, int x, int y, int width, int height) {
        image = ImageUtil.resizeCanvas((BufferedImage)image, (int)width, (int)height);
        graphics.drawImage(image, x, y, null);
    }

    private void drawAt(Graphics graphics, BufferedImage image, int x, int y) {
        graphics.drawImage(image, x, y, null);
    }

    private static BufferedImage overlapImages(BufferedImage foreground, BufferedImage background) {
        int centeredX = background.getWidth() / 2 - foreground.getWidth() / 2;
        int centeredY = background.getHeight() / 2 - foreground.getHeight() / 2;
        BufferedImage combined = new BufferedImage(background.getWidth(), background.getHeight(), 2);
        Graphics2D g2d = combined.createGraphics();
        g2d.drawImage((Image)background, 0, 0, null);
        g2d.drawImage((Image)foreground, centeredX, centeredY, null);
        g2d.dispose();
        return combined;
    }

    private static BufferedImage toBufferedImageOfType(BufferedImage original, int type) {
        if (original == null || original.getType() == type) {
            return original;
        }
        BufferedImage out = new BufferedImage(original.getWidth(), original.getHeight(), type);
        Graphics2D g = out.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.drawImage((Image)original, 0, 0, null);
        g.dispose();
        return out;
    }

    private boolean isRewardButtonSelected() {
        return this.client.getVarcIntValue(1086) == 0;
    }

    @Inject
    public InvocationScreenshot(EventBus eventBus, Client client, TombsOfAmascutConfig config, ClientThread clientThread, SpriteManager spriteManager, ImageCapture imageCapture, ItemManager itemManager) {
        this.eventBus = eventBus;
        this.client = client;
        this.config = config;
        this.clientThread = clientThread;
        this.spriteManager = spriteManager;
        this.imageCapture = imageCapture;
        this.itemManager = itemManager;
    }
}

