/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa;

import com.duckblade.osrs.toa.ConfigMigrationService;
import com.duckblade.osrs.toa.module.ComponentManager;
import com.duckblade.osrs.toa.module.TombsOfAmascutModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import net.runelite.client.RuneLite;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Tombs of Amascut", description="Utilities and information for raiding the Tombs of Amascut.", tags={"toa", "raid", "3", "invocation", "preset"})
public class TombsOfAmascutPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TombsOfAmascutPlugin.class);
    public static final File TOA_FOLDER = new File(RuneLite.RUNELITE_DIR, "tombs-of-amascut");
    @Inject
    private Injector injector;
    @Inject
    private ConfigMigrationService configMigrationService;
    private ComponentManager componentManager = null;

    public void configure(Binder binder) {
        binder.install((Module)new TombsOfAmascutModule());
    }

    protected void startUp() throws Exception {
        if (!TOA_FOLDER.exists() && !TOA_FOLDER.mkdirs()) {
            log.warn("Failed to create ToA folder {}", (Object)TOA_FOLDER.getAbsolutePath());
        }
        this.configMigrationService.migrate();
        if (this.componentManager == null) {
            this.componentManager = (ComponentManager)this.injector.getInstance(ComponentManager.class);
        }
        this.componentManager.onPluginStart();
    }

    protected void shutDown() throws Exception {
        this.componentManager.onPluginStop();
    }
}

