/*
 * Decompiled with CFR 0.152.
 */
package matsyir.pvpperformancetracker.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import matsyir.pvpperformancetracker.PvpPerformanceTrackerPlugin;
import matsyir.pvpperformancetracker.controllers.FightPerformance;
import matsyir.pvpperformancetracker.controllers.Fighter;
import matsyir.pvpperformancetracker.views.FightAnalysisFrame;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.LinkBrowser;

public class TotalStatsPanel
extends JPanel {
    private static final String WIKI_HELP_URL = "https://github.com/Matsyir/pvp-performance-tracker/wiki#pvp-performance-tracker";
    private static final NumberFormat nf = NumberFormat.getInstance();
    private static final NumberFormat nf1;
    private static final NumberFormat nf2;
    private static final int LAYOUT_ROWS_WITH_WARNING = 10;
    private static final int LAYOUT_ROWS_WITHOUT_WARNING = 9;
    private JLabel killsLabel;
    private JLabel deathsLabel;
    private JLabel offPrayStatsLabel;
    private JLabel deservedDmgStatsLabel;
    private JLabel dmgDealtStatsLabel;
    private JLabel magicHitCountStatsLabel;
    private JLabel offensivePrayCountStatsLabel;
    private JLabel hpHealedStatsLabel;
    private JLabel ghostBarrageStatsLabel;
    private JLabel settingsWarningLabel;
    private Fighter totalStats = new Fighter("Player");
    private int numFights = 0;
    private int numKills = 0;
    private int numDeaths = 0;
    private double totalDeservedDmg = 0.0;
    private double totalDeservedDmgDiff = 0.0;
    private double avgDeservedDmg = 0.0;
    private double avgDeservedDmgDiff = 0.0;
    private double killTotalDeservedDmg = 0.0;
    private double killTotalDeservedDmgDiff = 0.0;
    private double killAvgDeservedDmg = 0.0;
    private double killAvgDeservedDmgDiff = 0.0;
    private double deathTotalDeservedDmg = 0.0;
    private double deathTotalDeservedDmgDiff = 0.0;
    private double deathAvgDeservedDmg = 0.0;
    private double deathAvgDeservedDmgDiff = 0.0;
    private double totalDmgDealt = 0.0;
    private double totalDmgDealtDiff = 0.0;
    private double avgDmgDealt = 0.0;
    private double avgDmgDealtDiff = 0.0;
    private double killTotalDmgDealt = 0.0;
    private double killTotalDmgDealtDiff = 0.0;
    private double killAvgDmgDealt = 0.0;
    private double killAvgDmgDealtDiff = 0.0;
    private double deathTotalDmgDealt = 0.0;
    private double deathTotalDmgDealtDiff = 0.0;
    private double deathAvgDmgDealt = 0.0;
    private double deathAvgDmgDealtDiff = 0.0;
    private double avgHpHealed = 0.0;
    private double avgGhostBarrageCount = 0.0;
    private double avgGhostBarrageDeservedDamage = 0.0;

    public TotalStatsPanel() {
        this.setLayout(new GridLayout(PvpPerformanceTrackerPlugin.CONFIG.settingsConfigured() ? 9 : 10, 1));
        this.setBorder(new EmptyBorder(4, 6, 4, 6));
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem viewWiki = new JMenuItem("<html><u>View Wiki</u>&nbsp;&#8599;</html>");
        viewWiki.addActionListener(e -> LinkBrowser.browse((String)WIKI_HELP_URL));
        viewWiki.setForeground(ColorScheme.GRAND_EXCHANGE_LIMIT);
        JMenuItem removeAllFights = new JMenuItem("Remove All Fights");
        removeAllFights.addActionListener(e -> {
            int dialogResult = JOptionPane.showConfirmDialog(this, "Are you sure you want to reset all fight history data? This cannot be undone.", "Warning", 0);
            if (dialogResult == 0) {
                PvpPerformanceTrackerPlugin.PLUGIN.resetFightHistory();
            }
        });
        JMenuItem exportFightHistory = new JMenuItem("Copy Fight History Data");
        exportFightHistory.addActionListener(e -> PvpPerformanceTrackerPlugin.PLUGIN.exportFightHistory());
        JMenuItem importFightHistory = new JMenuItem("Import Fight History Data");
        importFightHistory.addActionListener(e -> {
            String fightHistoryData = JOptionPane.showInputDialog(this, "Enter the fight history data you wish to import:", "Import Fight History", 1);
            if (fightHistoryData == null || fightHistoryData.length() < 2) {
                return;
            }
            PvpPerformanceTrackerPlugin.PLUGIN.importUserFightHistoryData(fightHistoryData);
        });
        JMenuItem fightAnalysis = new JMenuItem("Fight Analysis (Advanced)");
        fightAnalysis.addActionListener(e -> new FightAnalysisFrame(this.getRootPane()));
        fightAnalysis.setForeground(ColorScheme.BRAND_ORANGE);
        popupMenu.add(viewWiki);
        popupMenu.add(removeAllFights);
        popupMenu.add(exportFightHistory);
        popupMenu.add(importFightHistory);
        popupMenu.add(fightAnalysis);
        this.setComponentPopupMenu(popupMenu);
        JLabel titleLabel = new JLabel();
        titleLabel.setText("PvP Performance Tracker v" + "1.5.7");
        titleLabel.setHorizontalAlignment(0);
        titleLabel.setForeground(Color.WHITE);
        this.add(titleLabel);
        if (!PvpPerformanceTrackerPlugin.CONFIG.settingsConfigured()) {
            this.initializeSettingsWarningLabel();
            this.add(this.settingsWarningLabel);
        }
        JPanel killDeathPanel = new JPanel(new BorderLayout());
        this.killsLabel = new JLabel();
        this.killsLabel.setText(this.numKills + " Kills");
        this.killsLabel.setForeground(Color.WHITE);
        killDeathPanel.add((Component)this.killsLabel, "West");
        this.deathsLabel = new JLabel();
        this.deathsLabel.setText(this.numDeaths + " Deaths");
        this.deathsLabel.setForeground(Color.WHITE);
        killDeathPanel.add((Component)this.deathsLabel, "East");
        killDeathPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        killDeathPanel.setComponentPopupMenu(popupMenu);
        this.add(killDeathPanel);
        JPanel offPrayStatsPanel = new JPanel(new BorderLayout());
        JLabel leftLabel = new JLabel();
        leftLabel.setText("Total Off-Pray:");
        leftLabel.setForeground(Color.WHITE);
        offPrayStatsPanel.add((Component)leftLabel, "West");
        this.offPrayStatsLabel = new JLabel();
        this.offPrayStatsLabel.setForeground(Color.WHITE);
        offPrayStatsPanel.add((Component)this.offPrayStatsLabel, "East");
        offPrayStatsPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        offPrayStatsPanel.setComponentPopupMenu(popupMenu);
        this.add(offPrayStatsPanel);
        JPanel deservedDmgStatsPanel = new JPanel(new BorderLayout());
        JLabel deservedDmgStatsLeftLabel = new JLabel();
        deservedDmgStatsLeftLabel.setText("Avg Deserved Dmg:");
        deservedDmgStatsLeftLabel.setForeground(Color.WHITE);
        deservedDmgStatsPanel.add((Component)deservedDmgStatsLeftLabel, "West");
        this.deservedDmgStatsLabel = new JLabel();
        this.deservedDmgStatsLabel.setForeground(Color.WHITE);
        deservedDmgStatsPanel.add((Component)this.deservedDmgStatsLabel, "East");
        deservedDmgStatsPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        deservedDmgStatsPanel.setComponentPopupMenu(popupMenu);
        this.add(deservedDmgStatsPanel);
        JPanel dmgDealtStatsPanel = new JPanel(new BorderLayout());
        JLabel dmgDealtStatsLeftLabel = new JLabel();
        dmgDealtStatsLeftLabel.setText("Avg Damage Dealt:");
        dmgDealtStatsLeftLabel.setForeground(Color.WHITE);
        dmgDealtStatsPanel.add((Component)dmgDealtStatsLeftLabel, "West");
        this.dmgDealtStatsLabel = new JLabel();
        this.dmgDealtStatsLabel.setForeground(Color.WHITE);
        dmgDealtStatsPanel.add((Component)this.dmgDealtStatsLabel, "East");
        dmgDealtStatsPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        dmgDealtStatsPanel.setComponentPopupMenu(popupMenu);
        this.add(dmgDealtStatsPanel);
        JPanel magicHitStatsPanel = new JPanel(new BorderLayout());
        JLabel magicHitStatsLeftLabel = new JLabel();
        magicHitStatsLeftLabel.setText("Magic Luck:");
        magicHitStatsLeftLabel.setForeground(Color.WHITE);
        magicHitStatsPanel.add((Component)magicHitStatsLeftLabel, "West");
        this.magicHitCountStatsLabel = new JLabel();
        this.magicHitCountStatsLabel.setForeground(Color.WHITE);
        magicHitStatsPanel.add((Component)this.magicHitCountStatsLabel, "East");
        magicHitStatsPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        magicHitStatsPanel.setComponentPopupMenu(popupMenu);
        this.add(magicHitStatsPanel);
        JPanel offensivePrayStatsPanel = new JPanel(new BorderLayout());
        JLabel offensivePrayStatsLeftLabel = new JLabel();
        offensivePrayStatsLeftLabel.setText("Offensive Pray:");
        offensivePrayStatsLeftLabel.setForeground(Color.WHITE);
        offensivePrayStatsPanel.add((Component)offensivePrayStatsLeftLabel, "West");
        this.offensivePrayCountStatsLabel = new JLabel();
        this.offensivePrayCountStatsLabel.setForeground(Color.WHITE);
        offensivePrayStatsPanel.add((Component)this.offensivePrayCountStatsLabel, "East");
        offensivePrayStatsPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        offensivePrayStatsPanel.setComponentPopupMenu(popupMenu);
        this.add(offensivePrayStatsPanel);
        JPanel hpHealedPanel = new JPanel(new BorderLayout());
        JLabel hpHealedLeftLabel = new JLabel();
        hpHealedLeftLabel.setText("Avg HP Healed:");
        hpHealedLeftLabel.setForeground(Color.WHITE);
        hpHealedPanel.add((Component)hpHealedLeftLabel, "West");
        this.hpHealedStatsLabel = new JLabel();
        this.hpHealedStatsLabel.setForeground(Color.WHITE);
        hpHealedPanel.add((Component)this.hpHealedStatsLabel, "East");
        hpHealedPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        hpHealedPanel.setComponentPopupMenu(popupMenu);
        this.add(hpHealedPanel);
        JPanel ghostBarrageStatsPanel = new JPanel(new BorderLayout());
        JLabel ghostBarrageStatsLeftLabel = new JLabel();
        ghostBarrageStatsLeftLabel.setText("Avg Ghost Barrages:");
        ghostBarrageStatsLeftLabel.setForeground(Color.WHITE);
        ghostBarrageStatsPanel.add((Component)ghostBarrageStatsLeftLabel, "West");
        this.ghostBarrageStatsLabel = new JLabel();
        this.ghostBarrageStatsLabel.setForeground(ColorScheme.BRAND_ORANGE);
        ghostBarrageStatsPanel.add((Component)this.ghostBarrageStatsLabel, "East");
        ghostBarrageStatsPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        ghostBarrageStatsPanel.setComponentPopupMenu(popupMenu);
        this.add(ghostBarrageStatsPanel);
        this.setLabels();
        this.setMaximumSize(new Dimension(225, (int)this.getPreferredSize().getHeight()));
    }

    private void setLabels() {
        String avgDeservedDmgDiffOneDecimal = nf1.format(this.avgDeservedDmgDiff);
        String avgDmgDealtDiffOneDecimal = nf1.format(this.avgDmgDealtDiff);
        this.killsLabel.setText(nf.format(this.numKills) + " Kill" + (this.numKills != 1 ? "s" : ""));
        this.killsLabel.setToolTipText("From a total of " + this.numFights + " fights, you got " + nf.format(this.numKills) + " kill" + (this.numKills != 1 ? "s" : ""));
        this.deathsLabel.setText(nf.format(this.numDeaths) + " Death" + (this.numDeaths != 1 ? "s" : ""));
        this.deathsLabel.setToolTipText("From a total of " + this.numFights + " fights, you died " + (String)(this.numDeaths != 1 ? nf.format(this.numDeaths) + " times" : "once"));
        if (this.totalStats.getAttackCount() >= 10000) {
            this.offPrayStatsLabel.setText(this.nfWithK(this.totalStats.getOffPraySuccessCount()) + "/" + this.nfWithK(this.totalStats.getAttackCount()) + " (" + Math.round(this.totalStats.calculateOffPraySuccessPercentage()) + "%)");
        } else {
            this.offPrayStatsLabel.setText(this.totalStats.getOffPrayStats());
        }
        ((JPanel)this.offPrayStatsLabel.getParent()).setToolTipText(nf.format(this.totalStats.getOffPraySuccessCount()) + " successful off-pray attacks/" + nf.format(this.totalStats.getAttackCount()) + " total attacks (" + nf2.format(this.totalStats.calculateOffPraySuccessPercentage()) + "%)");
        this.deservedDmgStatsLabel.setText(nf.format(this.avgDeservedDmg) + " (" + (this.avgDeservedDmgDiff > 0.0 ? "+" : "") + avgDeservedDmgDiffOneDecimal + ")");
        ((JPanel)this.deservedDmgStatsLabel.getParent()).setToolTipText("<html>Avg of " + nf1.format(this.avgDeservedDmg) + " deserved damage per fight with avg diff of " + (this.avgDeservedDmgDiff > 0.0 ? "+" : "") + avgDeservedDmgDiffOneDecimal + ".<br>On kills: " + nf1.format(this.killAvgDeservedDmg) + " (" + (this.killAvgDeservedDmgDiff > 0.0 ? "+" : "") + nf1.format(this.killAvgDeservedDmgDiff) + "), on deaths: " + nf1.format(this.deathAvgDeservedDmg) + " (" + (this.deathAvgDeservedDmgDiff > 0.0 ? "+" : "") + nf1.format(this.deathAvgDeservedDmgDiff) + ")</html>");
        this.dmgDealtStatsLabel.setText(nf.format(this.avgDmgDealt) + " (" + (this.avgDmgDealtDiff > 0.0 ? "+" : "") + avgDmgDealtDiffOneDecimal + ")");
        ((JPanel)this.dmgDealtStatsLabel.getParent()).setToolTipText("<html>Avg of " + nf1.format(this.avgDmgDealt) + " damage per fight with avg diff of " + (this.avgDmgDealtDiff > 0.0 ? "+" : "") + avgDmgDealtDiffOneDecimal + ".<br>On kills: " + nf1.format(this.killAvgDmgDealt) + " (" + (this.killAvgDmgDealtDiff > 0.0 ? "+" : "") + nf1.format(this.killAvgDmgDealtDiff) + "), on deaths: " + nf1.format(this.deathAvgDmgDealt) + " (" + (this.deathAvgDmgDealtDiff > 0.0 ? "+" : "") + nf1.format(this.deathAvgDmgDealtDiff) + ")</html>");
        if (this.totalStats.getMagicHitCountDeserved() >= 10000.0) {
            this.magicHitCountStatsLabel.setText(this.nfWithK(this.totalStats.getMagicHitCount()) + "/" + this.nfWithK((int)this.totalStats.getMagicHitCountDeserved()));
        } else {
            this.magicHitCountStatsLabel.setText(this.totalStats.getMagicHitStats());
        }
        ((JPanel)this.magicHitCountStatsLabel.getParent()).setToolTipText("<html>You successfully hit " + this.totalStats.getMagicHitCount() + " of " + this.totalStats.getMagicAttackCount() + " magic attacks, but deserved to hit " + nf1.format(this.totalStats.getMagicHitCountDeserved()) + ".<br>Luck percentage: 100% = expected hits, >100% = lucky, <100% = unlucky</html>");
        if (this.totalStats.getAttackCount() >= 10000) {
            this.offensivePrayCountStatsLabel.setText(this.nfWithK(this.totalStats.getOffensivePraySuccessCount()) + "/" + this.nfWithK(this.totalStats.getAttackCount()) + " (" + Math.round(this.totalStats.calculateOffensivePraySuccessPercentage()) + "%)");
        } else {
            this.offensivePrayCountStatsLabel.setText(this.totalStats.getOffensivePrayStats());
        }
        ((JPanel)this.offensivePrayCountStatsLabel.getParent()).setToolTipText(nf.format(this.totalStats.getOffensivePraySuccessCount()) + " successful offensive prayers/" + nf.format(this.totalStats.getAttackCount()) + " total attacks (" + nf2.format(this.totalStats.calculateOffensivePraySuccessPercentage()) + "%)");
        this.hpHealedStatsLabel.setText(nf.format(this.avgHpHealed));
        ((JPanel)this.hpHealedStatsLabel.getParent()).setToolTipText("A total of " + nf.format(this.totalStats.getHpHealed()) + " hitpoints were recovered, with an average of " + nf.format(this.avgHpHealed) + " HP per fight.");
        this.ghostBarrageStatsLabel.setText(nf.format(this.avgGhostBarrageCount) + " G.B. (" + nf.format(this.avgGhostBarrageDeservedDamage) + ")");
        ((JPanel)this.ghostBarrageStatsLabel.getParent()).setToolTipText("<html>You had an average of " + nf.format(this.avgGhostBarrageCount) + " Ghost Barrages per fight, each worth an extra " + nf.format(this.avgGhostBarrageDeservedDamage) + " deserved damage.<br>In total, you had " + this.totalStats.getGhostBarrageStats() + ".<br>Unless fighting in Duel Arena, your opponents likely had a similar value.");
    }

    private String nfWithK(int number) {
        return nf1.format((double)number / 1000.0) + "k";
    }

    public void addFight(FightPerformance fight) {
        ++this.numFights;
        this.totalStats.addAttacks(fight.getCompetitor().getOffPraySuccessCount(), fight.getCompetitor().getAttackCount(), fight.getCompetitor().getDeservedDamage(), fight.getCompetitor().getDamageDealt(), fight.getCompetitor().getMagicAttackCount(), fight.getCompetitor().getMagicHitCount(), fight.getCompetitor().getMagicHitCountDeserved(), fight.getCompetitor().getOffensivePraySuccessCount(), fight.getCompetitor().getHpHealed(), fight.getCompetitor().getGhostBarrageCount(), fight.getCompetitor().getGhostBarrageDeservedDamage());
        if (fight.getCompetitor().isDead()) {
            ++this.numDeaths;
            this.deathTotalDeservedDmg += fight.getCompetitor().getDeservedDamage();
            this.deathTotalDeservedDmgDiff += fight.getCompetitorDeservedDmgDiff();
            this.deathTotalDmgDealt += (double)fight.getCompetitor().getDamageDealt();
            this.deathTotalDmgDealtDiff += fight.getCompetitorDmgDealtDiff();
            this.deathAvgDeservedDmg = this.deathTotalDeservedDmg / (double)this.numDeaths;
            this.deathAvgDeservedDmgDiff = this.deathTotalDeservedDmgDiff / (double)this.numDeaths;
            this.deathAvgDmgDealt = this.deathTotalDmgDealt / (double)this.numDeaths;
            this.deathAvgDmgDealtDiff = this.deathTotalDmgDealtDiff / (double)this.numDeaths;
        }
        if (fight.getOpponent().isDead()) {
            ++this.numKills;
            this.killTotalDeservedDmg += fight.getCompetitor().getDeservedDamage();
            this.killTotalDeservedDmgDiff += fight.getCompetitorDeservedDmgDiff();
            this.killTotalDmgDealt += (double)fight.getCompetitor().getDamageDealt();
            this.killTotalDmgDealtDiff += fight.getCompetitorDmgDealtDiff();
            this.killAvgDeservedDmg = this.killTotalDeservedDmg / (double)this.numKills;
            this.killAvgDeservedDmgDiff = this.killTotalDeservedDmgDiff / (double)this.numKills;
            this.killAvgDmgDealt = this.killTotalDmgDealt / (double)this.numKills;
            this.killAvgDmgDealtDiff = this.killTotalDmgDealtDiff / (double)this.numKills;
        }
        this.totalDeservedDmg += fight.getCompetitor().getDeservedDamage();
        this.totalDeservedDmgDiff += fight.getCompetitorDeservedDmgDiff();
        this.totalDmgDealt += (double)fight.getCompetitor().getDamageDealt();
        this.totalDmgDealtDiff += fight.getCompetitorDmgDealtDiff();
        this.avgDeservedDmg = this.totalDeservedDmg / (double)this.numFights;
        this.avgDeservedDmgDiff = this.totalDeservedDmgDiff / (double)this.numFights;
        this.avgDmgDealt = this.totalDmgDealt / (double)this.numFights;
        this.avgDmgDealtDiff = this.totalDmgDealtDiff / (double)this.numFights;
        this.avgHpHealed = (double)this.totalStats.getHpHealed() / (double)this.numFights;
        this.avgGhostBarrageCount = (double)this.totalStats.getGhostBarrageCount() / (double)this.numFights;
        this.avgGhostBarrageDeservedDamage = this.totalStats.getGhostBarrageCount() != 0 ? this.totalStats.getGhostBarrageDeservedDamage() / (double)this.totalStats.getGhostBarrageCount() : 0.0;
        SwingUtilities.invokeLater(this::setLabels);
    }

    public void addFights(ArrayList<FightPerformance> fights) {
        if (fights == null || fights.size() < 1) {
            return;
        }
        this.numFights += fights.size();
        for (FightPerformance fight : fights) {
            this.totalStats.addAttacks(fight.getCompetitor().getOffPraySuccessCount(), fight.getCompetitor().getAttackCount(), fight.getCompetitor().getDeservedDamage(), fight.getCompetitor().getDamageDealt(), fight.getCompetitor().getMagicAttackCount(), fight.getCompetitor().getMagicHitCount(), fight.getCompetitor().getMagicHitCountDeserved(), fight.getCompetitor().getOffensivePraySuccessCount(), fight.getCompetitor().getHpHealed(), fight.getCompetitor().getGhostBarrageCount(), fight.getCompetitor().getGhostBarrageDeservedDamage());
            if (fight.getCompetitor().isDead()) {
                ++this.numDeaths;
                this.deathTotalDeservedDmg += fight.getCompetitor().getDeservedDamage();
                this.deathTotalDeservedDmgDiff += fight.getCompetitorDeservedDmgDiff();
                this.deathTotalDmgDealt += (double)fight.getCompetitor().getDamageDealt();
                this.deathTotalDmgDealtDiff += fight.getCompetitorDmgDealtDiff();
            }
            if (fight.getOpponent().isDead()) {
                ++this.numKills;
                this.killTotalDeservedDmg += fight.getCompetitor().getDeservedDamage();
                this.killTotalDeservedDmgDiff += fight.getCompetitorDeservedDmgDiff();
                this.killTotalDmgDealt += (double)fight.getCompetitor().getDamageDealt();
                this.killTotalDmgDealtDiff += fight.getCompetitorDmgDealtDiff();
            }
            this.totalDeservedDmg += fight.getCompetitor().getDeservedDamage();
            this.totalDeservedDmgDiff += fight.getCompetitorDeservedDmgDiff();
            this.totalDmgDealt += (double)fight.getCompetitor().getDamageDealt();
            this.totalDmgDealtDiff += fight.getCompetitorDmgDealtDiff();
        }
        this.avgDeservedDmg = this.numFights != 0 ? this.totalDeservedDmg / (double)this.numFights : 0.0;
        this.avgDeservedDmgDiff = this.numFights != 0 ? this.totalDeservedDmgDiff / (double)this.numFights : 0.0;
        this.avgDmgDealt = this.numFights != 0 ? this.totalDmgDealt / (double)this.numFights : 0.0;
        this.avgDmgDealtDiff = this.numFights != 0 ? this.totalDmgDealtDiff / (double)this.numFights : 0.0;
        this.killAvgDeservedDmg = this.numKills != 0 ? this.killTotalDeservedDmg / (double)this.numKills : 0.0;
        this.killAvgDeservedDmgDiff = this.numKills != 0 ? this.killTotalDeservedDmgDiff / (double)this.numKills : 0.0;
        this.deathAvgDeservedDmg = this.numDeaths != 0 ? this.deathTotalDeservedDmg / (double)this.numDeaths : 0.0;
        this.deathAvgDeservedDmgDiff = this.numDeaths != 0 ? this.deathTotalDeservedDmgDiff / (double)this.numDeaths : 0.0;
        this.killAvgDmgDealt = this.numKills != 0 ? this.killTotalDmgDealt / (double)this.numKills : 0.0;
        this.killAvgDmgDealtDiff = this.numKills != 0 ? this.killTotalDmgDealtDiff / (double)this.numKills : 0.0;
        this.deathAvgDmgDealt = this.numDeaths != 0 ? this.deathTotalDmgDealt / (double)this.numDeaths : 0.0;
        this.deathAvgDmgDealtDiff = this.numDeaths != 0 ? this.deathTotalDmgDealtDiff / (double)this.numDeaths : 0.0;
        this.avgHpHealed = this.numFights != 0 ? (double)this.totalStats.getHpHealed() / (double)this.numFights : 0.0;
        this.avgGhostBarrageCount = this.numFights != 0 ? (double)this.totalStats.getGhostBarrageCount() / (double)this.numFights : 0.0;
        this.avgGhostBarrageDeservedDamage = this.totalStats.getGhostBarrageCount() != 0 ? this.totalStats.getGhostBarrageDeservedDamage() / (double)this.totalStats.getGhostBarrageCount() : 0.0;
        SwingUtilities.invokeLater(this::setLabels);
    }

    public void reset() {
        this.numFights = 0;
        this.numDeaths = 0;
        this.numKills = 0;
        this.totalDeservedDmg = 0.0;
        this.totalDeservedDmgDiff = 0.0;
        this.killTotalDeservedDmg = 0.0;
        this.killTotalDeservedDmgDiff = 0.0;
        this.deathTotalDeservedDmg = 0.0;
        this.deathTotalDeservedDmgDiff = 0.0;
        this.totalDmgDealt = 0.0;
        this.totalDmgDealtDiff = 0.0;
        this.killTotalDmgDealt = 0.0;
        this.killTotalDmgDealtDiff = 0.0;
        this.deathTotalDmgDealt = 0.0;
        this.deathTotalDmgDealtDiff = 0.0;
        this.avgDeservedDmg = 0.0;
        this.avgDeservedDmgDiff = 0.0;
        this.killAvgDeservedDmg = 0.0;
        this.killAvgDeservedDmgDiff = 0.0;
        this.deathAvgDeservedDmg = 0.0;
        this.deathAvgDeservedDmgDiff = 0.0;
        this.avgDmgDealt = 0.0;
        this.avgDmgDealtDiff = 0.0;
        this.killAvgDmgDealt = 0.0;
        this.killAvgDmgDealtDiff = 0.0;
        this.deathAvgDmgDealt = 0.0;
        this.deathAvgDmgDealtDiff = 0.0;
        this.avgHpHealed = 0.0;
        this.avgGhostBarrageCount = 0.0;
        this.avgGhostBarrageDeservedDamage = 0.0;
        this.totalStats = new Fighter("Player");
        SwingUtilities.invokeLater(this::setLabels);
    }

    public void setConfigWarning(boolean enable) {
        if (enable) {
            this.setLayout(new GridLayout(10, 1));
            if (this.settingsWarningLabel == null) {
                this.initializeSettingsWarningLabel();
            }
            this.add((Component)this.settingsWarningLabel, 1);
        } else {
            if (this.getComponentCount() > 9) {
                this.remove(this.settingsWarningLabel);
                this.settingsWarningLabel = null;
            }
            this.setLayout(new GridLayout(9, 1));
        }
        this.validate();
    }

    private void initializeSettingsWarningLabel() {
        this.settingsWarningLabel = new JLabel();
        this.settingsWarningLabel.setText("Check plugin config for setup options!");
        this.settingsWarningLabel.setToolTipText("Please verify that the plugin options are configured according to your needs in the plugin's Configuration Panel.");
        this.settingsWarningLabel.setForeground(Color.RED);
        Font newFont = this.settingsWarningLabel.getFont();
        newFont = newFont.deriveFont(newFont.getStyle() | 1, 12.0f);
        this.settingsWarningLabel.setFont(newFont);
        this.settingsWarningLabel.setHorizontalAlignment(0);
    }

    static {
        nf.setMaximumFractionDigits(1);
        nf.setRoundingMode(RoundingMode.HALF_UP);
        nf1 = NumberFormat.getInstance();
        nf1.setMaximumFractionDigits(1);
        nf1.setRoundingMode(RoundingMode.HALF_UP);
        nf2 = NumberFormat.getInstance();
        nf2.setMaximumFractionDigits(2);
        nf2.setRoundingMode(RoundingMode.HALF_UP);
    }
}

