/*
 * Decompiled with CFR 0.152.
 */
package matsyir.pvpperformancetracker.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import matsyir.pvpperformancetracker.PvpPerformanceTrackerPlugin;
import matsyir.pvpperformancetracker.controllers.AnalyzedFightPerformance;
import matsyir.pvpperformancetracker.controllers.FightPerformance;
import matsyir.pvpperformancetracker.controllers.Fighter;
import matsyir.pvpperformancetracker.models.FightLogEntry;
import matsyir.pvpperformancetracker.views.FightAnalysisFrame;
import matsyir.pvpperformancetracker.views.FightLogFrame;
import net.runelite.client.ui.ColorScheme;

public class FightPerformancePanel
extends JPanel {
    private static JFrame fightLogFrame;
    private static ImageIcon deathIcon;
    private static final SimpleDateFormat DATE_FORMAT;
    private static final NumberFormat nf;
    private static final Border normalBorder;
    private static final Border hoverBorder;
    private FightPerformance fight;
    private AnalyzedFightPerformance analyzedFight;
    private boolean showBorders;

    public FightPerformancePanel(FightPerformance fight) {
        this(fight, true, true, false, null);
    }

    public FightPerformancePanel(FightPerformance fight, boolean showActions, boolean showBorders, boolean showOpponentClientStats, FightPerformance oppFight) {
        this.showBorders = showBorders;
        if (deathIcon == null) {
            deathIcon = new ImageIcon(PvpPerformanceTrackerPlugin.PLUGIN_ICON.getScaledInstance(12, 12, 1));
        }
        this.fight = fight;
        Fighter competitor = fight.getCompetitor();
        Fighter opponent = fight.getOpponent();
        this.setLayout(new BorderLayout(5, 0));
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        String tooltipText = "This fight ended at " + DATE_FORMAT.format(Date.from(Instant.ofEpochMilli(fight.getLastFightTime())));
        this.setToolTipText(tooltipText);
        if (showBorders) {
            this.setBorder(normalBorder);
        }
        JPanel fightPanel = new JPanel();
        fightPanel.setLayout(new BoxLayout(fightPanel, 1));
        fightPanel.setBackground(null);
        JPanel playerNamesLine = new JPanel();
        playerNamesLine.setLayout(new BorderLayout());
        playerNamesLine.setBackground(null);
        JLabel playerStatsName = new JLabel();
        if (competitor.isDead()) {
            playerStatsName.setIcon(deathIcon);
        }
        playerStatsName.setText(competitor.getName());
        playerStatsName.setForeground(Color.WHITE);
        playerNamesLine.add((Component)playerStatsName, "West");
        JLabel opponentStatsName = new JLabel();
        if (opponent.isDead()) {
            opponentStatsName.setIcon(deathIcon);
        }
        opponentStatsName.setText(opponent.getName());
        opponentStatsName.setForeground(Color.WHITE);
        playerNamesLine.add((Component)opponentStatsName, "East");
        JPanel offPrayStatsLine = new JPanel();
        offPrayStatsLine.setLayout(new BorderLayout());
        offPrayStatsLine.setBackground(null);
        JLabel playerOffPrayStats = new JLabel();
        playerOffPrayStats.setText(competitor.getOffPrayStats());
        playerOffPrayStats.setToolTipText(competitor.getName() + " hit " + competitor.getOffPraySuccessCount() + " successful off-pray attacks out of " + competitor.getAttackCount() + " total attacks (" + nf.format(competitor.calculateOffPraySuccessPercentage()) + "%)");
        playerOffPrayStats.setForeground(fight.competitorOffPraySuccessIsGreater() ? Color.GREEN : Color.WHITE);
        offPrayStatsLine.add((Component)playerOffPrayStats, "West");
        JLabel opponentOffPrayStats = new JLabel();
        opponentOffPrayStats.setText(opponent.getOffPrayStats());
        opponentOffPrayStats.setToolTipText(opponent.getName() + " hit " + opponent.getOffPraySuccessCount() + " successful off-pray attacks out of " + opponent.getAttackCount() + " total attacks (" + nf.format(opponent.calculateOffPraySuccessPercentage()) + "%)");
        opponentOffPrayStats.setForeground(fight.opponentOffPraySuccessIsGreater() ? Color.GREEN : Color.WHITE);
        offPrayStatsLine.add((Component)opponentOffPrayStats, "East");
        JPanel deservedDpsStatsLine = new JPanel();
        deservedDpsStatsLine.setLayout(new BorderLayout());
        deservedDpsStatsLine.setBackground(null);
        JLabel playerDeservedDpsStats = new JLabel();
        playerDeservedDpsStats.setText(competitor.getDeservedDmgString(opponent));
        playerDeservedDpsStats.setToolTipText(competitor.getName() + " deserved to deal " + nf.format(competitor.getDeservedDamage()) + " damage based on gear & overheads (" + competitor.getDeservedDmgString(opponent, 1, true) + " vs opponent)");
        playerDeservedDpsStats.setForeground(fight.competitorDeservedDmgIsGreater() ? Color.GREEN : Color.WHITE);
        deservedDpsStatsLine.add((Component)playerDeservedDpsStats, "West");
        JLabel opponentDeservedDpsStats = new JLabel();
        opponentDeservedDpsStats.setText(opponent.getDeservedDmgString(competitor));
        opponentDeservedDpsStats.setToolTipText(opponent.getName() + " deserved to deal " + nf.format(opponent.getDeservedDamage()) + " damage based on gear & overheads (" + opponent.getDeservedDmgString(competitor, 1, true) + " vs you)");
        opponentDeservedDpsStats.setForeground(fight.opponentDeservedDmgIsGreater() ? Color.GREEN : Color.WHITE);
        deservedDpsStatsLine.add((Component)opponentDeservedDpsStats, "East");
        JPanel dmgDealtStatsLine = new JPanel();
        dmgDealtStatsLine.setLayout(new BorderLayout());
        dmgDealtStatsLine.setBackground(null);
        JLabel playerDmgDealtStats = new JLabel();
        playerDmgDealtStats.setText(competitor.getDmgDealtString(opponent));
        playerDmgDealtStats.setToolTipText(competitor.getName() + " dealt " + competitor.getDamageDealt() + " damage (" + competitor.getDmgDealtString(opponent, true) + " vs opponent)");
        playerDmgDealtStats.setForeground(fight.competitorDmgDealtIsGreater() ? Color.GREEN : Color.WHITE);
        dmgDealtStatsLine.add((Component)playerDmgDealtStats, "West");
        JLabel opponentDmgDealtStats = new JLabel();
        opponentDmgDealtStats.setText(opponent.getDmgDealtString(competitor));
        opponentDmgDealtStats.setToolTipText(opponent.getName() + " dealt " + opponent.getDamageDealt() + " damage (" + opponent.getDmgDealtString(competitor, true) + " vs you)");
        opponentDmgDealtStats.setForeground(fight.opponentDeservedDmgIsGreater() ? Color.GREEN : Color.WHITE);
        dmgDealtStatsLine.add((Component)opponentDmgDealtStats, "East");
        JPanel magicHitStatsLine = new JPanel();
        magicHitStatsLine.setLayout(new BorderLayout());
        magicHitStatsLine.setBackground(null);
        JLabel playerMagicHitStats = new JLabel();
        playerMagicHitStats.setText(String.valueOf(competitor.getMagicHitStats()));
        playerMagicHitStats.setToolTipText("<html>" + competitor.getName() + " successfully hit " + competitor.getMagicHitCount() + " of " + competitor.getMagicAttackCount() + " magic attacks, but deserved to hit " + nf.format(competitor.getMagicHitCountDeserved()) + ".<br>Luck percentage: 100% = expected hits, >100% = lucky, <100% = unlucky</html>");
        playerMagicHitStats.setForeground(fight.competitorMagicHitsLuckier() ? Color.GREEN : Color.WHITE);
        magicHitStatsLine.add((Component)playerMagicHitStats, "West");
        JLabel opponentMagicHitStats = new JLabel();
        opponentMagicHitStats.setText(String.valueOf(opponent.getMagicHitStats()));
        opponentMagicHitStats.setToolTipText("<html>" + opponent.getName() + " successfully hit " + opponent.getMagicHitCount() + " of " + opponent.getMagicAttackCount() + " magic attacks, but deserved to hit " + nf.format(opponent.getMagicHitCountDeserved()) + ".<br>Luck percentage: 100% = expected hits, >100% = lucky, <100% = unlucky</html>");
        opponentMagicHitStats.setForeground(fight.opponentMagicHitsLuckier() ? Color.GREEN : Color.WHITE);
        magicHitStatsLine.add((Component)opponentMagicHitStats, "East");
        JPanel offensivePrayStatsLine = new JPanel();
        offensivePrayStatsLine.setLayout(new BorderLayout());
        offensivePrayStatsLine.setBackground(null);
        JLabel playerOffensivePrayStats = new JLabel();
        playerOffensivePrayStats.setText(String.valueOf(competitor.getOffensivePrayStats()));
        playerOffensivePrayStats.setToolTipText(competitor.getName() + " did " + competitor.getOffensivePraySuccessCount() + " successful offensive prayers out of " + competitor.getAttackCount() + " total attacks (" + nf.format(competitor.calculateOffensivePraySuccessPercentage()) + "%)");
        playerOffensivePrayStats.setForeground(showOpponentClientStats && competitor.calculateOffensivePraySuccessPercentage() > oppFight.getCompetitor().calculateOffensivePraySuccessPercentage() ? Color.GREEN : Color.WHITE);
        offensivePrayStatsLine.add((Component)playerOffensivePrayStats, "West");
        JLabel opponentOffensivePrayStats = new JLabel();
        if (showOpponentClientStats) {
            Fighter oppComp = oppFight.getCompetitor();
            opponentOffensivePrayStats.setText(String.valueOf(oppComp.getOffensivePrayStats()));
            opponentOffensivePrayStats.setToolTipText(oppComp.getName() + " did " + oppComp.getOffensivePraySuccessCount() + " successful offensive prayers out of " + oppComp.getAttackCount() + " total attacks (" + nf.format(oppComp.calculateOffensivePraySuccessPercentage()) + "%)");
            opponentOffensivePrayStats.setForeground(oppFight.getCompetitor().calculateOffensivePraySuccessPercentage() > competitor.calculateOffensivePraySuccessPercentage() ? Color.GREEN : Color.WHITE);
        } else {
            opponentOffensivePrayStats.setText("N/A");
            opponentOffensivePrayStats.setToolTipText("No data is available for the opponent's offensive prayers");
            opponentOffensivePrayStats.setForeground(Color.WHITE);
        }
        offensivePrayStatsLine.add((Component)opponentOffensivePrayStats, "East");
        JPanel hpHealedLine = new JPanel();
        hpHealedLine.setLayout(new BorderLayout());
        hpHealedLine.setBackground(null);
        JLabel playerHpHealed = new JLabel();
        playerHpHealed.setText(String.valueOf(competitor.getHpHealed()));
        playerHpHealed.setToolTipText(competitor.getName() + " recovered " + competitor.getHpHealed() + " hitpoints during the fight");
        playerHpHealed.setForeground(showOpponentClientStats && competitor.getHpHealed() > oppFight.getCompetitor().getHpHealed() ? Color.GREEN : Color.WHITE);
        hpHealedLine.add((Component)playerHpHealed, "West");
        JLabel opponentHpHealed = new JLabel();
        if (showOpponentClientStats) {
            Fighter oppComp = oppFight.getCompetitor();
            opponentHpHealed.setText(String.valueOf(oppComp.getHpHealed()));
            opponentHpHealed.setToolTipText(oppComp.getName() + " recovered " + oppComp.getHpHealed() + " hitpoints during the fight");
            opponentHpHealed.setForeground(oppFight.getCompetitor().getHpHealed() > competitor.getHpHealed() ? Color.GREEN : Color.WHITE);
        } else {
            opponentHpHealed.setText("N/A");
            opponentHpHealed.setToolTipText("No data is available for the opponent's hp healed");
            opponentHpHealed.setForeground(Color.WHITE);
        }
        hpHealedLine.add((Component)opponentHpHealed, "East");
        JPanel ghostBarragesLine = new JPanel();
        ghostBarragesLine.setLayout(new BorderLayout());
        ghostBarragesLine.setBackground(null);
        JLabel playerGhostBarrages = new JLabel();
        playerGhostBarrages.setText(competitor.getGhostBarrageStats());
        playerGhostBarrages.setToolTipText("<html>(Advanced): " + competitor.getName() + " hit " + competitor.getGhostBarrageCount() + " ghost barrages during the fight, worth an extra " + nf.format(competitor.getGhostBarrageDeservedDamage()) + " deserved damage.<br>Unless fighting in Duel Arena, your opponent likely had a similar value.</html>");
        playerGhostBarrages.setForeground(showOpponentClientStats && competitor.getGhostBarrageDeservedDamage() > oppFight.getCompetitor().getGhostBarrageDeservedDamage() ? Color.GREEN : ColorScheme.BRAND_ORANGE);
        ghostBarragesLine.add((Component)playerGhostBarrages, "West");
        JLabel opponentGhostBarrages = new JLabel();
        if (showOpponentClientStats) {
            Fighter oppComp = oppFight.getCompetitor();
            opponentGhostBarrages.setText(oppComp.getGhostBarrageStats());
            opponentGhostBarrages.setToolTipText("<html>(Advanced): " + oppComp.getName() + " hit " + oppComp.getGhostBarrageCount() + " ghost barrages during the fight, worth an extra " + nf.format(oppComp.getGhostBarrageDeservedDamage()) + " deserved damage.<br>Unless fighting in Duel Arena, your opponent likely had a similar value.</html>");
            opponentGhostBarrages.setForeground(oppFight.getCompetitor().getGhostBarrageDeservedDamage() > competitor.getGhostBarrageDeservedDamage() ? Color.GREEN : ColorScheme.BRAND_ORANGE);
        } else {
            opponentGhostBarrages.setText("N/A");
            opponentGhostBarrages.setToolTipText("No data is available for the opponent's ghost barrages");
            opponentGhostBarrages.setForeground(ColorScheme.BRAND_ORANGE);
        }
        ghostBarragesLine.add((Component)opponentGhostBarrages, "East");
        fightPanel.add(playerNamesLine);
        fightPanel.add(offPrayStatsLine);
        fightPanel.add(deservedDpsStatsLine);
        fightPanel.add(dmgDealtStatsLine);
        fightPanel.add(magicHitStatsLine);
        fightPanel.add(offensivePrayStatsLine);
        fightPanel.add(hpHealedLine);
        fightPanel.add(ghostBarragesLine);
        this.add((Component)fightPanel, "North");
        MouseAdapter fightPerformanceMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                FightPerformancePanel.this.setFullBackgroundColor(ColorScheme.DARK_GRAY_COLOR);
                FightPerformancePanel.this.setOutline(true);
                FightPerformancePanel.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                FightPerformancePanel.this.setFullBackgroundColor(ColorScheme.DARKER_GRAY_COLOR);
                FightPerformancePanel.this.setOutline(false);
                FightPerformancePanel.this.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                FightPerformancePanel.this.createFightLogFrame();
            }
        };
        this.addMouseListener(fightPerformanceMouseListener);
        if (!showActions) {
            return;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem removeFight = new JMenuItem("Remove Fight");
        removeFight.addActionListener(e -> {
            int dialogResult = JOptionPane.showConfirmDialog(this, "Are you sure you want to remove this fight? This cannot be undone.", "Warning", 0);
            if (dialogResult == 0) {
                PvpPerformanceTrackerPlugin.PLUGIN.removeFight(fight);
            }
        });
        JMenuItem copyDiscordMsg = new JMenuItem("Copy As Discord Msg");
        copyDiscordMsg.addActionListener(e -> PvpPerformanceTrackerPlugin.PLUGIN.copyFightAsDiscordMsg(fight));
        JMenuItem copyFight = new JMenuItem("Copy Fight Data (Advanced)");
        copyFight.addActionListener(e -> PvpPerformanceTrackerPlugin.PLUGIN.exportFight(fight));
        copyFight.setForeground(ColorScheme.BRAND_ORANGE);
        JMenuItem openFightAnalysis = new JMenuItem("Fight Analysis (Advanced)");
        openFightAnalysis.addActionListener(e -> new FightAnalysisFrame(fight, this.getRootPane()));
        openFightAnalysis.setForeground(ColorScheme.BRAND_ORANGE);
        popupMenu.add(removeFight);
        popupMenu.add(copyDiscordMsg);
        popupMenu.add(copyFight);
        popupMenu.add(openFightAnalysis);
        this.setComponentPopupMenu(popupMenu);
        this.setMaximumSize(new Dimension(225, (int)this.getPreferredSize().getHeight()));
    }

    public FightPerformancePanel(AnalyzedFightPerformance aFight) {
        this(aFight, false, true, true, aFight.getOpposingFight());
        this.analyzedFight = aFight;
    }

    private void setFullBackgroundColor(Color color) {
        this.setBackground(color);
        for (Component c : this.getComponents()) {
            c.setBackground(color);
        }
    }

    private void setOutline(boolean visible) {
        if (this.showBorders) {
            this.setBorder(visible ? hoverBorder : normalBorder);
        }
    }

    private void createFightLogFrame() {
        if (fightLogFrame != null) {
            fightLogFrame.dispose();
        }
        ArrayList<FightLogEntry> fightLogEntries = new ArrayList<FightLogEntry>(this.fight.getAllFightLogEntries());
        fightLogEntries.removeIf(e -> !e.isFullEntry());
        if (fightLogEntries.size() < 1) {
            PvpPerformanceTrackerPlugin.PLUGIN.createConfirmationModal(false, "This fight has no attack logs to display, or the data is outdated.");
        } else {
            fightLogFrame = this.analyzedFight != null ? new FightLogFrame(this.analyzedFight, this.getRootPane()) : new FightLogFrame(this.fight, fightLogEntries, this.getRootPane());
        }
    }

    static {
        DATE_FORMAT = new SimpleDateFormat("HH:mm:ss 'on' yyyy/MM/dd");
        nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        nf.setRoundingMode(RoundingMode.HALF_UP);
        normalBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 4, 0, ColorScheme.DARK_GRAY_COLOR), new EmptyBorder(4, 6, 4, 6));
        hoverBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 4, 0, ColorScheme.DARK_GRAY_COLOR), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(ColorScheme.DARKER_GRAY_HOVER_COLOR), new EmptyBorder(3, 5, 3, 5)));
    }
}

