/*
 * Decompiled with CFR 0.152.
 */
package matsyir.pvpperformancetracker.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import matsyir.pvpperformancetracker.PvpPerformanceTrackerPlugin;
import matsyir.pvpperformancetracker.controllers.AnalyzedFightPerformance;
import matsyir.pvpperformancetracker.controllers.FightPerformance;
import matsyir.pvpperformancetracker.models.AnimationData;
import matsyir.pvpperformancetracker.models.FightLogEntry;
import matsyir.pvpperformancetracker.views.FightLogDetailFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FightLogFrame
extends JFrame {
    private static final Logger log = LoggerFactory.getLogger(FightLogFrame.class);
    private static final NumberFormat nf = NumberFormat.getInstance();
    private FightLogDetailFrame fightLogDetailFrame;
    private JTable table;
    private ListSelectionListener onRowSelected;
    private ArrayList<FightLogEntry> fightLogEntries;

    FightLogFrame(FightPerformance fight, ArrayList<FightLogEntry> logEntries, JRootPane rootPane) {
        super(fight.getCompetitor().getName() + " vs " + fight.getOpponent().getName());
        this.fightLogEntries = logEntries;
        this.fightLogEntries.removeIf(e -> !e.isFullEntry());
        if (this.isAlwaysOnTopSupported()) {
            this.setAlwaysOnTop(PvpPerformanceTrackerPlugin.PLUGIN.getRuneliteConfig().gameAlwaysOnTop());
        }
        this.setIconImage(PvpPerformanceTrackerPlugin.PLUGIN_ICON);
        this.setSize(765, 503);
        this.setLocation(rootPane.getLocationOnScreen());
        JPanel mainPanel = new JPanel(new BorderLayout(4, 4));
        Object[][] stats = new Object[this.fightLogEntries.size()][11];
        int i = 0;
        int initialTick = 0;
        for (FightLogEntry fightEntry : this.fightLogEntries) {
            if (i == 0) {
                initialTick = fightEntry.getTick();
            }
            int styleIcon = fightEntry.getAnimationData().attackStyle.getStyleSpriteId();
            JLabel styleIconLabel = new JLabel();
            PvpPerformanceTrackerPlugin.PLUGIN.addSpriteToLabelIfValid(styleIconLabel, styleIcon, this::repaint);
            styleIconLabel.setToolTipText(fightEntry.getAnimationData().attackStyle.toString());
            stats[i][0] = fightEntry.getAttackerName();
            stats[i][1] = styleIconLabel;
            stats[i][2] = fightEntry.getHitRange();
            stats[i][3] = nf.format(fightEntry.getAccuracy() * 100.0) + "%";
            stats[i][4] = nf.format(fightEntry.getDeservedDamage());
            stats[i][5] = fightEntry.getAnimationData().isSpecial ? "\u2714" : "";
            stats[i][6] = fightEntry.success() ? "\u2714" : "";
            int prayIcon = PvpPerformanceTrackerPlugin.PLUGIN.getSpriteForHeadIcon(fightEntry.getDefenderOverhead());
            if (prayIcon > 0) {
                JLabel prayIconLabel = new JLabel();
                PvpPerformanceTrackerPlugin.PLUGIN.addSpriteToLabelIfValid(prayIconLabel, prayIcon, this::repaint);
                stats[i][7] = prayIconLabel;
            } else {
                stats[i][7] = "";
            }
            if (fightEntry.getAnimationData().attackStyle == AnimationData.AttackStyle.MAGIC) {
                int freezeIcon = fightEntry.isSplash() ? 378 : 328;
                JLabel freezeIconLabel = new JLabel();
                PvpPerformanceTrackerPlugin.PLUGIN.addSpriteToLabelIfValid(freezeIconLabel, freezeIcon, this::repaint);
                stats[i][8] = freezeIconLabel;
            } else {
                stats[i][8] = "";
            }
            JLabel attackerOffensivePrayLabel = new JLabel();
            if (fightEntry.getAttackerOffensivePray() > 0) {
                PvpPerformanceTrackerPlugin.PLUGIN.addSpriteToLabelIfValid(attackerOffensivePrayLabel, fightEntry.getAttackerOffensivePray(), this::repaint);
                stats[i][9] = attackerOffensivePrayLabel;
            } else {
                stats[i][9] = "";
            }
            int tickDuration = fightEntry.getTick() - initialTick;
            int durationMillis = tickDuration * 600;
            Duration duration = Duration.ofMillis(durationMillis);
            String time = String.format("%02d:%02d.%01d", duration.toMinutes(), duration.getSeconds() % 60L, durationMillis % 1000 / 100) + " (" + tickDuration + ")";
            stats[i][10] = time;
            ++i;
        }
        Object[] header = new String[]{"Attacker", "Style", "Hit Range", "Accuracy", "Avg Hit", "Special?", "Off-Pray?", "Def Prayer", "Splash", "Offensive Pray", "Time, (Tick)"};
        this.table = new JTable(stats, header);
        this.table.setRowHeight(30);
        this.table.setDefaultEditor(Object.class, null);
        this.table.getColumnModel().getColumn(1).setCellRenderer(new BufferedImageCellRenderer());
        this.table.getColumnModel().getColumn(7).setCellRenderer(new BufferedImageCellRenderer());
        this.table.getColumnModel().getColumn(8).setCellRenderer(new BufferedImageCellRenderer());
        this.table.getColumnModel().getColumn(9).setCellRenderer(new BufferedImageCellRenderer());
        this.onRowSelected = e -> {
            int row = this.table.getSelectedRow();
            if (this.fightLogDetailFrame != null) {
                if (this.fightLogDetailFrame.rowIdx == row) {
                    return;
                }
                this.fightLogDetailFrame.dispose();
                this.fightLogDetailFrame = null;
            }
            this.fightLogDetailFrame = new FightLogDetailFrame(fight, this.fightLogEntries.get(row), row, new Point(this.getLocation().x + this.getSize().width, this.getLocation().y));
        };
        this.table.getSelectionModel().addListSelectionListener(this.onRowSelected);
        mainPanel.add((Component)new JScrollPane(this.table), "Center");
        this.add(mainPanel);
        this.setVisible(true);
    }

    FightLogFrame(AnalyzedFightPerformance fight, JRootPane rootPane) {
        this(fight, new ArrayList<FightLogEntry>(fight.getAllFightLogEntries().stream().filter(FightLogEntry::isFullEntry).collect(Collectors.toList())), rootPane);
        if (new ArrayList(fight.getAllFightLogEntries().stream().filter(FightLogEntry::isFullEntry).collect(Collectors.toList())).size() != fight.getAnalyzedMatchingLogs().size()) {
            log.info("FIGHT ANALYSIS: ERROR! allFightLogEntries.filter::isFullEntry different size than analyzedMatchingLogs - should not happen");
        }
        this.table.getSelectionModel().removeListSelectionListener(this.onRowSelected);
        this.onRowSelected = e -> {
            int row = this.table.getSelectedRow();
            if (this.fightLogDetailFrame != null) {
                if (this.fightLogDetailFrame.rowIdx == row) {
                    return;
                }
                this.fightLogDetailFrame.dispose();
                this.fightLogDetailFrame = null;
            }
            this.fightLogDetailFrame = new FightLogDetailFrame(fight, this.fightLogEntries.get(row), fight.getAnalyzedMatchingLogs().get(row)[1], row, new Point(this.getLocationOnScreen().x + this.getSize().width, this.getLocationOnScreen().y));
        };
        this.table.getSelectionModel().addListSelectionListener(this.onRowSelected);
    }

    static {
        nf.setMaximumFractionDigits(2);
        nf.setRoundingMode(RoundingMode.HALF_UP);
    }

    static class BufferedImageCellRenderer
    extends DefaultTableCellRenderer {
        BufferedImageCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof BufferedImage) {
                this.setText("");
                this.setIcon(new ImageIcon((BufferedImage)value));
            } else if (value instanceof JLabel) {
                JLabel val = (JLabel)value;
                this.setIcon(val.getIcon());
                this.setText(val.getText());
                this.setToolTipText(val.getToolTipText());
            } else {
                this.setText("");
                this.setIcon(null);
            }
            return this;
        }
    }
}

