/*
 * Decompiled with CFR 0.152.
 */
package matsyir.pvpperformancetracker.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import matsyir.pvpperformancetracker.PvpPerformanceTrackerPlugin;
import matsyir.pvpperformancetracker.controllers.AnalyzedFightPerformance;
import matsyir.pvpperformancetracker.controllers.FightPerformance;
import matsyir.pvpperformancetracker.controllers.Fighter;
import matsyir.pvpperformancetracker.controllers.PvpDamageCalc;
import matsyir.pvpperformancetracker.models.AnimationData;
import matsyir.pvpperformancetracker.models.CombatLevels;
import matsyir.pvpperformancetracker.models.EquipmentData;
import matsyir.pvpperformancetracker.models.FightLogEntry;
import matsyir.pvpperformancetracker.models.RangeAmmoData;
import net.runelite.api.Skill;
import net.runelite.api.kit.KitType;
import net.runelite.http.api.item.ItemEquipmentStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FightLogDetailFrame
extends JFrame {
    private static final Logger log = LoggerFactory.getLogger(FightLogDetailFrame.class);
    public static final int DEFAULT_WIDTH = 400;
    public int rowIdx;
    private boolean isCompetitorLog;
    private Fighter attacker;
    private Fighter defender;
    private JPanel combatLevelsLine;
    private JLabel attackerAtkLvl;
    private JLabel attackerStrLvl;
    private JLabel attackerDefLvl;
    private JLabel attackerRangeLvl;
    private JLabel attackerMageLvl;
    private JLabel attackerHpLvl;
    private JLabel defenderAtkLvl;
    private JLabel defenderStrLvl;
    private JLabel defenderDefLvl;
    private JLabel defenderRangeLvl;
    private JLabel defenderMageLvl;
    private JLabel defenderHpLvl;
    private JLabel attackerOffensiveLabel;
    private JLabel defenderOffensiveLabel;

    FightLogDetailFrame(FightPerformance fight, FightLogEntry log, int rowIdx, Point location) {
        super(fight.getCompetitor().getName() + " vs " + fight.getOpponent().getName() + " - Log Details");
        this.rowIdx = rowIdx;
        this.setSize(400, 640);
        this.setMinimumSize(new Dimension(400, 200));
        this.setLayout(new BorderLayout());
        this.setLocation(location);
        this.setIconImage(PvpPerformanceTrackerPlugin.PLUGIN_ICON);
        if (this.isAlwaysOnTopSupported()) {
            this.setAlwaysOnTop(PvpPerformanceTrackerPlugin.PLUGIN.getRuneliteConfig().gameAlwaysOnTop());
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setVisible(true);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(8, 16, 8, 16));
        this.isCompetitorLog = log.attackerName.equals(fight.getCompetitor().getName());
        this.attacker = this.isCompetitorLog ? fight.getCompetitor() : fight.getOpponent();
        this.defender = this.isCompetitorLog ? fight.getOpponent() : fight.getCompetitor();
        JPanel namesLine = new JPanel(new BorderLayout());
        GridLayout attackerNameContainerLayout = new GridLayout(1, 2);
        attackerNameContainerLayout.setHgap(4);
        JPanel attackerNameContainer = new JPanel(attackerNameContainerLayout);
        JLabel attackerName = new JLabel();
        attackerName.setText("<html>Attacker:<br/><strong>" + log.attackerName + "</strong></html>");
        PvpPerformanceTrackerPlugin.PLUGIN.addSpriteToLabelIfValid(attackerName, log.getAnimationData().attackStyle.getStyleSpriteId());
        attackerName.setToolTipText(log.getAnimationData().attackStyle.toString());
        attackerNameContainer.add(attackerName);
        if (log.getAnimationData().attackStyle == AnimationData.AttackStyle.MAGIC) {
            int splashIcon = log.isSplash() ? 378 : 328;
            JLabel splashIconLabel = new JLabel();
            PvpPerformanceTrackerPlugin.PLUGIN.addSpriteToLabelIfValid(splashIconLabel, splashIcon);
            splashIconLabel.setText("<html> <br/> </html>");
            splashIconLabel.setToolTipText("Splashed: " + (log.isSplash() ? "Yes" : "No"));
            splashIconLabel.setHorizontalAlignment(2);
            attackerNameContainer.add(splashIconLabel);
        }
        namesLine.add((Component)attackerNameContainer, "West");
        JLabel defenderName = new JLabel();
        defenderName.setText("<html>Defender:<br/><strong>" + this.defender.getName() + "</strong></html>");
        namesLine.add((Component)defenderName, "East");
        JPanel praysUsedLine = new JPanel(new BorderLayout());
        GridLayout attackerPrayLayout = new GridLayout(1, 2);
        attackerPrayLayout.setHgap(4);
        JPanel attackerPrays = new JPanel(attackerPrayLayout);
        int attackerOverheadSpriteId = PvpPerformanceTrackerPlugin.PLUGIN.getSpriteForHeadIcon(log.getAttackerOverhead());
        JLabel attackerOverheadLabel = new JLabel();
        PvpPerformanceTrackerPlugin.PLUGIN.addSpriteToLabelIfValid(attackerOverheadLabel, attackerOverheadSpriteId);
        attackerOverheadLabel.setToolTipText("Overhead Prayer");
        attackerPrays.add(attackerOverheadLabel);
        this.attackerOffensiveLabel = new JLabel();
        this.attackerOffensiveLabel.setToolTipText("Offensive Prayer");
        PvpPerformanceTrackerPlugin.PLUGIN.addSpriteToLabelIfValid(this.attackerOffensiveLabel, log.getAttackerOffensivePray());
        if (!this.isCompetitorLog) {
            this.attackerOffensiveLabel.setText("N/A");
            this.attackerOffensiveLabel.setIcon(null);
        }
        attackerPrays.add(this.attackerOffensiveLabel);
        praysUsedLine.add((Component)attackerPrays, "West");
        GridLayout defenderPrayLayout = new GridLayout(1, 2);
        defenderPrayLayout.setHgap(4);
        JPanel defenderPrays = new JPanel(defenderPrayLayout);
        int defenderOverheadSpriteId = PvpPerformanceTrackerPlugin.PLUGIN.getSpriteForHeadIcon(log.getDefenderOverhead());
        JLabel defenderOverheadLabel = new JLabel();
        PvpPerformanceTrackerPlugin.PLUGIN.addSpriteToLabelIfValid(defenderOverheadLabel, defenderOverheadSpriteId);
        defenderOverheadLabel.setToolTipText("Overhead Prayer");
        defenderPrays.add(defenderOverheadLabel);
        this.defenderOffensiveLabel = new JLabel("N/A");
        this.defenderOffensiveLabel.setToolTipText("Offensive Prayer");
        defenderPrays.add(this.defenderOffensiveLabel);
        praysUsedLine.add((Component)defenderPrays, "East");
        CombatLevels levels = fight.fightType.getCombatLevelsForType();
        this.combatLevelsLine = new JPanel(new BorderLayout());
        JPanel attackerCombatLevels = new JPanel(new GridLayout(2, 3));
        this.attackerAtkLvl = new JLabel();
        PvpPerformanceTrackerPlugin.PLUGIN.addSpriteToLabelIfValid(this.attackerAtkLvl, PvpPerformanceTrackerPlugin.PLUGIN.getSpriteForSkill(Skill.ATTACK));
        this.attackerAtkLvl.setText(String.valueOf(levels.atk));
        this.attackerAtkLvl.setToolTipText("Attack Level");
        this.attackerStrLvl = new JLabel();
        PvpPerformanceTrackerPlugin.PLUGIN.addSpriteToLabelIfValid(this.attackerStrLvl, PvpPerformanceTrackerPlugin.PLUGIN.getSpriteForSkill(Skill.STRENGTH));
        this.attackerStrLvl.setText(String.valueOf(levels.str));
        this.attackerStrLvl.setToolTipText("Strength Level");
        this.attackerDefLvl = new JLabel();
        PvpPerformanceTrackerPlugin.PLUGIN.addSpriteToLabelIfValid(this.attackerDefLvl, PvpPerformanceTrackerPlugin.PLUGIN.getSpriteForSkill(Skill.DEFENCE));
        this.attackerDefLvl.setText(String.valueOf(levels.def));
        this.attackerDefLvl.setToolTipText("Defence Level");
        this.attackerRangeLvl = new JLabel();
        PvpPerformanceTrackerPlugin.PLUGIN.addSpriteToLabelIfValid(this.attackerRangeLvl, PvpPerformanceTrackerPlugin.PLUGIN.getSpriteForSkill(Skill.RANGED));
        this.attackerRangeLvl.setText(String.valueOf(levels.range));
        this.attackerRangeLvl.setToolTipText("Ranged Level");
        this.attackerMageLvl = new JLabel();
        PvpPerformanceTrackerPlugin.PLUGIN.addSpriteToLabelIfValid(this.attackerMageLvl, PvpPerformanceTrackerPlugin.PLUGIN.getSpriteForSkill(Skill.MAGIC));
        this.attackerMageLvl.setText(String.valueOf(levels.mage));
        this.attackerMageLvl.setToolTipText("Magic Level");
        this.attackerHpLvl = new JLabel();
        PvpPerformanceTrackerPlugin.PLUGIN.addSpriteToLabelIfValid(this.attackerHpLvl, PvpPerformanceTrackerPlugin.PLUGIN.getSpriteForSkill(Skill.HITPOINTS));
        this.attackerHpLvl.setText(String.valueOf(levels.hp));
        this.attackerHpLvl.setToolTipText("Hitpoints Level");
        attackerCombatLevels.add(this.attackerAtkLvl);
        attackerCombatLevels.add(this.attackerStrLvl);
        attackerCombatLevels.add(this.attackerDefLvl);
        attackerCombatLevels.add(this.attackerRangeLvl);
        attackerCombatLevels.add(this.attackerMageLvl);
        attackerCombatLevels.add(this.attackerHpLvl);
        this.combatLevelsLine.add((Component)attackerCombatLevels, "West");
        JPanel defenderCombatLevels = new JPanel(new GridLayout(2, 3));
        this.defenderAtkLvl = new JLabel();
        PvpPerformanceTrackerPlugin.PLUGIN.addSpriteToLabelIfValid(this.defenderAtkLvl, PvpPerformanceTrackerPlugin.PLUGIN.getSpriteForSkill(Skill.ATTACK));
        this.defenderAtkLvl.setText(String.valueOf(levels.atk));
        this.defenderAtkLvl.setToolTipText("Attack Level");
        this.defenderStrLvl = new JLabel();
        PvpPerformanceTrackerPlugin.PLUGIN.addSpriteToLabelIfValid(this.defenderStrLvl, PvpPerformanceTrackerPlugin.PLUGIN.getSpriteForSkill(Skill.STRENGTH));
        this.defenderStrLvl.setText(String.valueOf(levels.str));
        this.defenderStrLvl.setToolTipText("Strength Level");
        this.defenderDefLvl = new JLabel();
        PvpPerformanceTrackerPlugin.PLUGIN.addSpriteToLabelIfValid(this.defenderDefLvl, PvpPerformanceTrackerPlugin.PLUGIN.getSpriteForSkill(Skill.DEFENCE));
        this.defenderDefLvl.setText(String.valueOf(levels.def));
        this.defenderDefLvl.setToolTipText("Defence Level");
        this.defenderRangeLvl = new JLabel();
        PvpPerformanceTrackerPlugin.PLUGIN.addSpriteToLabelIfValid(this.defenderRangeLvl, PvpPerformanceTrackerPlugin.PLUGIN.getSpriteForSkill(Skill.RANGED));
        this.defenderRangeLvl.setText(String.valueOf(levels.range));
        this.defenderRangeLvl.setToolTipText("Ranged Level");
        this.defenderMageLvl = new JLabel();
        PvpPerformanceTrackerPlugin.PLUGIN.addSpriteToLabelIfValid(this.defenderMageLvl, PvpPerformanceTrackerPlugin.PLUGIN.getSpriteForSkill(Skill.MAGIC));
        this.defenderMageLvl.setText(String.valueOf(levels.mage));
        this.defenderMageLvl.setToolTipText("Magic Level");
        this.defenderHpLvl = new JLabel();
        PvpPerformanceTrackerPlugin.PLUGIN.addSpriteToLabelIfValid(this.defenderHpLvl, PvpPerformanceTrackerPlugin.PLUGIN.getSpriteForSkill(Skill.HITPOINTS));
        this.defenderHpLvl.setText(String.valueOf(levels.hp));
        this.defenderHpLvl.setToolTipText("Hitpoints Level");
        defenderCombatLevels.add(this.defenderAtkLvl);
        defenderCombatLevels.add(this.defenderStrLvl);
        defenderCombatLevels.add(this.defenderDefLvl);
        defenderCombatLevels.add(this.defenderRangeLvl);
        defenderCombatLevels.add(this.defenderMageLvl);
        defenderCombatLevels.add(this.defenderHpLvl);
        this.combatLevelsLine.add((Component)defenderCombatLevels, "East");
        JPanel equipmentStatsLine = new JPanel(new BorderLayout());
        JLabel attackerStatsLabel = new JLabel();
        PvpPerformanceTrackerPlugin.PLUGIN.getClientThread().invokeLater(() -> attackerStatsLabel.setText(this.getItemEquipmentStatsString(log.getAttackerGear())));
        equipmentStatsLine.add((Component)attackerStatsLabel, "West");
        JLabel defenderStatsLabel = new JLabel();
        PvpPerformanceTrackerPlugin.PLUGIN.getClientThread().invokeLater(() -> defenderStatsLabel.setText(this.getItemEquipmentStatsString(log.getDefenderGear())));
        equipmentStatsLine.add((Component)defenderStatsLabel, "East");
        JPanel equipmentRenderLine = new JPanel(new BorderLayout());
        JPanel attackerEquipmentRender = this.getEquipmentRender(log.getAttackerGear());
        JPanel defenderEquipmentRender = this.getEquipmentRender(log.getDefenderGear());
        equipmentRenderLine.add((Component)attackerEquipmentRender, "West");
        equipmentRenderLine.add((Component)defenderEquipmentRender, "East");
        JPanel animationDetectedLine = new JPanel(new BorderLayout());
        JLabel attackerAnimationDetected = new JLabel();
        attackerAnimationDetected.setText("<html><strong>Animation Detected:</strong> " + log.getAnimationData().toString() + "</html>");
        attackerAnimationDetected.setToolTipText("<html>Note that the animation can be misleading, as many animations are re-used, but this is normal.<br/>For example, Zammy Hasta and Staff of Fire use the same crush animation.<br/>These were not intended to ever be displayed, but why not include them here.</html>");
        animationDetectedLine.add((Component)attackerAnimationDetected, "Center");
        mainPanel.add(namesLine);
        mainPanel.add(praysUsedLine);
        mainPanel.add(this.combatLevelsLine);
        mainPanel.add(equipmentRenderLine);
        mainPanel.add(equipmentStatsLine);
        mainPanel.add(animationDetectedLine);
        this.add((Component)mainPanel, "Center");
        this.setVisible(true);
    }

    FightLogDetailFrame(AnalyzedFightPerformance fight, FightLogEntry attackerLog, FightLogEntry defenderLog, int rowIdx, Point location) {
        this(fight, attackerLog, rowIdx, location);
        CombatLevels aLvls = attackerLog.getAttackerLevels();
        if (aLvls == null) {
            log.info("Fight Analysis: attackerLvls are null! This shouldn't happen.");
            aLvls = fight.fightType.getCombatLevelsForType();
        }
        this.attackerAtkLvl.setText(String.valueOf(aLvls.atk));
        this.attackerStrLvl.setText(String.valueOf(aLvls.str));
        this.attackerDefLvl.setText(String.valueOf(aLvls.def));
        this.attackerRangeLvl.setText(String.valueOf(aLvls.range));
        this.attackerMageLvl.setText(String.valueOf(aLvls.mage));
        this.attackerHpLvl.setText(String.valueOf(aLvls.hp));
        CombatLevels dLvls = defenderLog.getAttackerLevels();
        if (dLvls == null) {
            log.info("Fight Analysis: defenderLvls are null! This shouldn't happen.");
            dLvls = fight.fightType.getCombatLevelsForType();
        }
        this.defenderAtkLvl.setText(String.valueOf(dLvls.atk));
        this.defenderStrLvl.setText(String.valueOf(dLvls.str));
        this.defenderDefLvl.setText(String.valueOf(dLvls.def));
        this.defenderRangeLvl.setText(String.valueOf(dLvls.range));
        this.defenderMageLvl.setText(String.valueOf(dLvls.mage));
        this.defenderHpLvl.setText(String.valueOf(dLvls.hp));
        this.defenderOffensiveLabel.setText("");
        PvpPerformanceTrackerPlugin.PLUGIN.addSpriteToLabelIfValid(this.defenderOffensiveLabel, defenderLog.getAttackerOffensivePray());
        this.attackerOffensiveLabel.setText("");
        PvpPerformanceTrackerPlugin.PLUGIN.addSpriteToLabelIfValid(this.attackerOffensiveLabel, attackerLog.getAttackerOffensivePray(), () -> {
            this.validate();
            this.repaint();
        });
    }

    private JPanel getEquipmentRender(int[] itemIds) {
        JPanel equipmentRender = new JPanel();
        equipmentRender.setLayout(new BoxLayout(equipmentRender, 1));
        JPanel helmLine = new JPanel(new BorderLayout());
        JPanel capeLine = new JPanel(new BorderLayout());
        JPanel weaponLine = new JPanel(new BorderLayout());
        JPanel legsLine = new JPanel(new BorderLayout());
        JPanel glovesLine = new JPanel(new BorderLayout());
        JLabel helm = new JLabel();
        helm.setHorizontalAlignment(0);
        PvpPerformanceTrackerPlugin.PLUGIN.addItemToLabelIfValid(helm, itemIds[KitType.HEAD.getIndex()]);
        helmLine.add((Component)helm, "Center");
        JLabel cape = new JLabel();
        PvpPerformanceTrackerPlugin.PLUGIN.addItemToLabelIfValid(cape, itemIds[KitType.CAPE.getIndex()]);
        JLabel amulet = new JLabel();
        PvpPerformanceTrackerPlugin.PLUGIN.addItemToLabelIfValid(amulet, itemIds[KitType.AMULET.getIndex()]);
        capeLine.add((Component)cape, "West");
        capeLine.add((Component)amulet, "Center");
        RangeAmmoData weaponAmmo = EquipmentData.getWeaponAmmo(EquipmentData.fromId(PvpPerformanceTrackerPlugin.fixItemId(itemIds[KitType.WEAPON.getIndex()])));
        if (weaponAmmo != null) {
            JLabel ammo = new JLabel();
            PvpPerformanceTrackerPlugin.PLUGIN.addItemToLabelIfValid(ammo, weaponAmmo, false, null);
            capeLine.add((Component)ammo, "East");
        }
        JLabel wep = new JLabel();
        PvpPerformanceTrackerPlugin.PLUGIN.addItemToLabelIfValid(wep, itemIds[KitType.WEAPON.getIndex()]);
        JLabel torso = new JLabel();
        PvpPerformanceTrackerPlugin.PLUGIN.addItemToLabelIfValid(torso, itemIds[KitType.TORSO.getIndex()]);
        JLabel shield = new JLabel();
        PvpPerformanceTrackerPlugin.PLUGIN.addItemToLabelIfValid(shield, itemIds[KitType.SHIELD.getIndex()]);
        weaponLine.add((Component)wep, "West");
        weaponLine.add((Component)torso, "Center");
        weaponLine.add((Component)shield, "East");
        JLabel legs = new JLabel();
        legs.setHorizontalAlignment(0);
        PvpPerformanceTrackerPlugin.PLUGIN.addItemToLabelIfValid(legs, itemIds[KitType.LEGS.getIndex()]);
        legsLine.add((Component)legs, "Center");
        JLabel gloves = new JLabel();
        PvpPerformanceTrackerPlugin.PLUGIN.addItemToLabelIfValid(gloves, itemIds[KitType.HANDS.getIndex()]);
        JLabel boots = new JLabel();
        PvpPerformanceTrackerPlugin.PLUGIN.addItemToLabelIfValid(boots, itemIds[KitType.BOOTS.getIndex()]);
        JLabel ring = new JLabel();
        PvpPerformanceTrackerPlugin.PLUGIN.addItemToLabelIfValid(ring, PvpPerformanceTrackerPlugin.CONFIG.ringChoice().getItemId(), false, () -> {
            this.validate();
            this.repaint();
        });
        glovesLine.add((Component)gloves, "West");
        glovesLine.add((Component)boots, "Center");
        glovesLine.add((Component)ring, "East");
        equipmentRender.add(helmLine);
        equipmentRender.add(capeLine);
        equipmentRender.add(weaponLine);
        equipmentRender.add(legsLine);
        equipmentRender.add(glovesLine);
        return equipmentRender;
    }

    String getItemEquipmentStatsString(int[] equipment) {
        ItemEquipmentStats stats = PvpDamageCalc.calculateBonusesToStats(equipment);
        RangeAmmoData weaponAmmo = EquipmentData.getWeaponAmmo(EquipmentData.fromId(PvpPerformanceTrackerPlugin.fixItemId(equipment[KitType.WEAPON.getIndex()])));
        int ammoRangeStr = 0;
        if (weaponAmmo != null) {
            ammoRangeStr = weaponAmmo.getRangeStr();
        }
        String sep = "<br/>&nbsp;&nbsp;";
        return "<html><strong>Attack bonus</strong>" + sep + "Stab: " + this.prependPlusIfPositive(stats.getAstab()) + sep + "Slash: " + this.prependPlusIfPositive(stats.getAslash()) + sep + "Crush: " + this.prependPlusIfPositive(stats.getAcrush()) + sep + "Magic: " + this.prependPlusIfPositive(stats.getAmagic()) + sep + "Range: " + this.prependPlusIfPositive(stats.getArange()) + "<br/><strong>Defence bonus</strong>" + sep + "Stab: " + this.prependPlusIfPositive(stats.getDstab()) + sep + "Slash: " + this.prependPlusIfPositive(stats.getDslash()) + sep + "Crush: " + this.prependPlusIfPositive(stats.getDcrush()) + sep + "Magic: " + this.prependPlusIfPositive(stats.getDmagic()) + sep + "Range: " + this.prependPlusIfPositive(stats.getDrange()) + "<br/><strong>Other bonuses</strong>" + sep + "Melee strength: " + this.prependPlusIfPositive(stats.getStr()) + sep + "Ranged strength: " + this.prependPlusIfPositive(stats.getRstr() + ammoRangeStr) + sep + "Magic damage: " + this.prependPlusIfPositive(stats.getMdmg()) + "%" + sep + "</html>";
    }

    String prependPlusIfPositive(int number) {
        if (number >= 0) {
            return "+" + number;
        }
        return String.valueOf(number);
    }
}

