/*
 * Decompiled with CFR 0.152.
 */
package matsyir.pvpperformancetracker.views;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import matsyir.pvpperformancetracker.PvpPerformanceTrackerPlugin;
import matsyir.pvpperformancetracker.controllers.AnalyzedFightPerformance;
import matsyir.pvpperformancetracker.controllers.FightPerformance;
import matsyir.pvpperformancetracker.views.FightPerformancePanel;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.LinkBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FightAnalysisFrame
extends JFrame {
    private static final Logger log = LoggerFactory.getLogger(FightAnalysisFrame.class);
    public static String WIKI_HELP_URL = "https://github.com/Matsyir/pvp-performance-tracker/wiki#fight-analysisfight-merge";
    private static String WINDOW_TITLE = "PvP Performance Tracker: Fight Analysis";
    private static final NumberFormat nf = NumberFormat.getInstance();
    private JPanel mainPanel;
    private JTextField mainFightJsonInput;
    private JTextField opponentFightJsonInput;
    private FightPerformance mainFight;
    private FightPerformance opponentFight;
    private AnalyzedFightPerformance analyzedFight;

    FightAnalysisFrame(FightPerformance fight, JRootPane rootPane) {
        this(rootPane);
        this.mainFightJsonInput.setText(PvpPerformanceTrackerPlugin.GSON.toJson((Object)fight, FightPerformance.class));
        this.validate();
        this.repaint();
    }

    FightAnalysisFrame(JRootPane rootPane) {
        super("PvP Performance Tracker: Fight Analysis");
        if (this.isAlwaysOnTopSupported()) {
            this.setAlwaysOnTop(PvpPerformanceTrackerPlugin.PLUGIN.getRuneliteConfig().gameAlwaysOnTop());
        }
        this.setIconImage(PvpPerformanceTrackerPlugin.PLUGIN_ICON);
        Dimension size = new Dimension(700, 448);
        this.setSize(size);
        this.setMinimumSize(size);
        this.setLocation(rootPane.getLocationOnScreen());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.getRootPane().putClientProperty("substancelaf.internal.colorizationFactor", 1.0);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.mainPanel.setPreferredSize(this.getSize());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(8, 16, 8, 16));
        this.mainPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.mainPanel.setVisible(true);
        this.add(this.mainPanel);
        this.setVisible(true);
        this.initializeFrame();
    }

    private void initializeFrame() {
        this.setTitle(WINDOW_TITLE);
        this.mainPanel.removeAll();
        GridLayout textAreaLayout = new GridLayout(1, 2);
        textAreaLayout.setHgap(4);
        textAreaLayout.setVgap(4);
        JPanel textLabelLine = new JPanel(textAreaLayout);
        textLabelLine.setBackground(null);
        JPanel textAreaLine = new JPanel(textAreaLayout);
        textAreaLine.setBackground(null);
        JButton wikiLinkLabel = new JButton("<html><u>Wiki/Example</u>&nbsp;&#8599;</html>");
        wikiLinkLabel.setToolTipText("Open URL to Github wiki with an example & more details");
        wikiLinkLabel.setSize(256, 32);
        wikiLinkLabel.setMaximumSize(new Dimension(256, 32));
        wikiLinkLabel.setHorizontalAlignment(0);
        wikiLinkLabel.setAlignmentX(0.5f);
        wikiLinkLabel.setForeground(ColorScheme.GRAND_EXCHANGE_LIMIT);
        wikiLinkLabel.addActionListener(e -> LinkBrowser.browse((String)WIKI_HELP_URL));
        JLabel instructionLabel = new JLabel();
        instructionLabel.setText("<html>This window is used to merge two opposing fighters' fight data in order to get more accurate stats about the fight, since some data is only available client-side. Both data entries should come from the same fight, but from two different clients. Fighter 2 is Fighter 1's opponent. Right click a fight in order to copy its data.<br/><br/>When using this, the following stats are applied to deserved damage & deserved magic hits:<br/>&nbsp;&nbsp;&mdash; Offensive prayers, instead of always being correct<br/>&nbsp;&nbsp;&mdash; Boosted or drained levels (e.g from brewing down), instead of using config stats or fixed LMS stats<br/>&nbsp;&nbsp;&mdash; The magic defence buff from Augury, instead of assuming Piety/Rigour while getting maged (if it's used)<br><br><strong>Note: </strong>For now, ghost barrages are not integrated into this, the above improvements do not apply for its deserved damage, and its deserved damage is not included in the main deserved damage stat. It merely displays what each client had saved.</html>");
        instructionLabel.setForeground(Color.WHITE);
        instructionLabel.setSize(this.mainPanel.getWidth(), instructionLabel.getHeight());
        instructionLabel.setHorizontalAlignment(2);
        instructionLabel.setAlignmentX(0.5f);
        JLabel firstFightLabel = new JLabel();
        firstFightLabel.setText("<html><strong>Enter fight data for Fighter 1:</strong><br/>You can drag & drop a text file onto the text box.</html>");
        firstFightLabel.setForeground(Color.WHITE);
        textLabelLine.add(firstFightLabel);
        JLabel secondFightLabel = new JLabel();
        secondFightLabel.setText("<html><strong>Enter fight data for Fighter 2:</strong><br/>You can drag & drop a text file onto the text box.</html>");
        secondFightLabel.setForeground(Color.WHITE);
        textLabelLine.add(secondFightLabel);
        textLabelLine.setSize(this.mainPanel.getWidth(), 48);
        textLabelLine.setMaximumSize(new Dimension(this.mainPanel.getWidth(), 48));
        this.mainFightJsonInput = new JTextField(32);
        this.mainFightJsonInput.setBackground(ColorScheme.MEDIUM_GRAY_COLOR);
        this.mainFightJsonInput.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.mainFightJsonInput.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent evt) {
                try {
                    evt.acceptDrop(1);
                    List droppedFiles = (List)evt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    Iterator iterator = droppedFiles.iterator();
                    if (iterator.hasNext()) {
                        File file = (File)iterator.next();
                        String fileData = new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
                        FightAnalysisFrame.this.mainFightJsonInput.setText(fileData);
                        FightAnalysisFrame.this.validate();
                    }
                    evt.dropComplete(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        textAreaLine.add(this.mainFightJsonInput);
        this.opponentFightJsonInput = new JTextField(32);
        this.opponentFightJsonInput.setBackground(ColorScheme.MEDIUM_GRAY_COLOR);
        this.opponentFightJsonInput.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.opponentFightJsonInput.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent evt) {
                try {
                    evt.acceptDrop(1);
                    List droppedFiles = (List)evt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    Iterator iterator = droppedFiles.iterator();
                    if (iterator.hasNext()) {
                        File file = (File)iterator.next();
                        String fileData = new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
                        FightAnalysisFrame.this.opponentFightJsonInput.setText(fileData);
                        FightAnalysisFrame.this.validate();
                    }
                    evt.dropComplete(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        textAreaLine.add(this.opponentFightJsonInput);
        textAreaLine.setSize(this.mainPanel.getWidth(), 32);
        textAreaLine.setMaximumSize(new Dimension(this.mainPanel.getWidth(), 32));
        JButton confirmButton = new JButton("<html><strong>Merge Fight Data</strong></html>");
        confirmButton.setSize(256, 32);
        confirmButton.setMaximumSize(new Dimension(256, 32));
        confirmButton.addActionListener(e -> this.performAnalysis());
        confirmButton.setAlignmentX(0.5f);
        this.mainPanel.add(wikiLinkLabel);
        this.mainPanel.add(Box.createRigidArea(new Dimension(0, 4)));
        this.mainPanel.add(instructionLabel);
        this.mainPanel.add(Box.createRigidArea(new Dimension(0, 16)));
        this.mainPanel.add(textLabelLine);
        this.mainPanel.add(Box.createRigidArea(new Dimension(0, 4)));
        this.mainPanel.add(textAreaLine);
        this.mainPanel.add(Box.createRigidArea(new Dimension(0, 16)));
        this.mainPanel.add(confirmButton);
        this.validate();
        this.repaint();
    }

    private boolean parseFights() {
        try {
            this.mainFight = (FightPerformance)PvpPerformanceTrackerPlugin.GSON.fromJson(this.mainFightJsonInput.getText().trim(), FightPerformance.class);
            if (this.mainFight == null || this.mainFight.getAllFightLogEntries() == null || this.mainFight.getAllFightLogEntries().size() < 1) {
                PvpPerformanceTrackerPlugin.PLUGIN.createConfirmationModal(false, "Error parsing Fighter 1's fight data.");
                this.mainFight = null;
                return false;
            }
            this.opponentFight = (FightPerformance)PvpPerformanceTrackerPlugin.GSON.fromJson(this.opponentFightJsonInput.getText().trim(), FightPerformance.class);
            if (this.opponentFight == null || this.opponentFight.getAllFightLogEntries() == null || this.opponentFight.getAllFightLogEntries().size() < 1) {
                PvpPerformanceTrackerPlugin.PLUGIN.createConfirmationModal(false, "Error parsing Fighter 2's fight data.");
                this.opponentFight = null;
                return false;
            }
            PvpPerformanceTrackerPlugin.PLUGIN.initializeImportedFight(this.mainFight);
            PvpPerformanceTrackerPlugin.PLUGIN.initializeImportedFight(this.opponentFight);
        }
        catch (Exception e) {
            PvpPerformanceTrackerPlugin.PLUGIN.createConfirmationModal(false, "Error while parsing fight data.");
            return false;
        }
        return true;
    }

    private void performAnalysis() {
        boolean fightsValid = this.parseFights();
        if (!fightsValid) {
            return;
        }
        try {
            this.analyzedFight = new AnalyzedFightPerformance(this.mainFight, this.opponentFight, this::displayAnalysis);
        }
        catch (Exception e) {
            log.info("Error during fight analysis - could not merge fights. Exception tack trace: ", (Throwable)e);
            PvpPerformanceTrackerPlugin.PLUGIN.createConfirmationModal(false, "<html>Error while merging fights. Unable to analyze.<br/>If you think this should have been valid, feel free to submit<br/>an issue on the github repo, and include client logs.</html>");
        }
    }

    private void displayAnalysis() {
        this.mainPanel.removeAll();
        this.setTitle(WINDOW_TITLE + " - " + this.analyzedFight.competitor.getName() + " vs " + this.analyzedFight.opponent.getName());
        JLabel mergedFightLabel = new JLabel("<html><strong>Merged Fight &mdash; Click the panel for more details.</strong></html>");
        mergedFightLabel.setAlignmentX(0.5f);
        mergedFightLabel.setHorizontalAlignment(0);
        FightPerformancePanel analyzedFightPanel = new FightPerformancePanel(this.analyzedFight);
        analyzedFightPanel.setSize(220, 134);
        analyzedFightPanel.setMaximumSize(new Dimension(220, 134));
        analyzedFightPanel.setAlignmentX(0.5f);
        JButton backButton = new JButton("<html><strong>Back</strong></html>");
        backButton.setSize(256, 32);
        backButton.setMaximumSize(new Dimension(256, 32));
        backButton.addActionListener(e -> this.initializeFrame());
        backButton.setAlignmentX(0.5f);
        JCheckBox initialFightCheckbox = new JCheckBox();
        initialFightCheckbox.setText("Show initial fights");
        initialFightCheckbox.setSelected(false);
        initialFightCheckbox.setAlignmentX(0.5f);
        JPanel initialFightsPanel = new JPanel();
        initialFightsPanel.setLayout(new BoxLayout(initialFightsPanel, 0));
        initialFightsPanel.setAlignmentX(0.5f);
        FightPerformancePanel mainFightPanel = new FightPerformancePanel(this.mainFight, false, true, false, null);
        mainFightPanel.setSize(220, 134);
        mainFightPanel.setMaximumSize(new Dimension(220, 134));
        initialFightsPanel.add(mainFightPanel);
        initialFightsPanel.add(Box.createRigidArea(new Dimension(8, 0)));
        FightPerformancePanel oppFightPanel = new FightPerformancePanel(this.opponentFight, false, true, false, null);
        oppFightPanel.setSize(220, 134);
        oppFightPanel.setMaximumSize(new Dimension(220, 134));
        initialFightsPanel.add(oppFightPanel);
        initialFightsPanel.setVisible(false);
        initialFightCheckbox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                initialFightsPanel.setVisible(true);
                this.validate();
                this.repaint();
            } else {
                initialFightsPanel.setVisible(false);
                this.validate();
                this.repaint();
            }
        });
        this.mainPanel.add(mergedFightLabel);
        this.mainPanel.add(Box.createRigidArea(new Dimension(0, 8)));
        this.mainPanel.add(analyzedFightPanel);
        this.mainPanel.add(Box.createRigidArea(new Dimension(0, 8)));
        this.mainPanel.add(backButton);
        this.mainPanel.add(Box.createRigidArea(new Dimension(0, 8)));
        this.mainPanel.add(initialFightCheckbox);
        this.mainPanel.add(Box.createRigidArea(new Dimension(0, 8)));
        this.mainPanel.add(initialFightsPanel);
        this.validate();
        this.repaint();
    }

    static {
        nf.setMaximumFractionDigits(2);
        nf.setRoundingMode(RoundingMode.HALF_UP);
    }
}

