/*
 * Decompiled with CFR 0.152.
 */
package matsyir.pvpperformancetracker.models;

import java.util.Arrays;
import java.util.stream.Collectors;
import matsyir.pvpperformancetracker.models.EquipmentData;
import org.apache.commons.lang3.StringUtils;

public interface RangeAmmoData {
    public static final RangeAmmoData[] DIAMOND_BOLTS = new RangeAmmoData[]{BoltAmmo.DIAMOND_BOLTS_E, StrongBoltAmmo.DIAMOND_BOLTS_E, StrongBoltAmmo.DIAMOND_DRAGON_BOLTS_E};
    public static final RangeAmmoData[] OPAL_BOLTS = new RangeAmmoData[]{StrongBoltAmmo.OPAL_DRAGON_BOLTS_E};

    public int getItemId();

    public int getRangeStr();

    public double getBonusMaxHit(int var1);

    public double getDmgModifier();

    public static enum OtherAmmo implements RangeAmmoData
    {
        AMETHYST_ARROWS(4770, 55),
        DRAGON_ARROW(11216, 60),
        DRAGON_JAVELIN(19484, 150);

        private int rangeStr;
        private int itemId;
        private double bonusMaxHit;
        private double dmgModifier;

        private OtherAmmo(int itemId, int rangeStr) {
            this.itemId = itemId;
            this.rangeStr = rangeStr;
            this.bonusMaxHit = 0.0;
            this.dmgModifier = 1.0;
        }

        @Override
        public double getBonusMaxHit(int rangeLevel) {
            return 0.0;
        }

        public String toString() {
            CharSequence[] words = super.toString().toLowerCase().split("_");
            Arrays.stream(words).map(StringUtils::capitalize).collect(Collectors.toList()).toArray(words);
            return String.join((CharSequence)" ", words);
        }

        @Override
        public int getRangeStr() {
            return this.rangeStr;
        }

        @Override
        public int getItemId() {
            return this.itemId;
        }

        public double getBonusMaxHit() {
            return this.bonusMaxHit;
        }

        @Override
        public double getDmgModifier() {
            return this.dmgModifier;
        }
    }

    public static enum DartAmmo implements RangeAmmoConfigData
    {
        ADAMANT_DARTS("Adamant Darts", 810, 10),
        RUNE_DARTS("Rune Darts", 811, 14),
        DRAGON_DARTS("Dragon Darts", 11230, 20);

        static EquipmentData[] WEAPONS_USING;
        private String name;
        private int itemId;
        private int rangeStr;
        private double bonusMaxHit;
        private double dmgModifier;

        private DartAmmo(String name, int itemId, int rangeStr) {
            this.name = name;
            this.itemId = itemId;
            this.rangeStr = rangeStr;
            this.bonusMaxHit = 0.0;
            this.dmgModifier = 1.0;
        }

        @Override
        public double getBonusMaxHit(int rangeLevel) {
            return 0.0;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getItemId() {
            return this.itemId;
        }

        @Override
        public int getRangeStr() {
            return this.rangeStr;
        }

        public double getBonusMaxHit() {
            return this.bonusMaxHit;
        }

        @Override
        public double getDmgModifier() {
            return this.dmgModifier;
        }

        static {
            WEAPONS_USING = new EquipmentData[]{EquipmentData.TOXIC_BLOWPIPE};
        }
    }

    public static enum StrongBoltAmmo implements RangeAmmoConfigData
    {
        RUNITE_BOLTS("Runite Bolts", 9169, 115, 1.0),
        DRAGONSTONE_BOLTS_E("Dstone Bolts (e)", 9281, 117, 1.0, 0.2, 0.06),
        DIAMOND_BOLTS_E("Diamond Bolts (e)", 9277, 105, 1.015),
        DRAGONSTONE_DRAGON_BOLTS_E("Dstone DBolts (e)", 1668, 122, 1.0, 0.2, 0.06),
        OPAL_DRAGON_BOLTS_E("Opal DBolts (e)", 8729, 122, 1.0, 0.1, 0.05),
        DIAMOND_DRAGON_BOLTS_E("Diamond DBolts (e)", 1690, 122, 1.015);

        static EquipmentData[] WEAPONS_USING;
        private String name;
        private int rangeStr;
        private int itemId;
        private double specRangeLevelModifier;
        private double specChance;
        private double dmgModifier;

        private StrongBoltAmmo(String name, int itemId, int rangeStr, double dmgModifier, double specRangeLevelModifier, double specChance) {
            this.name = name;
            this.itemId = itemId;
            this.rangeStr = rangeStr;
            this.specRangeLevelModifier = specRangeLevelModifier;
            this.specChance = specChance;
            this.dmgModifier = dmgModifier;
        }

        private StrongBoltAmmo(String name, int itemId, int rangeStr, double dmgModifier) {
            this.name = name;
            this.itemId = itemId;
            this.rangeStr = rangeStr;
            this.specRangeLevelModifier = 0.0;
            this.specChance = 0.0;
            this.dmgModifier = dmgModifier;
        }

        @Override
        public double getBonusMaxHit(int rangeLevel) {
            return (double)rangeLevel * this.specRangeLevelModifier * this.specChance;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getRangeStr() {
            return this.rangeStr;
        }

        @Override
        public int getItemId() {
            return this.itemId;
        }

        public double getSpecRangeLevelModifier() {
            return this.specRangeLevelModifier;
        }

        public double getSpecChance() {
            return this.specChance;
        }

        @Override
        public double getDmgModifier() {
            return this.dmgModifier;
        }

        static {
            WEAPONS_USING = new EquipmentData[]{EquipmentData.ARMADYL_CROSSBOW, EquipmentData.DRAGON_CROSSBOW, EquipmentData.DRAGON_HUNTER_CROSSBOW, EquipmentData.ZARYTE_CROSSBOW};
        }
    }

    public static enum BoltAmmo implements RangeAmmoConfigData
    {
        RUNITE_BOLTS("Runite Bolts", 9169, 115, 1.0),
        DRAGONSTONE_BOLTS_E("Dstone Bolts (e)", 9281, 117, 1.0, 0.2, 0.06),
        DIAMOND_BOLTS_E("Diamond Bolts (e)", 9277, 105, 1.015);

        static EquipmentData[] WEAPONS_USING;
        private String name;
        private int itemId;
        private int rangeStr;
        private double specRangeLevelModifier;
        private double specChance;
        private double dmgModifier;

        private BoltAmmo(String name, int itemId, int rangeStr, double dmgModifier, double specRangeLevelModifier, double specChance) {
            this.name = name;
            this.itemId = itemId;
            this.rangeStr = rangeStr;
            this.specRangeLevelModifier = specRangeLevelModifier;
            this.specChance = specChance;
            this.dmgModifier = dmgModifier;
        }

        private BoltAmmo(String name, int itemId, int rangeStr, double dmgModifier) {
            this.name = name;
            this.itemId = itemId;
            this.rangeStr = rangeStr;
            this.specRangeLevelModifier = 0.0;
            this.specChance = 0.0;
            this.dmgModifier = dmgModifier;
        }

        @Override
        public double getBonusMaxHit(int rangeLevel) {
            return (double)rangeLevel * this.specRangeLevelModifier * this.specChance;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getItemId() {
            return this.itemId;
        }

        @Override
        public int getRangeStr() {
            return this.rangeStr;
        }

        public double getSpecRangeLevelModifier() {
            return this.specRangeLevelModifier;
        }

        public double getSpecChance() {
            return this.specChance;
        }

        @Override
        public double getDmgModifier() {
            return this.dmgModifier;
        }

        static {
            WEAPONS_USING = new EquipmentData[]{EquipmentData.RUNE_CROSSBOW};
        }
    }

    public static interface RangeAmmoConfigData
    extends RangeAmmoData {
        public String getName();
    }
}

