/*
 * Decompiled with CFR 0.152.
 */
package matsyir.pvpperformancetracker.models;

import java.util.HashMap;
import java.util.Map;
import matsyir.pvpperformancetracker.PvpPerformanceTrackerPlugin;
import matsyir.pvpperformancetracker.models.RangeAmmoData;
import net.runelite.api.kit.KitType;
import org.apache.commons.lang3.ArrayUtils;

public enum EquipmentData {
    DRAGON_CROSSBOW(21902),
    DRAGON_HUNTER_CROSSBOW(21012),
    MAGIC_SHORTBOW(861),
    MAGIC_SHORTBOW_I(12788),
    TOXIC_BLOWPIPE(12926),
    VOLATILE_NIGHTMARE_STAFF(24424),
    SMOKE_BATTLESTAFF(11998),
    VOID_MAGE_HELM(11663, 24183),
    VOID_RANGE_HELM(11664, 24184),
    VOID_MELEE_HELM(11665, 24185),
    VOID_ELITE_BODY(13072, 24178),
    VOID_ELITE_LEGS(13073, 24180),
    VOID_GLOVES(8842, 24182),
    VOID_BODY(8839, 24177),
    VOID_LEGS(8840, 24179),
    CRYSTAL_HELM(23971),
    CRYSTAL_BODY(23975),
    CRYSTAL_LEGS(23979),
    CRYSTAL_BOW(4214, 23983, 4223, 4222, 4221, 4220, 4219, 4218, 4217, 4216, 4215),
    CRYSTAL_BOW_I(11749, 11758, 11757, 11756, 11755, 11754, 11753, 11752, 11751, 11750),
    DRAGON_LONGSWORD(1305),
    OSMUMTENS_FANG(26219),
    RUNE_CROSSBOW(9185, 23601),
    ARMADYL_CROSSBOW(11785, 23611),
    DARK_BOW(11235, 20408, 12765, 12766, 12767, 12768),
    HEAVY_BALLISTA(19481, 23630),
    STATIUS_WARHAMMER(22622, 23620),
    VESTAS_LONGSWORD(22613, 23615, 24617),
    ARMADYL_GODSWORD(11802, 20593, 20368),
    DRAGON_CLAWS(13652, 20784),
    DRAGON_DAGGER(1215, 20407, 1231, 5680, 5698),
    GRANITE_MAUL(4153, 12848, 20557, 24225, 24227),
    AMULET_OF_FURY(6585, 23640),
    BANDOS_TASSETS(11834, 23646),
    BLESSED_SPIRIT_SHIELD(12831, 23642),
    DHAROKS_HELM(4716, 23639),
    DHAROKS_PLATELEGS(4722, 23633),
    GUTHANS_HELM(4724, 23638),
    KARILS_TOP(4736, 23632),
    TORAGS_HELM(4745, 23637),
    TORAGS_PLATELEGS(4751, 23634),
    VERACS_HELM(4753, 23636),
    VERACS_PLATESKIRT(4759, 23635),
    MORRIGANS_JAVELIN(22636, 23619),
    SPIRIT_SHIELD(12829, 23599),
    HELM_OF_NEITIZNOT(10828, 23591),
    AMULET_OF_GLORY(1704, 20586),
    ABYSSAL_WHIP(4151, 20405),
    DRAGON_DEFENDER(12954, 23597),
    BLACK_DHIDE_BODY(2503, 20423),
    RUNE_PLATELEGS(1079, 20422),
    CLIMBING_BOOTS(3105, 20578),
    BARROWS_GLOVES(7462, 23593),
    ELDER_MAUL(21003, 21205),
    INFERNAL_CAPE(21295, 23622),
    GHRAZI_RAPIER(22324, 23628),
    ZURIELS_STAFF(22647, 23617),
    STAFF_OF_THE_DEAD(11791, 23613),
    KODAI_WAND(21006, 23626),
    AHRIMS_STAFF(4710, 23653),
    MYSTIC_ROBE_TOP(4091, 20425, 27158, 27160),
    MYSTIC_ROBE_BOTTOM(4093, 20426, 27159, 27161),
    AHRIMS_ROBE_TOP(4712, 20598),
    AHRIMS_ROBE_SKIRT(4714, 20599),
    OCCULT_NECKLACE(12002, 23654),
    MAGES_BOOK(6889, 23652),
    ETERNAL_BOOTS(13235, 23644),
    IMBUED_ZAMORAK_CAPE(21795, 23605),
    IMBUED_GUTHIX_CAPE(21793, 23603),
    IMBUED_SARADOMIN_CAPE(21791, 23607),
    TOME_OF_FIRE(20714, 27358),
    WIZARD_BOOTS(2579, 27162),
    GUTHIX_HALO(12639, 27163),
    ZAMORAK_HALO(12638, 27164),
    SARADOMIN_HALO(12637, 27165),
    GHOSTLY_HOOD(6109, 27166),
    GHOSTLY_ROBETOP(6107, 27167),
    GHOSTLY_ROBE(6108, 27168),
    BERSERKER_HELM(3751, 27169),
    INFINITY_BOOTS(6920, 27170),
    TORMENTED_BRACELET(19544, 27171),
    NECKLACE_OF_ANGUISH(19547, 27172, 22249),
    ELDER_CHAOS_TOP(20517, 27174, 27115),
    ELDER_CHAOS_ROBE(20520, 27175, 27117),
    ELDER_CHAOS_HOOD(20595, 27176, 27119),
    FREMENNIK_KILT(23246, 27177),
    SPIKED_MANACLES(23389, 27178),
    RANGERS_TUNIC(12596, 27179),
    GUTHIX_CHAPS(10380, 27180),
    ZAMORAK_CHAPS(10372, 27181),
    SARADOMIN_CHAPS(10388, 27182),
    _3RD_AGE_MAGE_HAT(10342, 27183),
    ANCIENT_GODSWORD(26233, 27184),
    RUNE_DEFENDER(8850, 27185),
    ZARYTE_CROSSBOW(26374, 27186),
    BOW_OF_FAERDHINEN(25865, 25867, 25869, 25884, 25886, 25888, 25890, 25892, 25894, 25896, 27187),
    LIGHT_BALLISTA(19478, 27188),
    VERACS_FLAIL(4755, 27189),
    VERACS_BRASSARD(4757, 27190),
    UNHOLY_BOOK(3842, 27191),
    ANCESTRAL_ROBE_TOP(21021, 27193, 24666),
    ANCESTRAL_ROBE_BOTTOM(21024, 27194, 24668),
    INQUISITORS_GREAT_HELM(24419, 27195),
    INQUISITORS_HAUBERK(24420, 27196),
    INQUISITORS_PLATESKIRT(24421, 27197),
    INQUISITORS_MACE(24417, 27198),
    _3RD_AGE_RANGE_TOP(10330, 27199),
    _3RD_AGE_RANGE_LEGS(10332, 27200),
    _3RD_AGE_RANGE_COIF(10334, 27201),
    DRAGON_WARHAMMER(13576, 20785),
    VOIDWAKER(27690, 27869);

    private static final Map<Integer, EquipmentData> itemData;
    private final int itemId;
    private final int[] additionalIds;

    private EquipmentData(int itemId) {
        this.itemId = itemId;
        this.additionalIds = null;
    }

    private EquipmentData(int itemId, int ... itemIds) {
        this.itemId = itemId;
        this.additionalIds = itemIds;
    }

    public static EquipmentData fromId(int itemId) {
        return itemData.get(itemId);
    }

    public static RangeAmmoData getWeaponAmmo(EquipmentData weapon) {
        if (ArrayUtils.contains((Object[])RangeAmmoData.BoltAmmo.WEAPONS_USING, (Object)((Object)weapon))) {
            return PvpPerformanceTrackerPlugin.CONFIG.boltChoice();
        }
        if (ArrayUtils.contains((Object[])RangeAmmoData.StrongBoltAmmo.WEAPONS_USING, (Object)((Object)weapon))) {
            return PvpPerformanceTrackerPlugin.CONFIG.strongBoltChoice();
        }
        if (ArrayUtils.contains((Object[])RangeAmmoData.DartAmmo.WEAPONS_USING, (Object)((Object)weapon))) {
            return PvpPerformanceTrackerPlugin.CONFIG.bpDartChoice();
        }
        if (weapon == HEAVY_BALLISTA || weapon == LIGHT_BALLISTA) {
            return RangeAmmoData.OtherAmmo.DRAGON_JAVELIN;
        }
        if (weapon == DARK_BOW) {
            return RangeAmmoData.OtherAmmo.DRAGON_ARROW;
        }
        if (weapon == MAGIC_SHORTBOW || weapon == MAGIC_SHORTBOW_I) {
            return RangeAmmoData.OtherAmmo.AMETHYST_ARROWS;
        }
        return null;
    }

    public int getItemId() {
        return this.itemId;
    }

    public int[] getAdditionalIds() {
        return this.additionalIds;
    }

    static {
        itemData = new HashMap<Integer, EquipmentData>();
        for (EquipmentData data : EquipmentData.values()) {
            itemData.putIfAbsent(data.getItemId(), data);
            if (data.additionalIds == null || data.additionalIds.length <= 0) continue;
            for (int id : data.additionalIds) {
                itemData.putIfAbsent(id, data);
            }
        }
    }

    public static enum VoidStyle {
        VOID_MELEE(1.1, 1.1),
        VOID_RANGE(1.1, 1.1),
        VOID_MAGE(1.45, 1.0),
        VOID_ELITE_MELEE(1.1, 1.1),
        VOID_ELITE_RANGE(1.125, 1.125),
        VOID_ELITE_MAGE(1.45, 1.025),
        NONE(1.0, 1.0);

        public double accuracyModifier;
        public double dmgModifier;

        private VoidStyle(double accuracyModifier, double dmgModifier) {
            this.accuracyModifier = accuracyModifier;
            this.dmgModifier = dmgModifier;
        }

        public static VoidStyle getVoidStyleFor(int[] playerComposition) {
            if (playerComposition == null) {
                return NONE;
            }
            EquipmentData gloves = EquipmentData.fromId((playerComposition = PvpPerformanceTrackerPlugin.fixItemIds(playerComposition))[KitType.HANDS.getIndex()]);
            if (gloves != VOID_GLOVES) {
                return NONE;
            }
            EquipmentData helm = EquipmentData.fromId(playerComposition[KitType.HEAD.getIndex()]);
            EquipmentData torso = EquipmentData.fromId(playerComposition[KitType.TORSO.getIndex()]);
            EquipmentData legs = EquipmentData.fromId(playerComposition[KitType.LEGS.getIndex()]);
            if (torso == VOID_BODY && legs == VOID_LEGS) {
                return helm == VOID_MAGE_HELM ? VOID_MAGE : (helm == VOID_RANGE_HELM ? VOID_RANGE : (helm == VOID_MELEE_HELM ? VOID_MELEE : NONE));
            }
            if (torso == VOID_ELITE_BODY && legs == VOID_ELITE_LEGS) {
                return helm == VOID_MAGE_HELM ? VOID_ELITE_MAGE : (helm == VOID_RANGE_HELM ? VOID_ELITE_RANGE : (helm == VOID_MELEE_HELM ? VOID_ELITE_MELEE : NONE));
            }
            return NONE;
        }
    }
}

