/*
 * Decompiled with CFR 0.152.
 */
package matsyir.pvpperformancetracker.controllers;

import java.util.Arrays;
import matsyir.pvpperformancetracker.PvpPerformanceTrackerPlugin;
import matsyir.pvpperformancetracker.controllers.FightPerformance;
import matsyir.pvpperformancetracker.models.AnimationData;
import matsyir.pvpperformancetracker.models.CombatLevels;
import matsyir.pvpperformancetracker.models.EquipmentData;
import matsyir.pvpperformancetracker.models.FightLogEntry;
import matsyir.pvpperformancetracker.models.RangeAmmoData;
import matsyir.pvpperformancetracker.models.RingData;
import net.runelite.api.Player;
import net.runelite.api.kit.KitType;
import net.runelite.http.api.item.ItemEquipmentStats;
import net.runelite.http.api.item.ItemStats;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PvpDamageCalc {
    private static final Logger log = LoggerFactory.getLogger(PvpDamageCalc.class);
    private static final int STAB_ATTACK = 0;
    private static final int SLASH_ATTACK = 1;
    private static final int CRUSH_ATTACK = 2;
    private static final int MAGIC_ATTACK = 3;
    private static final int RANGE_ATTACK = 4;
    private static final int STAB_DEF = 5;
    private static final int SLASH_DEF = 6;
    private static final int CRUSH_DEF = 7;
    private static final int MAGIC_DEF = 8;
    private static final int RANGE_DEF = 9;
    private static final int STRENGTH_BONUS = 10;
    private static final int RANGE_STRENGTH = 11;
    private static final int MAGIC_DAMAGE = 12;
    private static final int STANCE_BONUS = 0;
    private static final double UNSUCCESSFUL_PRAY_DMG_MODIFIER = 0.6;
    private static final double PIETY_ATK_PRAYER_MODIFIER = 1.2;
    private static final double PIETY_STR_PRAYER_MODIFIER = 1.23;
    private static final double AUGURY_OFFENSIVE_PRAYER_MODIFIER = 1.25;
    private static final double RIGOUR_OFFENSIVE_PRAYER_DMG_MODIFIER = 1.23;
    private static final double RIGOUR_OFFENSIVE_PRAYER_ATTACK_MODIFIER = 1.2;
    private static final double PIETY_DEF_PRAYER_MODIFIER = 1.25;
    private static final double AUGURY_DEF_PRAYER_MODIFIER = 1.25;
    private static final double AUGURY_MAGEDEF_PRAYER_MODIFIER = 1.25;
    private static final double RIGOUR_DEF_PRAYER_MODIFIER = 1.25;
    private static final double BALLISTA_SPEC_ACCURACY_MODIFIER = 1.25;
    private static final double BALLISTA_SPEC_DMG_MODIFIER = 1.25;
    private static final int ACB_SPEC_ACCURACY_MODIFIER = 2;
    private static final int DBOW_DMG_MODIFIER = 2;
    private static final int DBOW_SPEC_DMG_MODIFIER = 3;
    private static final int DBOW_SPEC_MIN_HIT = 16;
    private static final double DDS_SPEC_ACCURACY_MODIFIER = 1.25;
    private static final double DDS_SPEC_DMG_MODIFIER = 2.3;
    private static final int ARMA_GS_SPEC_ACCURACY_MODIFIER = 2;
    private static final double ARMA_GS_SPEC_DMG_MODIFIER = 1.375;
    private static final int ANCIENT_GS_SPEC_ACCURACY_MODIFIER = 2;
    private static final double FANG_SPEC_ACCURACY_MODIFIER = 1.5;
    private static final double ANCIENT_GS_SPEC_DMG_MODIFIER = 1.1;
    private static final int ANCIENT_GS_FIXED_DAMAGE = 25;
    private static final double VLS_SPEC_DMG_MODIFIER = 1.2;
    private static final double VLS_SPEC_MIN_DMG_MODIFIER = 0.2;
    private static final double VLS_SPEC_DEFENCE_SCALE = 0.25;
    private static final double SWH_SPEC_DMG_MODIFIER = 1.25;
    private static final double SWH_SPEC_MIN_DMG_MODIFIER = 0.25;
    private static final double DWH_SPEC_DMG_MODIFIER = 1.5;
    private static final double VOIDWAKER_SPEC_DMG_MODIFIER = 1.5;
    private static final double VOIDWAKER_SPEC_MIN_DMG_MODIFIER = 0.5;
    private static final double VOIDWAKER_FIXED_ACCURACY = 1.0;
    public static final double BRIMSTONE_RING_OPPONENT_DEF_MODIFIER = 0.975;
    public static final double SMOKE_BATTLESTAFF_DMG_ACC_MODIFIER = 1.1;
    public static final double TOME_OF_FIRE_DMG_MODIFIER = 1.5;
    public static final double VOLATILE_NIGHTMARE_STAFF_ACC_MODIFIER = 0.5;
    private double averageHit = 0.0;
    private double accuracy = 0.0;
    private int minHit = 0;
    private int maxHit = 0;
    private CombatLevels attackerLevels;
    private CombatLevels defenderLevels;
    private RingData ringUsed;
    boolean isLmsFight;

    public PvpDamageCalc(FightPerformance relatedFight) {
        this.isLmsFight = relatedFight.fightType.isLmsFight();
        this.attackerLevels = relatedFight.fightType.getCombatLevelsForType();
        this.defenderLevels = relatedFight.fightType.getCombatLevelsForType();
        this.ringUsed = this.isLmsFight ? RingData.BERSERKER_RING : PvpPerformanceTrackerPlugin.CONFIG.ringChoice();
    }

    public void updateDamageStats(Player attacker, Player defender, boolean success, AnimationData animationData) {
        if (attacker == null || defender == null) {
            return;
        }
        this.averageHit = 0.0;
        this.accuracy = 0.0;
        this.minHit = 0;
        this.maxHit = 0;
        int[] attackerItems = attacker.getPlayerComposition().getEquipmentIds();
        int[] defenderItems = defender.getPlayerComposition().getEquipmentIds();
        EquipmentData weapon = EquipmentData.fromId(PvpPerformanceTrackerPlugin.fixItemId(attackerItems[KitType.WEAPON.getIndex()]));
        int[] playerStats = this.calculateBonusesWithRing(attackerItems);
        int[] opponentStats = this.calculateBonusesWithRing(defenderItems);
        AnimationData.AttackStyle attackStyle = animationData.attackStyle;
        boolean isSpecial = animationData.isSpecial;
        EquipmentData.VoidStyle voidStyle = EquipmentData.VoidStyle.getVoidStyleFor(attacker.getPlayerComposition().getEquipmentIds());
        if (attackStyle.isMelee() || animationData == AnimationData.MELEE_VOIDWAKER_SPEC) {
            this.getMeleeMaxHit(playerStats[10], isSpecial, weapon, voidStyle, true);
            this.getMeleeAccuracy(playerStats, opponentStats, attackStyle, isSpecial, weapon, voidStyle, true);
        } else if (attackStyle == AnimationData.AttackStyle.RANGED) {
            this.getRangedMaxHit(playerStats[11], isSpecial, weapon, voidStyle, true, attackerItems);
            this.getRangeAccuracy(playerStats[4], opponentStats[9], isSpecial, weapon, voidStyle, true, attackerItems);
        } else if (attackStyle == AnimationData.AttackStyle.MAGIC) {
            EquipmentData shield = EquipmentData.fromId(PvpPerformanceTrackerPlugin.fixItemId(attackerItems[KitType.SHIELD.getIndex()]));
            this.getMagicMaxHit(shield, playerStats[12], animationData, weapon, voidStyle, true);
            this.getMagicAccuracy(playerStats[3], opponentStats[8], weapon, animationData, voidStyle, true, false);
        }
        this.getAverageHit(success, weapon, isSpecial);
        this.maxHit = (int)((double)this.maxHit * (success ? 1.0 : 0.6));
        log.debug("attackStyle: " + attackStyle.toString() + ", avgHit: " + FightLogEntry.nf.format(this.averageHit) + ", acc: " + FightLogEntry.nf.format(this.accuracy) + "\nattacker(" + attacker.getName() + ")stats: " + Arrays.toString(playerStats) + "\ndefender(" + defender.getName() + ")stats: " + Arrays.toString(opponentStats));
    }

    public void updateDamageStats(FightLogEntry atkLog, FightLogEntry defenderLog) {
        this.attackerLevels = atkLog.getAttackerLevels();
        this.defenderLevels = defenderLog.getAttackerLevels();
        int[] attackerItems = atkLog.getAttackerGear();
        int[] defenderItems = atkLog.getDefenderGear();
        boolean success = atkLog.success();
        AnimationData animationData = atkLog.getAnimationData();
        boolean successfulOffensive = atkLog.getAnimationData().attackStyle.isUsingSuccessfulOffensivePray(atkLog.getAttackerOffensivePray());
        this.averageHit = 0.0;
        this.accuracy = 0.0;
        this.minHit = 0;
        this.maxHit = 0;
        EquipmentData weapon = EquipmentData.fromId(PvpPerformanceTrackerPlugin.fixItemId(attackerItems[KitType.WEAPON.getIndex()]));
        int[] playerStats = PvpDamageCalc.calculateBonuses(attackerItems);
        int[] opponentStats = PvpDamageCalc.calculateBonuses(defenderItems);
        AnimationData.AttackStyle attackStyle = animationData.attackStyle;
        boolean isSpecial = animationData.isSpecial;
        EquipmentData.VoidStyle voidStyle = EquipmentData.VoidStyle.getVoidStyleFor(attackerItems);
        if (attackStyle.isMelee()) {
            this.getMeleeMaxHit(playerStats[10], isSpecial, weapon, voidStyle, successfulOffensive);
            this.getMeleeAccuracy(playerStats, opponentStats, attackStyle, isSpecial, weapon, voidStyle, successfulOffensive);
        } else if (attackStyle == AnimationData.AttackStyle.RANGED) {
            this.getRangedMaxHit(playerStats[11], isSpecial, weapon, voidStyle, successfulOffensive, attackerItems);
            this.getRangeAccuracy(playerStats[4], opponentStats[9], isSpecial, weapon, voidStyle, successfulOffensive, attackerItems);
        } else if (attackStyle == AnimationData.AttackStyle.MAGIC) {
            EquipmentData shield = EquipmentData.fromId(PvpPerformanceTrackerPlugin.fixItemId(attackerItems[KitType.SHIELD.getIndex()]));
            this.getMagicMaxHit(shield, playerStats[12], animationData, weapon, voidStyle, successfulOffensive);
            this.getMagicAccuracy(playerStats[3], opponentStats[8], weapon, animationData, voidStyle, successfulOffensive, defenderLog.getAttackerOffensivePray() == 1421);
        }
        this.getAverageHit(success, weapon, isSpecial);
        this.maxHit = (int)((double)this.maxHit * (success ? 1.0 : 0.6));
    }

    private void getAverageHit(boolean success, EquipmentData weapon, boolean usingSpec) {
        double averageSuccessfulHit;
        double prayerModifier;
        boolean ancientGs = weapon == EquipmentData.ANCIENT_GODSWORD;
        boolean dbow = weapon == EquipmentData.DARK_BOW;
        boolean claws = weapon == EquipmentData.DRAGON_CLAWS;
        boolean fang = weapon == EquipmentData.OSMUMTENS_FANG;
        boolean vls = weapon == EquipmentData.VESTAS_LONGSWORD;
        boolean swh = weapon == EquipmentData.STATIUS_WARHAMMER;
        boolean voidwaker = weapon == EquipmentData.VOIDWAKER;
        double d = prayerModifier = success ? 1.0 : 0.6;
        if (usingSpec && (dbow || vls || swh)) {
            double accuracyAdjuster = dbow ? this.accuracy : 1.0;
            this.minHit = dbow ? 16 : 0;
            this.minHit = vls ? (int)((double)this.maxHit * 0.2) : this.minHit;
            this.minHit = swh ? (int)((double)this.maxHit * 0.25) : this.minHit;
            int total = 0;
            for (int i = 0; i <= this.maxHit; ++i) {
                total = (int)((double)total + (i < this.minHit ? (double)this.minHit / accuracyAdjuster : (double)i));
            }
            averageSuccessfulHit = (double)total / (double)this.maxHit;
        } else {
            if (usingSpec && claws) {
                double invertedAccuracy = 1.0 - this.accuracy;
                double averageSuccessfulRegularHit = this.maxHit / 2;
                double higherModifierChance = this.accuracy + this.accuracy * invertedAccuracy;
                double lowerModifierChance = this.accuracy * Math.pow(invertedAccuracy, 2.0) + this.accuracy * Math.pow(invertedAccuracy, 3.0);
                double averageSpecialHit = (higherModifierChance * 2.0 + lowerModifierChance * 1.5) * averageSuccessfulRegularHit;
                this.averageHit = averageSpecialHit * prayerModifier;
                this.accuracy = higherModifierChance + lowerModifierChance;
                this.maxHit = this.maxHit * 2 + 1;
                return;
            }
            if (fang) {
                double maxHitMultiplier = usingSpec ? 1.0 : 0.85;
                double invertedAccuracy = 1.0 - this.accuracy;
                double chanceOfMissingTwice = Math.pow(invertedAccuracy, 2.0);
                this.accuracy = 1.0 - chanceOfMissingTwice;
                this.minHit = (int)(0.15 * (double)this.maxHit);
                this.maxHit = (int)(maxHitMultiplier * (double)this.maxHit);
                averageSuccessfulHit = (double)(this.minHit + this.maxHit) / 2.0;
            } else if (usingSpec && voidwaker) {
                this.minHit = (int)((double)this.maxHit * 0.5);
                averageSuccessfulHit = (double)(this.minHit + this.maxHit) / 2.0;
            } else {
                averageSuccessfulHit = (double)(this.minHit + this.maxHit) / 2.0;
                if (this.minHit > 0) {
                    log.info("PvpDamageCalc:getAverageHit: Fell into default avg hit calculation with a minHit > 0 (" + this.minHit + "). Shouldn't happen. Weapon: " + weapon.toString());
                }
            }
        }
        this.averageHit = this.accuracy * averageSuccessfulHit * prayerModifier;
        if (usingSpec && ancientGs) {
            this.averageHit += 25.0;
        }
    }

    private void getMeleeMaxHit(int meleeStrength, boolean usingSpec, EquipmentData weapon, EquipmentData.VoidStyle voidStyle, boolean successfulOffensive) {
        boolean ags = weapon == EquipmentData.ARMADYL_GODSWORD;
        boolean ancientGs = weapon == EquipmentData.ANCIENT_GODSWORD;
        boolean dds = weapon == EquipmentData.DRAGON_DAGGER;
        boolean vls = weapon == EquipmentData.VESTAS_LONGSWORD;
        boolean swh = weapon == EquipmentData.STATIUS_WARHAMMER;
        boolean dwh = weapon == EquipmentData.DRAGON_WARHAMMER;
        boolean voidwaker = weapon == EquipmentData.VOIDWAKER;
        int effectiveLevel = (int)Math.floor((double)this.attackerLevels.str * (successfulOffensive ? 1.23 : 1.0) + 8.0 + 3.0);
        if (voidStyle == EquipmentData.VoidStyle.VOID_ELITE_MELEE || voidStyle == EquipmentData.VoidStyle.VOID_MELEE) {
            effectiveLevel = (int)((double)effectiveLevel * voidStyle.dmgModifier);
        }
        int baseDamage = (int)Math.floor(0.5 + (double)(effectiveLevel * (meleeStrength + 64) / 640));
        double damageModifier = ags && usingSpec ? 1.375 : (ancientGs && usingSpec ? 1.1 : (swh && usingSpec ? 1.25 : (dds && usingSpec ? 2.3 : (vls && usingSpec ? 1.2 : (dwh && usingSpec ? 1.5 : (voidwaker && usingSpec ? 1.5 : 1.0))))));
        this.maxHit = (int)(damageModifier * (double)baseDamage);
    }

    private void getRangedMaxHit(int rangeStrength, boolean usingSpec, EquipmentData weapon, EquipmentData.VoidStyle voidStyle, boolean successfulOffensive, int[] attackerComposition) {
        RangeAmmoData weaponAmmo = EquipmentData.getWeaponAmmo(weapon);
        EquipmentData head = EquipmentData.fromId(PvpPerformanceTrackerPlugin.fixItemId(attackerComposition[KitType.HEAD.getIndex()]));
        EquipmentData body = EquipmentData.fromId(PvpPerformanceTrackerPlugin.fixItemId(attackerComposition[KitType.TORSO.getIndex()]));
        EquipmentData legs = EquipmentData.fromId(PvpPerformanceTrackerPlugin.fixItemId(attackerComposition[KitType.LEGS.getIndex()]));
        if (this.isLmsFight) {
            weaponAmmo = weaponAmmo instanceof RangeAmmoData.StrongBoltAmmo ? RangeAmmoData.StrongBoltAmmo.OPAL_DRAGON_BOLTS_E : (weaponAmmo instanceof RangeAmmoData.BoltAmmo ? RangeAmmoData.BoltAmmo.DIAMOND_BOLTS_E : weaponAmmo);
        }
        boolean ballista = weapon == EquipmentData.HEAVY_BALLISTA;
        boolean dbow = weapon == EquipmentData.DARK_BOW;
        int ammoStrength = weaponAmmo == null ? 0 : weaponAmmo.getRangeStr();
        rangeStrength += ammoStrength;
        int effectiveLevel = (int)Math.floor((double)this.attackerLevels.range * (successfulOffensive ? 1.23 : 1.0) + 8.0);
        if (voidStyle == EquipmentData.VoidStyle.VOID_ELITE_RANGE || voidStyle == EquipmentData.VoidStyle.VOID_RANGE) {
            effectiveLevel = (int)((double)effectiveLevel * voidStyle.dmgModifier);
        }
        int baseDamage = (int)Math.floor(0.5 + (double)(effectiveLevel * (rangeStrength + 64) / 640));
        double modifier = weaponAmmo == null ? 1.0 : weaponAmmo.getDmgModifier();
        modifier = ballista && usingSpec ? 1.25 : modifier;
        modifier = dbow && !usingSpec ? 2.0 : modifier;
        modifier = dbow && usingSpec ? 3.0 : modifier;
        int n = this.maxHit = weaponAmmo == null ? (int)(modifier * (double)baseDamage) : (int)(modifier * (double)baseDamage + weaponAmmo.getBonusMaxHit(this.attackerLevels.range));
        if (!(weapon != EquipmentData.BOW_OF_FAERDHINEN && weapon != EquipmentData.CRYSTAL_BOW && weapon != EquipmentData.CRYSTAL_BOW_I || head != EquipmentData.CRYSTAL_HELM && body != EquipmentData.CRYSTAL_BODY && legs != EquipmentData.CRYSTAL_LEGS)) {
            double dmgModifier = 1.0 + (head == EquipmentData.CRYSTAL_HELM ? 0.025 : 0.0) + (body == EquipmentData.CRYSTAL_BODY ? 0.075 : 0.0) + (legs == EquipmentData.CRYSTAL_LEGS ? 0.05 : 0.0);
            this.maxHit = (int)((double)this.maxHit * dmgModifier);
        }
    }

    private void getMagicMaxHit(EquipmentData shield, int mageDamageBonus, AnimationData animationData, EquipmentData weapon, EquipmentData.VoidStyle voidStyle, boolean successfulOffensive) {
        boolean smokeBstaff = weapon == EquipmentData.SMOKE_BATTLESTAFF;
        boolean tome = shield == EquipmentData.TOME_OF_FIRE;
        double magicBonus = 1.0 + (double)mageDamageBonus / 100.0;
        if (smokeBstaff && AnimationData.isStandardSpellbookSpell(animationData)) {
            magicBonus *= 1.1;
        }
        if (tome && AnimationData.isFireSpell(animationData)) {
            magicBonus *= 1.5;
        }
        if (voidStyle == EquipmentData.VoidStyle.VOID_ELITE_MAGE || voidStyle == EquipmentData.VoidStyle.VOID_MAGE) {
            magicBonus *= voidStyle.dmgModifier;
        }
        this.maxHit = (int)((double)animationData.baseSpellDamage * magicBonus);
    }

    private void getMeleeAccuracy(int[] playerStats, int[] opponentStats, AnimationData.AttackStyle attackStyle, boolean usingSpec, EquipmentData weapon, EquipmentData.VoidStyle voidStyle, boolean successfulOffensive) {
        double attackBonus;
        boolean voidwaker;
        boolean vls = weapon == EquipmentData.VESTAS_LONGSWORD;
        boolean ags = weapon == EquipmentData.ARMADYL_GODSWORD;
        boolean ancientGs = weapon == EquipmentData.ANCIENT_GODSWORD;
        boolean dds = weapon == EquipmentData.DRAGON_DAGGER;
        boolean fang = weapon == EquipmentData.OSMUMTENS_FANG;
        boolean bl = voidwaker = weapon == EquipmentData.VOIDWAKER;
        if (voidwaker && usingSpec) {
            this.accuracy = 1.0;
            return;
        }
        double stabBonusPlayer = playerStats[0];
        double slashBonusPlayer = playerStats[1];
        double crushBonusPlayer = playerStats[2];
        double stabBonusTarget = opponentStats[5];
        double slashBonusTarget = opponentStats[6];
        double crushBonusTarget = opponentStats[7];
        double magicBonusTarget = opponentStats[8];
        double defenderChance = 0.0;
        double accuracyModifier = dds ? 1.25 : (ags ? 2.0 : (ancientGs ? 2.0 : (fang ? 1.5 : 1.0)));
        double effectiveLevelPlayer = Math.floor((double)this.attackerLevels.atk * (successfulOffensive ? 1.2 : 1.0) + 0.0 + 8.0);
        if (voidStyle == EquipmentData.VoidStyle.VOID_ELITE_MELEE || voidStyle == EquipmentData.VoidStyle.VOID_MELEE) {
            effectiveLevelPlayer *= voidStyle.accuracyModifier;
        }
        double d = attackStyle == AnimationData.AttackStyle.STAB ? stabBonusPlayer : (attackBonus = attackStyle == AnimationData.AttackStyle.SLASH ? slashBonusPlayer : crushBonusPlayer);
        double targetDefenceBonus = attackStyle == AnimationData.AttackStyle.STAB ? stabBonusTarget : (attackStyle == AnimationData.AttackStyle.SLASH ? slashBonusTarget : crushBonusTarget);
        double baseChance = Math.floor(effectiveLevelPlayer * (attackBonus + 64.0));
        if (usingSpec) {
            baseChance *= accuracyModifier;
        }
        double attackerChance = baseChance;
        double effectiveLevelTarget = Math.floor((double)this.defenderLevels.def * 1.25 + 0.0 + 8.0);
        defenderChance = vls && usingSpec ? Math.floor(effectiveLevelTarget * (stabBonusTarget + 64.0) * 0.25) : Math.floor(effectiveLevelTarget * (targetDefenceBonus + 64.0));
        this.accuracy = attackerChance > defenderChance ? 1.0 - (defenderChance + 2.0) / (2.0 * (attackerChance + 1.0)) : attackerChance / (2.0 * (defenderChance + 1.0));
    }

    private void getRangeAccuracy(int playerRangeAtt, int opponentRangeDef, boolean usingSpec, EquipmentData weapon, EquipmentData.VoidStyle voidStyle, boolean successfulOffensive, int[] attackerComposition) {
        double attackerChance;
        RangeAmmoData weaponAmmo = EquipmentData.getWeaponAmmo(weapon);
        if (this.isLmsFight && (weaponAmmo instanceof RangeAmmoData.BoltAmmo || weaponAmmo instanceof RangeAmmoData.StrongBoltAmmo)) {
            weaponAmmo = RangeAmmoData.BoltAmmo.DIAMOND_BOLTS_E;
        }
        boolean diamonds = ArrayUtils.contains((Object[])RangeAmmoData.DIAMOND_BOLTS, (Object)weaponAmmo);
        boolean opals = ArrayUtils.contains((Object[])RangeAmmoData.OPAL_BOLTS, (Object)weaponAmmo);
        double effectiveLevelPlayer = Math.floor((double)this.attackerLevels.range * (successfulOffensive ? 1.2 : 1.0) + 0.0 + 8.0);
        if (voidStyle == EquipmentData.VoidStyle.VOID_ELITE_RANGE || voidStyle == EquipmentData.VoidStyle.VOID_RANGE) {
            effectiveLevelPlayer *= voidStyle.accuracyModifier;
        }
        EquipmentData head = EquipmentData.fromId(PvpPerformanceTrackerPlugin.fixItemId(attackerComposition[KitType.HEAD.getIndex()]));
        EquipmentData body = EquipmentData.fromId(PvpPerformanceTrackerPlugin.fixItemId(attackerComposition[KitType.TORSO.getIndex()]));
        EquipmentData legs = EquipmentData.fromId(PvpPerformanceTrackerPlugin.fixItemId(attackerComposition[KitType.LEGS.getIndex()]));
        if (!(weapon != EquipmentData.BOW_OF_FAERDHINEN && weapon != EquipmentData.CRYSTAL_BOW && weapon != EquipmentData.CRYSTAL_BOW_I || head != EquipmentData.CRYSTAL_HELM && body != EquipmentData.CRYSTAL_BODY && legs != EquipmentData.CRYSTAL_LEGS)) {
            double accuracyModifier = 1.0 + (head == EquipmentData.CRYSTAL_HELM ? 0.05 : 0.0) + (body == EquipmentData.CRYSTAL_BODY ? 0.15 : 0.0) + (legs == EquipmentData.CRYSTAL_LEGS ? 0.1 : 0.0);
            effectiveLevelPlayer *= accuracyModifier;
        }
        double rangeModifier = Math.floor(effectiveLevelPlayer * ((double)playerRangeAtt + 64.0));
        if (usingSpec) {
            boolean ballista;
            boolean acb = weapon == EquipmentData.ARMADYL_CROSSBOW;
            boolean bl = ballista = weapon == EquipmentData.HEAVY_BALLISTA;
            double specAccuracyModifier = acb ? 2.0 : (ballista ? 1.25 : 1.0);
            attackerChance = Math.floor(rangeModifier * specAccuracyModifier);
        } else {
            attackerChance = rangeModifier;
        }
        double effectiveLevelTarget = Math.floor((double)this.defenderLevels.def * 1.25 + 0.0 + 8.0);
        double defenderChance = Math.floor(effectiveLevelTarget * ((double)opponentRangeDef + 64.0));
        this.accuracy = attackerChance > defenderChance ? 1.0 - (defenderChance + 2.0) / (2.0 * (attackerChance + 1.0)) : attackerChance / (2.0 * (defenderChance + 1.0));
        this.accuracy = diamonds || opals ? this.accuracy * 0.95 + 0.05 : this.accuracy;
    }

    private void getMagicAccuracy(int playerMageAtt, int opponentMageDef, EquipmentData weapon, AnimationData animationData, EquipmentData.VoidStyle voidStyle, boolean successfulOffensive, boolean defensiveAugurySuccess) {
        boolean volatileStaff;
        double magicModifier;
        double effectiveLevelPlayer = Math.floor((double)this.attackerLevels.mage * (successfulOffensive ? 1.25 : 1.0) + 8.0);
        if (voidStyle == EquipmentData.VoidStyle.VOID_ELITE_MAGE || voidStyle == EquipmentData.VoidStyle.VOID_MAGE) {
            effectiveLevelPlayer *= voidStyle.accuracyModifier;
        }
        double attackerChance = magicModifier = Math.floor(effectiveLevelPlayer * ((double)playerMageAtt + 64.0));
        double effectiveLevelTarget = Math.floor((double)this.defenderLevels.def * 1.25 + 0.0 + 8.0);
        double effectiveMagicLevelTarget = Math.floor((double)this.defenderLevels.mage * (defensiveAugurySuccess ? 1.25 : 1.0) * 0.7);
        double reducedDefenceLevelTarget = Math.floor(effectiveLevelTarget * 0.3);
        double effectiveMagicDefenceTarget = effectiveMagicLevelTarget + reducedDefenceLevelTarget;
        double defenderChance = this.ringUsed == RingData.BRIMSTONE_RING ? Math.floor(effectiveMagicDefenceTarget * (0.975 * (double)opponentMageDef + 64.0)) : Math.floor(effectiveMagicDefenceTarget * ((double)opponentMageDef + 64.0));
        this.accuracy = attackerChance > defenderChance ? 1.0 - (defenderChance + 2.0) / (2.0 * (attackerChance + 1.0)) : attackerChance / (2.0 * (defenderChance + 1.0));
        boolean smokeBstaff = weapon == EquipmentData.SMOKE_BATTLESTAFF;
        boolean bl = volatileStaff = weapon == EquipmentData.VOLATILE_NIGHTMARE_STAFF;
        if (smokeBstaff && AnimationData.isStandardSpellbookSpell(animationData)) {
            this.accuracy *= 1.1;
        } else if (volatileStaff && animationData == AnimationData.MAGIC_VOLATILE_NIGHTMARE_STAFF_SPEC) {
            this.accuracy *= 0.5;
        }
    }

    public static int[] getItemStats(int itemId) {
        EquipmentData itemData;
        ItemStats itemStats = PvpPerformanceTrackerPlugin.PLUGIN.getItemManager().getItemStats(itemId, false);
        if (itemStats == null && (itemData = EquipmentData.fromId(itemId)) != null) {
            itemId = itemData.getItemId();
            itemStats = PvpPerformanceTrackerPlugin.PLUGIN.getItemManager().getItemStats(itemId, false);
        }
        if (itemStats != null) {
            ItemEquipmentStats equipmentStats = itemStats.getEquipment();
            return new int[]{equipmentStats.getAstab(), equipmentStats.getAslash(), equipmentStats.getAcrush(), equipmentStats.getAmagic(), equipmentStats.getArange(), equipmentStats.getDstab(), equipmentStats.getDslash(), equipmentStats.getDcrush(), equipmentStats.getDmagic(), equipmentStats.getDrange(), equipmentStats.getStr(), equipmentStats.getRstr(), equipmentStats.getMdmg()};
        }
        return null;
    }

    private int[] calculateBonusesWithRing(int[] itemIds) {
        return PvpDamageCalc.calculateBonuses(itemIds, this.ringUsed);
    }

    public static int[] calculateBonuses(int[] itemIds) {
        return PvpDamageCalc.calculateBonuses(itemIds, PvpPerformanceTrackerPlugin.CONFIG.ringChoice());
    }

    public static int[] calculateBonuses(int[] itemIds, RingData ringUsed) {
        int[] equipmentBonuses;
        int[] nArray;
        if (ringUsed == null || ringUsed == RingData.NONE) {
            int[] nArray2 = new int[13];
            nArray2[0] = 0;
            nArray2[1] = 0;
            nArray2[2] = 0;
            nArray2[3] = 0;
            nArray2[4] = 0;
            nArray2[5] = 0;
            nArray2[6] = 0;
            nArray2[7] = 0;
            nArray2[8] = 0;
            nArray2[9] = 0;
            nArray2[10] = 0;
            nArray2[11] = 0;
            nArray = nArray2;
            nArray2[12] = 0;
        } else {
            nArray = equipmentBonuses = PvpDamageCalc.getItemStats(ringUsed.getItemId());
        }
        if (equipmentBonuses == null) {
            equipmentBonuses = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }
        for (int item : itemIds) {
            int[] bonuses;
            if (item <= 512 || (bonuses = PvpDamageCalc.getItemStats(item - 512)) == null) continue;
            for (int id = 0; id < bonuses.length; ++id) {
                int n = id;
                equipmentBonuses[n] = equipmentBonuses[n] + bonuses[id];
            }
        }
        return equipmentBonuses;
    }

    public static ItemEquipmentStats calculateBonusesToStats(int[] itemIds) {
        int[] bonuses = PvpDamageCalc.calculateBonuses(itemIds);
        return ItemEquipmentStats.builder().astab(bonuses[0]).aslash(bonuses[1]).acrush(bonuses[2]).amagic(bonuses[3]).arange(bonuses[4]).dstab(bonuses[5]).dslash(bonuses[6]).dcrush(bonuses[7]).dmagic(bonuses[8]).drange(bonuses[9]).str(bonuses[10]).rstr(bonuses[11]).mdmg(bonuses[12]).build();
    }

    public double getAverageHit() {
        return this.averageHit;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public int getMinHit() {
        return this.minHit;
    }

    public int getMaxHit() {
        return this.maxHit;
    }
}

