/*
 * Decompiled with CFR 0.152.
 */
package matsyir.pvpperformancetracker.controllers;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.ArrayList;
import matsyir.pvpperformancetracker.PvpPerformanceTrackerPlugin;
import matsyir.pvpperformancetracker.controllers.FightPerformance;
import matsyir.pvpperformancetracker.controllers.PvpDamageCalc;
import matsyir.pvpperformancetracker.models.AnimationData;
import matsyir.pvpperformancetracker.models.CombatLevels;
import matsyir.pvpperformancetracker.models.EquipmentData;
import matsyir.pvpperformancetracker.models.FightLogEntry;
import net.runelite.api.Player;
import net.runelite.api.kit.KitType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fighter {
    private static final Logger log = LoggerFactory.getLogger(Fighter.class);
    private static final NumberFormat nf = NumberFormat.getInstance();
    private Player player;
    @Expose
    @SerializedName(value="n")
    private String name;
    @Expose
    @SerializedName(value="a")
    private int attackCount;
    @Expose
    @SerializedName(value="s")
    private int offPraySuccessCount;
    @Expose
    @SerializedName(value="d")
    private double deservedDamage;
    @Expose
    @SerializedName(value="h")
    private int damageDealt;
    @Expose
    @SerializedName(value="z")
    private int totalMagicAttackCount;
    @Expose
    @SerializedName(value="m")
    private int magicHitCount;
    @Expose
    @SerializedName(value="M")
    private double magicHitCountDeserved;
    @Expose
    @SerializedName(value="p")
    private int offensivePraySuccessCount;
    @Expose
    @SerializedName(value="g")
    private int ghostBarrageCount;
    @Expose
    @SerializedName(value="y")
    private double ghostBarrageDeservedDamage;
    @Expose
    @SerializedName(value="H")
    private int hpHealed;
    @Expose
    @SerializedName(value="x")
    private boolean dead;
    @Expose
    @SerializedName(value="l")
    private ArrayList<FightLogEntry> fightLogEntries;
    private PvpDamageCalc pvpDamageCalc;
    private int lastGhostBarrageCheckedTick = -1;
    private int lastGhostBarrageCheckedMageXp = -1;

    Fighter(FightPerformance fight, Player player) {
        this.player = player;
        this.name = player.getName();
        this.attackCount = 0;
        this.offPraySuccessCount = 0;
        this.deservedDamage = 0.0;
        this.damageDealt = 0;
        this.totalMagicAttackCount = 0;
        this.magicHitCount = 0;
        this.magicHitCountDeserved = 0.0;
        this.offensivePraySuccessCount = 0;
        this.dead = false;
        this.pvpDamageCalc = new PvpDamageCalc(fight);
        this.fightLogEntries = new ArrayList();
    }

    Fighter(FightPerformance fight, String name, ArrayList<FightLogEntry> logs) {
        this.player = null;
        this.name = name;
        this.attackCount = 0;
        this.offPraySuccessCount = 0;
        this.deservedDamage = 0.0;
        this.damageDealt = 0;
        this.totalMagicAttackCount = 0;
        this.magicHitCount = 0;
        this.magicHitCountDeserved = 0.0;
        this.dead = false;
        this.pvpDamageCalc = new PvpDamageCalc(fight);
        this.fightLogEntries = logs;
    }

    public Fighter(String name) {
        this.player = null;
        this.name = name;
        this.attackCount = 0;
        this.offPraySuccessCount = 0;
        this.deservedDamage = 0.0;
        this.damageDealt = 0;
        this.totalMagicAttackCount = 0;
        this.magicHitCount = 0;
        this.magicHitCountDeserved = 0.0;
        this.dead = false;
        this.pvpDamageCalc = null;
        this.fightLogEntries = new ArrayList();
    }

    public Fighter(FightPerformance fight, String name) {
        this(name);
        this.pvpDamageCalc = new PvpDamageCalc(fight);
    }

    void addAttack(Player opponent, AnimationData animationData, int offensivePray) {
        this.addAttack(opponent, animationData, offensivePray, null);
    }

    void addAttack(Player opponent, AnimationData animationData, int offensivePray, CombatLevels levels) {
        int[] attackerItems = this.player.getPlayerComposition().getEquipmentIds();
        EquipmentData weapon = EquipmentData.fromId(PvpPerformanceTrackerPlugin.fixItemId(attackerItems[KitType.WEAPON.getIndex()]));
        if (weapon == EquipmentData.VOIDWAKER && animationData == AnimationData.MELEE_DRAGON_WARHAMMER_SPEC) {
            animationData = AnimationData.MELEE_VOIDWAKER_SPEC;
        }
        boolean successful = opponent.getOverheadIcon() != animationData.attackStyle.getProtection();
        ++this.attackCount;
        if (successful) {
            ++this.offPraySuccessCount;
        }
        if (animationData.attackStyle.isUsingSuccessfulOffensivePray(offensivePray)) {
            ++this.offensivePraySuccessCount;
        }
        if (PvpPerformanceTrackerPlugin.CONFIG.dlongIsVls() && weapon == EquipmentData.DRAGON_LONGSWORD || weapon == EquipmentData.VESTAS_LONGSWORD) {
            attackerItems[KitType.WEAPON.getIndex()] = EquipmentData.VESTAS_LONGSWORD.getItemId() + 512;
            animationData = animationData.isSpecial ? AnimationData.MELEE_VLS_SPEC : AnimationData.MELEE_SCIM_SLASH;
        }
        this.pvpDamageCalc.updateDamageStats(this.player, opponent, successful, animationData);
        this.deservedDamage += this.pvpDamageCalc.getAverageHit();
        if (animationData.attackStyle == AnimationData.AttackStyle.MAGIC) {
            ++this.totalMagicAttackCount;
            this.magicHitCountDeserved += this.pvpDamageCalc.getAccuracy();
            if (opponent.getGraphic() != 85) {
                ++this.magicHitCount;
            }
        }
        FightLogEntry fightLogEntry = new FightLogEntry(this.player, opponent, this.pvpDamageCalc, offensivePray, levels, animationData);
        if (PvpPerformanceTrackerPlugin.CONFIG.fightLogInChat()) {
            PvpPerformanceTrackerPlugin.PLUGIN.sendChatMessage(fightLogEntry.toChatMessage());
        }
        this.fightLogEntries.add(fightLogEntry);
    }

    void addAttack(FightLogEntry logEntry, FightLogEntry defenderLog) {
        ++this.attackCount;
        if (logEntry.success()) {
            ++this.offPraySuccessCount;
        }
        if (logEntry.getAnimationData().attackStyle.isUsingSuccessfulOffensivePray(logEntry.getAttackerOffensivePray())) {
            ++this.offensivePraySuccessCount;
        }
        this.pvpDamageCalc.updateDamageStats(logEntry, defenderLog);
        this.deservedDamage += this.pvpDamageCalc.getAverageHit();
        if (logEntry.getAnimationData().attackStyle == AnimationData.AttackStyle.MAGIC) {
            ++this.totalMagicAttackCount;
            this.magicHitCountDeserved += this.pvpDamageCalc.getAccuracy();
        }
        this.fightLogEntries.add(new FightLogEntry(logEntry, this.pvpDamageCalc));
    }

    public void addGhostBarrage(boolean successful, Player opponent, AnimationData animationData, int offensivePray, CombatLevels levels) {
        int currentTick = PvpPerformanceTrackerPlugin.PLUGIN.getClient().getTickCount();
        if (currentTick <= this.lastGhostBarrageCheckedTick) {
            return;
        }
        this.lastGhostBarrageCheckedTick = currentTick;
        this.pvpDamageCalc.updateDamageStats(this.player, opponent, successful, animationData);
        ++this.ghostBarrageCount;
        this.ghostBarrageDeservedDamage += this.pvpDamageCalc.getAverageHit();
    }

    public void setTotalGhostBarrageStats(int ghostBarrageCount, double ghostBarrageDeservedDamage) {
        this.ghostBarrageCount = ghostBarrageCount;
        this.ghostBarrageDeservedDamage = ghostBarrageDeservedDamage;
    }

    public void addAttacks(int success, int total, double deservedDamage, int damageDealt, int totalMagicAttackCount, int magicHitCount, double magicHitCountDeserved, int offensivePraySuccessCount, int hpHealed, int ghostBarrageCount, double ghostBarrageDeservedDamage) {
        this.offPraySuccessCount += success;
        this.attackCount += total;
        this.deservedDamage += deservedDamage;
        this.damageDealt += damageDealt;
        this.totalMagicAttackCount += totalMagicAttackCount;
        this.magicHitCount += magicHitCount;
        this.magicHitCountDeserved += magicHitCountDeserved;
        this.offensivePraySuccessCount += offensivePraySuccessCount;
        this.hpHealed += hpHealed;
        this.ghostBarrageCount += ghostBarrageCount;
        this.ghostBarrageDeservedDamage += ghostBarrageDeservedDamage;
    }

    void addDamageDealt(int damage) {
        this.damageDealt += damage;
    }

    void addMagicHitCount(int count) {
        this.magicHitCount += count;
    }

    void addHpHealed(int hpHealed) {
        this.hpHealed += hpHealed;
    }

    void died() {
        this.dead = true;
    }

    AnimationData getAnimationData() {
        return AnimationData.fromId(this.player.getAnimation());
    }

    void addDefensiveLogs(CombatLevels levels, int offensivePray) {
        this.fightLogEntries.add(new FightLogEntry(this.name, levels, offensivePray));
    }

    public String getOffPrayStats(boolean shortString) {
        nf.setMaximumFractionDigits(0);
        return shortString ? this.offPraySuccessCount + "/" + this.attackCount : nf.format(this.offPraySuccessCount) + "/" + nf.format(this.attackCount) + " (" + Math.round(this.calculateOffPraySuccessPercentage()) + "%)";
    }

    public String getOffPrayStats() {
        return this.getOffPrayStats(false);
    }

    public String getMagicHitStats() {
        nf.setMaximumFractionDigits(0);
        Object stats = nf.format(this.magicHitCount);
        long magicAttackCount = this.getMagicAttackCount();
        stats = (String)stats + "/" + nf.format(magicAttackCount);
        nf.setMaximumFractionDigits(2);
        String luckPercentage = this.magicHitCountDeserved != 0.0 ? nf.format((double)this.magicHitCount / this.magicHitCountDeserved * 100.0) : "0";
        stats = (String)stats + " (" + luckPercentage + "%)";
        return stats;
    }

    public String getShortMagicHitStats() {
        nf.setMaximumFractionDigits(2);
        return this.magicHitCountDeserved != 0.0 ? nf.format((double)this.magicHitCount / this.magicHitCountDeserved * 100.0) + "%" : "0%";
    }

    public String getDeservedDmgString(Fighter opponent, int precision, boolean onlyDiff) {
        nf.setMaximumFractionDigits(precision);
        double difference = this.deservedDamage - opponent.deservedDamage;
        return onlyDiff ? (difference > 0.0 ? "+" : "") + nf.format(difference) : nf.format(this.deservedDamage) + " (" + (difference > 0.0 ? "+" : "") + nf.format(difference) + ")";
    }

    public String getDeservedDmgString(Fighter opponent) {
        return this.getDeservedDmgString(opponent, 0, false);
    }

    public String getDmgDealtString(Fighter opponent, boolean onlyDiff) {
        int difference = this.damageDealt - opponent.damageDealt;
        return onlyDiff ? (difference > 0 ? "+" : "") + difference : this.damageDealt + " (" + (difference > 0 ? "+" : "") + difference + ")";
    }

    public String getDmgDealtString(Fighter opponent) {
        return this.getDmgDealtString(opponent, false);
    }

    public double calculateOffPraySuccessPercentage() {
        return this.attackCount == 0 ? 0.0 : (double)this.offPraySuccessCount / (double)this.attackCount * 100.0;
    }

    public double calculateOffensivePraySuccessPercentage() {
        return this.attackCount == 0 ? 0.0 : (double)this.offensivePraySuccessCount / (double)this.attackCount * 100.0;
    }

    public int getMagicAttackCount() {
        return this.totalMagicAttackCount;
    }

    public String getOffensivePrayStats(boolean shortString) {
        nf.setMaximumFractionDigits(0);
        return shortString ? this.offensivePraySuccessCount + "/" + this.attackCount : nf.format(this.offensivePraySuccessCount) + "/" + nf.format(this.attackCount) + " (" + Math.round(this.calculateOffensivePraySuccessPercentage()) + "%)";
    }

    public String getOffensivePrayStats() {
        return this.getOffensivePrayStats(false);
    }

    public String getGhostBarrageStats() {
        return this.ghostBarrageCount + " G.B. (" + nf.format(this.ghostBarrageDeservedDamage) + ")";
    }

    public Player getPlayer() {
        return this.player;
    }

    public String getName() {
        return this.name;
    }

    public int getAttackCount() {
        return this.attackCount;
    }

    public int getOffPraySuccessCount() {
        return this.offPraySuccessCount;
    }

    public double getDeservedDamage() {
        return this.deservedDamage;
    }

    public int getDamageDealt() {
        return this.damageDealt;
    }

    public int getTotalMagicAttackCount() {
        return this.totalMagicAttackCount;
    }

    public int getMagicHitCount() {
        return this.magicHitCount;
    }

    public double getMagicHitCountDeserved() {
        return this.magicHitCountDeserved;
    }

    public int getOffensivePraySuccessCount() {
        return this.offensivePraySuccessCount;
    }

    public int getGhostBarrageCount() {
        return this.ghostBarrageCount;
    }

    public double getGhostBarrageDeservedDamage() {
        return this.ghostBarrageDeservedDamage;
    }

    public int getHpHealed() {
        return this.hpHealed;
    }

    public boolean isDead() {
        return this.dead;
    }

    public ArrayList<FightLogEntry> getFightLogEntries() {
        return this.fightLogEntries;
    }

    public PvpDamageCalc getPvpDamageCalc() {
        return this.pvpDamageCalc;
    }

    public int getLastGhostBarrageCheckedTick() {
        return this.lastGhostBarrageCheckedTick;
    }

    public int getLastGhostBarrageCheckedMageXp() {
        return this.lastGhostBarrageCheckedMageXp;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public void setLastGhostBarrageCheckedMageXp(int lastGhostBarrageCheckedMageXp) {
        this.lastGhostBarrageCheckedMageXp = lastGhostBarrageCheckedMageXp;
    }

    static {
        nf.setMaximumFractionDigits(1);
        nf.setRoundingMode(RoundingMode.HALF_UP);
    }
}

