/*
 * Decompiled with CFR 0.152.
 */
package matsyir.pvpperformancetracker.controllers;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import matsyir.pvpperformancetracker.PvpPerformanceTrackerPlugin;
import matsyir.pvpperformancetracker.controllers.Fighter;
import matsyir.pvpperformancetracker.models.AnimationData;
import matsyir.pvpperformancetracker.models.CombatLevels;
import matsyir.pvpperformancetracker.models.FightLogEntry;
import matsyir.pvpperformancetracker.models.FightType;
import matsyir.pvpperformancetracker.models.oldVersions.FightPerformance__1_5_5;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FightPerformance
implements Comparable<FightPerformance> {
    private static final Logger log = LoggerFactory.getLogger(FightPerformance.class);
    private static final Duration NEW_FIGHT_DELAY = Duration.ofSeconds(21L);
    private static final NumberFormat nf = NumberFormat.getInstance();
    @Expose
    @SerializedName(value="c")
    public Fighter competitor;
    @Expose
    @SerializedName(value="o")
    public Fighter opponent;
    @Expose
    @SerializedName(value="t")
    public long lastFightTime;
    @Expose
    @SerializedName(value="l")
    public FightType fightType;
    private int competitorPrevHp;

    public FightPerformance() {
    }

    public FightPerformance(Player competitor, Player opponent) {
        int defLvl = PvpPerformanceTrackerPlugin.PLUGIN.getClient().getBoostedSkillLevel(Skill.DEFENCE);
        this.fightType = !PvpPerformanceTrackerPlugin.PLUGIN.isAtLMS() ? FightType.NORMAL : (defLvl <= FightType.LMS_1DEF.getCombatLevelsForType().def ? FightType.LMS_1DEF : (defLvl <= FightType.LMS_ZERK.getCombatLevelsForType().def ? FightType.LMS_ZERK : FightType.LMS_MAXMED));
        this.lastFightTime = Instant.now().minusSeconds(NEW_FIGHT_DELAY.getSeconds() - 5L).toEpochMilli();
        this.competitor = new Fighter(this, competitor);
        this.opponent = new Fighter(this, opponent);
        this.competitorPrevHp = PvpPerformanceTrackerPlugin.PLUGIN.getClient().getBoostedSkillLevel(Skill.HITPOINTS);
        this.competitor.setLastGhostBarrageCheckedMageXp(PvpPerformanceTrackerPlugin.PLUGIN.getClient().getSkillExperience(Skill.MAGIC));
    }

    public FightPerformance(FightPerformance__1_5_5 old) {
        int defLvl;
        this.competitor = old.competitor;
        this.opponent = old.opponent;
        this.lastFightTime = old.lastFightTime;
        this.fightType = old.isLmsFight ? (this.competitor.getFightLogEntries().size() > 0 ? ((defLvl = this.competitor.getFightLogEntries().get((int)0).getAttackerLevels().def) <= FightType.LMS_1DEF.getCombatLevelsForType().def ? FightType.LMS_1DEF : (defLvl <= FightType.LMS_ZERK.getCombatLevelsForType().def ? FightType.LMS_ZERK : FightType.LMS_MAXMED)) : FightType.LMS_MAXMED) : FightType.NORMAL;
    }

    static FightPerformance getTestInstance() {
        int cTotal = (int)(Math.random() * 60.0) + 8;
        int cSuccess = (int)(Math.random() * (double)(cTotal - 4)) + 4;
        double cDamage = Math.random() * (double)(cSuccess * 25);
        int oTotal = (int)(Math.random() * 60.0) + 8;
        int oSuccess = (int)(Math.random() * (double)(oTotal - 4)) + 4;
        double oDamage = Math.random() * (double)(oSuccess * 25);
        int secOffset = (int)(Math.random() * 57600.0) - 28800;
        boolean cDead = Math.random() >= 0.5;
        ArrayList<FightLogEntry> fightLogEntries = new ArrayList<FightLogEntry>();
        int[] attackerItems = new int[]{0, 0, 0};
        int[] defenderItems = new int[]{0, 0, 0};
        String attackerName = "testname";
        FightLogEntry fightLogEntry = new FightLogEntry(attackerItems, 21, 0.5, 1, 12, defenderItems, attackerName);
        FightLogEntry fightLogEntry2 = new FightLogEntry(attackerItems, 11, 0.2, 1, 41, defenderItems, attackerName);
        FightLogEntry fightLogEntry3 = new FightLogEntry(attackerItems, 12, 0.3, 1, 21, defenderItems, attackerName);
        FightLogEntry fightLogEntry4 = new FightLogEntry(attackerItems, 43, 0.1, 1, 23, defenderItems, attackerName);
        fightLogEntries.add(fightLogEntry);
        fightLogEntries.add(fightLogEntry2);
        fightLogEntries.add(fightLogEntry3);
        fightLogEntries.add(fightLogEntry4);
        return new FightPerformance("Matsyir", "TEST_DATA", cSuccess, cTotal, cDamage, oSuccess, oTotal, oDamage, cDead, secOffset, fightLogEntries);
    }

    private FightPerformance(String cName, String oName, int cSuccess, int cTotal, double cDamage, int oSuccess, int oTotal, double oDamage, boolean cDead, int secondOffset, ArrayList<FightLogEntry> fightLogs) {
        this.competitor = new Fighter(this, cName, fightLogs);
        this.opponent = new Fighter(this, oName, fightLogs);
        this.competitor.addAttacks(cSuccess, cTotal, cDamage, (int)cDamage, 20, 12, 13.0, 11, 22, 25, 26.0);
        this.opponent.addAttacks(oSuccess, oTotal, oDamage, (int)oDamage, 20, 14, 13.0, 11, 22, 25, 26.0);
        if (cDead) {
            this.competitor.died();
        } else {
            this.opponent.died();
        }
        this.lastFightTime = Instant.now().minusSeconds(secondOffset).toEpochMilli();
    }

    public void checkForAttackAnimations(Player eventSource, CombatLevels competitorLevels) {
        if (eventSource == null || eventSource.getName() == null || eventSource.getInteracting() == null || eventSource.getInteracting().getName() == null) {
            return;
        }
        String eName = eventSource.getName();
        String interactingName = eventSource.getInteracting().getName();
        if (eName.equals(this.competitor.getName()) && Objects.equals(interactingName, this.opponent.getName())) {
            this.competitor.setPlayer(eventSource);
            AnimationData animationData = this.competitor.getAnimationData();
            if (animationData != null) {
                int offensivePray = PvpPerformanceTrackerPlugin.PLUGIN.currentlyUsedOffensivePray();
                this.competitor.addAttack(this.opponent.getPlayer(), animationData, offensivePray, competitorLevels);
                this.lastFightTime = Instant.now().toEpochMilli();
            }
        } else if (eName.equals(this.opponent.getName()) && Objects.equals(interactingName, this.competitor.getName())) {
            this.opponent.setPlayer(eventSource);
            AnimationData animationData = this.opponent.getAnimationData();
            if (animationData != null) {
                this.opponent.addAttack(this.competitor.getPlayer(), animationData, 0);
                this.competitor.addDefensiveLogs(competitorLevels, PvpPerformanceTrackerPlugin.PLUGIN.currentlyUsedOffensivePray());
                this.lastFightTime = Instant.now().toEpochMilli();
            }
        }
    }

    public void checkForLocalGhostBarrage(CombatLevels competitorLevels, Player localPlayer) {
        AnimationData animationData;
        if (localPlayer == null) {
            log.info("Client player null while checking for ghost barrage - shouldn't happen");
            return;
        }
        this.competitor.setPlayer(localPlayer);
        if (localPlayer.getInteracting() instanceof Player && localPlayer.getInteracting().getName().equals(this.opponent.getName())) {
            this.opponent.setPlayer((Player)localPlayer.getInteracting());
        }
        if ((animationData = this.competitor.getAnimationData()) == null || animationData.attackStyle != AnimationData.AttackStyle.MAGIC) {
            animationData = AnimationData.MAGIC_ANCIENT_MULTI_TARGET;
            int offensivePray = PvpPerformanceTrackerPlugin.PLUGIN.currentlyUsedOffensivePray();
            this.competitor.addGhostBarrage(this.opponent.getPlayer().getOverheadIcon() != animationData.attackStyle.getProtection(), this.opponent.getPlayer(), AnimationData.MAGIC_ANCIENT_MULTI_TARGET, offensivePray, competitorLevels);
        }
    }

    public void addDamageDealt(String playerName, int damage) {
        if (playerName == null) {
            return;
        }
        if (playerName.equals(this.competitor.getName())) {
            this.opponent.addDamageDealt(damage);
        } else if (playerName.equals(this.opponent.getName())) {
            this.competitor.addDamageDealt(damage);
        }
    }

    public void updateCompetitorHp(int currentHp) {
        if (currentHp > this.competitorPrevHp) {
            int hpHealed = currentHp - this.competitorPrevHp;
            this.competitor.addHpHealed(hpHealed);
        }
        this.competitorPrevHp = currentHp;
    }

    public boolean isFightOver() {
        boolean isOver = false;
        if (this.opponent.getPlayer().getAnimation() == 836) {
            this.opponent.died();
            isOver = true;
        }
        if (this.competitor.getPlayer().getAnimation() == 836) {
            this.competitor.died();
            isOver = true;
        }
        if (Duration.between(Instant.ofEpochMilli(this.lastFightTime), Instant.now()).compareTo(NEW_FIGHT_DELAY) > 0) {
            isOver = true;
        }
        if (isOver) {
            this.lastFightTime = Instant.now().toEpochMilli();
        }
        return isOver;
    }

    public ArrayList<FightLogEntry> getAllFightLogEntries() {
        if (this.competitor.getFightLogEntries() == null || this.opponent.getFightLogEntries() == null) {
            return new ArrayList<FightLogEntry>();
        }
        ArrayList<FightLogEntry> combinedList = new ArrayList<FightLogEntry>();
        combinedList.addAll(this.competitor.getFightLogEntries());
        combinedList.addAll(this.opponent.getFightLogEntries());
        combinedList.sort(FightLogEntry::compareTo);
        return combinedList;
    }

    public boolean fightStarted() {
        return this.competitor.getAttackCount() > 0;
    }

    public boolean competitorOffPraySuccessIsGreater() {
        return this.competitor.calculateOffPraySuccessPercentage() > this.opponent.calculateOffPraySuccessPercentage();
    }

    public boolean opponentOffPraySuccessIsGreater() {
        return this.opponent.calculateOffPraySuccessPercentage() > this.competitor.calculateOffPraySuccessPercentage();
    }

    public boolean competitorDeservedDmgIsGreater() {
        return this.competitor.getDeservedDamage() > this.opponent.getDeservedDamage();
    }

    public boolean opponentDeservedDmgIsGreater() {
        return this.opponent.getDeservedDamage() > this.competitor.getDeservedDamage();
    }

    public boolean competitorDmgDealtIsGreater() {
        return this.competitor.getDamageDealt() > this.opponent.getDamageDealt();
    }

    public boolean opponentDmgDealtIsGreater() {
        return this.opponent.getDamageDealt() > this.competitor.getDamageDealt();
    }

    public boolean competitorMagicHitsLuckier() {
        double competitorRate = this.competitor.getMagicHitCountDeserved() == 0.0 ? 0.0 : (double)this.competitor.getMagicHitCount() / this.competitor.getMagicHitCountDeserved();
        double opponentRate = this.opponent.getMagicHitCountDeserved() == 0.0 ? 0.0 : (double)this.opponent.getMagicHitCount() / this.opponent.getMagicHitCountDeserved();
        return competitorRate > opponentRate;
    }

    public boolean opponentMagicHitsLuckier() {
        double competitorRate = this.competitor.getMagicHitCountDeserved() == 0.0 ? 0.0 : (double)this.competitor.getMagicHitCount() / this.competitor.getMagicHitCountDeserved();
        double opponentRate = this.opponent.getMagicHitCountDeserved() == 0.0 ? 0.0 : (double)this.opponent.getMagicHitCount() / this.opponent.getMagicHitCountDeserved();
        return opponentRate > competitorRate;
    }

    public double getCompetitorDeservedDmgDiff() {
        return this.competitor.getDeservedDamage() - this.opponent.getDeservedDamage();
    }

    public double getCompetitorDmgDealtDiff() {
        return this.competitor.getDamageDealt() - this.opponent.getDamageDealt();
    }

    public String getAsDiscordMessage() {
        Object msg = "```bash\n";
        int minLineLength = 36;
        int lineLength = Math.max(36, this.competitor.getName().length() + this.opponent.getName().length() + 8);
        String competitorName = this.competitor.getName() + (this.competitor.isDead() ? "(died)" : "");
        String opponentName = this.opponent.getName() + (this.opponent.isDead() ? "(died)" : "");
        msg = (String)msg + StringUtils.rightPad((String)competitorName, (int)(lineLength - opponentName.length()), (char)' ') + opponentName + "\n";
        String offPrayLeft = this.competitor.getOffPrayStats();
        offPrayLeft = this.surroundStrIfTrue(offPrayLeft, this.competitorOffPraySuccessIsGreater());
        String offPrayRight = this.opponent.getOffPrayStats();
        offPrayRight = this.surroundStrIfTrue(offPrayRight, this.opponentOffPraySuccessIsGreater());
        msg = (String)msg + StringUtils.rightPad((String)offPrayLeft, (int)(lineLength - offPrayRight.length()), (char)' ') + offPrayRight + "\n";
        String deservedDmgLeft = this.competitor.getDeservedDmgString(this.opponent);
        deservedDmgLeft = this.surroundStrIfTrue(deservedDmgLeft, this.competitorDeservedDmgIsGreater());
        String deservedDmgRight = this.opponent.getDeservedDmgString(this.competitor);
        deservedDmgRight = this.surroundStrIfTrue(deservedDmgRight, this.opponentDeservedDmgIsGreater());
        msg = (String)msg + StringUtils.rightPad((String)deservedDmgLeft, (int)(lineLength - deservedDmgRight.length()), (char)' ') + deservedDmgRight + "\n";
        String dmgDealtLeft = this.competitor.getDmgDealtString(this.opponent);
        dmgDealtLeft = this.surroundStrIfTrue(dmgDealtLeft, this.competitorDmgDealtIsGreater());
        String dmgDealtRight = this.opponent.getDmgDealtString(this.competitor);
        dmgDealtRight = this.surroundStrIfTrue(dmgDealtRight, this.opponentDmgDealtIsGreater());
        msg = (String)msg + StringUtils.rightPad((String)dmgDealtLeft, (int)(lineLength - dmgDealtRight.length()), (char)' ') + dmgDealtRight + "\n";
        String magicHitStatsLeft = this.competitor.getMagicHitStats();
        magicHitStatsLeft = this.surroundStrIfTrue(magicHitStatsLeft, this.competitorMagicHitsLuckier());
        String magicHitStatsRight = this.opponent.getMagicHitStats();
        magicHitStatsRight = this.surroundStrIfTrue(magicHitStatsRight, this.opponentMagicHitsLuckier());
        msg = (String)msg + StringUtils.rightPad((String)magicHitStatsLeft, (int)(lineLength - magicHitStatsRight.length()), (char)' ') + magicHitStatsRight + "\n";
        String offensivePrayLeft = this.surroundStrIfTrue(this.competitor.getOffensivePrayStats(), false);
        String offensivePrayRight = "N/A ";
        msg = (String)msg + StringUtils.rightPad((String)offensivePrayLeft, (int)(lineLength - offensivePrayRight.length()), (char)' ') + offensivePrayRight + "\n";
        String hpHealedLeft = this.surroundStrIfTrue(String.valueOf(this.competitor.getHpHealed()), false);
        String hpHealedRight = "N/A ";
        msg = (String)msg + StringUtils.rightPad((String)hpHealedLeft, (int)(lineLength - hpHealedRight.length()), (char)' ') + hpHealedRight + "\n";
        msg = (String)msg + "Ended at " + new SimpleDateFormat("HH:mm:ss 'on' yyyy/MM/dd").format(Date.from(Instant.ofEpochMilli(this.lastFightTime))) + "\n";
        return (String)msg + "```";
    }

    private String surroundStrIfTrue(String strToSurround, boolean boolToCompare) {
        return this.surroundStrIfTrue(strToSurround, boolToCompare, "'", " ");
    }

    private String surroundStrIfTrue(String strToSurround, boolean boolToCompare, String trueSurround, String falseSurround) {
        return boolToCompare ? trueSurround + strToSurround + trueSurround : falseSurround + strToSurround + falseSurround;
    }

    @Override
    public int compareTo(FightPerformance o) {
        long diff = this.lastFightTime - o.lastFightTime;
        return diff == 0L ? 0 : (int)(diff / Math.abs(diff));
    }

    public Fighter getCompetitor() {
        return this.competitor;
    }

    public Fighter getOpponent() {
        return this.opponent;
    }

    public long getLastFightTime() {
        return this.lastFightTime;
    }

    public FightType getFightType() {
        return this.fightType;
    }

    public int getCompetitorPrevHp() {
        return this.competitorPrevHp;
    }

    static {
        nf.setMaximumFractionDigits(1);
        nf.setRoundingMode(RoundingMode.HALF_UP);
    }
}

