/*
 * Decompiled with CFR 0.152.
 */
package matsyir.pvpperformancetracker.controllers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import matsyir.pvpperformancetracker.PvpPerformanceTrackerPlugin;
import matsyir.pvpperformancetracker.controllers.FightPerformance;
import matsyir.pvpperformancetracker.controllers.Fighter;
import matsyir.pvpperformancetracker.models.FightLogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzedFightPerformance
extends FightPerformance {
    private static final Logger log = LoggerFactory.getLogger(AnalyzedFightPerformance.class);
    ArrayList<FightLogEntry[]> analyzedMatchingLogs;
    FightPerformance mainFight;
    FightPerformance opposingFight;

    public AnalyzedFightPerformance(FightPerformance mainFight, FightPerformance opposingFight, Runnable swingCallback) throws Exception {
        this.mainFight = mainFight;
        this.opposingFight = opposingFight;
        String cName = mainFight.competitor.getName();
        String oName = mainFight.opponent.getName();
        this.competitor = new Fighter(mainFight, cName);
        this.opponent = new Fighter(mainFight, oName);
        if (mainFight.competitor.isDead()) {
            this.competitor.died();
        }
        if (mainFight.opponent.isDead()) {
            this.opponent.died();
        }
        this.lastFightTime = Math.max(mainFight.lastFightTime, opposingFight.lastFightTime);
        this.competitor.addDamageDealt(Math.max(mainFight.competitor.getDamageDealt(), opposingFight.opponent.getDamageDealt()));
        this.competitor.addMagicHitCount(Math.max(mainFight.competitor.getMagicHitCount(), opposingFight.opponent.getMagicHitCount()));
        this.competitor.addHpHealed(mainFight.competitor.getHpHealed());
        this.competitor.setTotalGhostBarrageStats(mainFight.competitor.getGhostBarrageCount(), mainFight.getCompetitor().getGhostBarrageDeservedDamage());
        this.opponent.addDamageDealt(Math.max(opposingFight.competitor.getDamageDealt(), mainFight.opponent.getDamageDealt()));
        this.opponent.addMagicHitCount(Math.max(opposingFight.competitor.getMagicHitCount(), mainFight.opponent.getMagicHitCount()));
        this.opponent.addHpHealed(opposingFight.competitor.getHpHealed());
        this.opponent.setTotalGhostBarrageStats(opposingFight.competitor.getGhostBarrageCount(), opposingFight.getCompetitor().getGhostBarrageDeservedDamage());
        ArrayList<FightLogEntry> mainFightLogEntries = mainFight.getAllFightLogEntries();
        mainFightLogEntries.sort(FightLogEntry::compareTo);
        ArrayList<FightLogEntry> opponentFightLogEntries = opposingFight.getAllFightLogEntries();
        opponentFightLogEntries.sort(FightLogEntry::compareTo);
        ArrayList fullMainFightLogEntries = mainFightLogEntries.stream().filter(FightLogEntry::isFullEntry).sorted().collect(Collectors.toCollection(ArrayList::new));
        ArrayList fullOpponentFightLogEntries = opponentFightLogEntries.stream().filter(FightLogEntry::isFullEntry).sorted().collect(Collectors.toCollection(ArrayList::new));
        int offsetsToCheck = 2;
        int attacksToCheck = 12;
        ArrayList<ArrayList> matchingLogs = new ArrayList<ArrayList>();
        for (int mainOffset = 0; mainOffset < offsetsToCheck; ++mainOffset) {
            for (int oppOffset = 0; oppOffset < offsetsToCheck; ++oppOffset) {
                ArrayList<FightLogEntry[]> currentOffsetMatches = new ArrayList<FightLogEntry[]>();
                int highestMatchIdx = -1;
                for (int i = mainOffset; i < fullMainFightLogEntries.size() && i < attacksToCheck; ++i) {
                    FightLogEntry entry = (FightLogEntry)fullMainFightLogEntries.get(i);
                    int skip = highestMatchIdx < 0 ? oppOffset : highestMatchIdx + 1;
                    FightLogEntry matchingOppLog = fullOpponentFightLogEntries.stream().skip(skip).limit(attacksToCheck - skip).filter(oppEntry -> entry.attackerName.equals(oppEntry.attackerName) && entry.getAnimationData() == oppEntry.getAnimationData() && Arrays.equals(entry.getAttackerGear(), oppEntry.getAttackerGear()) && Arrays.equals(entry.getDefenderGear(), oppEntry.getDefenderGear()) && entry.getAttackerOverhead() == oppEntry.getAttackerOverhead() && entry.getDefenderOverhead() == oppEntry.getDefenderOverhead() && entry.success() == oppEntry.success() && entry.isSplash() == oppEntry.isSplash()).findFirst().orElse(null);
                    if (matchingOppLog == null) continue;
                    int logEntryIdx = fullOpponentFightLogEntries.indexOf(matchingOppLog);
                    if (logEntryIdx <= highestMatchIdx) {
                        throw new Exception("Invalid state during fight merge: logEntryIdx was under highestMatchIdx");
                    }
                    highestMatchIdx = logEntryIdx;
                    currentOffsetMatches.add(new FightLogEntry[]{entry, matchingOppLog});
                }
                if (currentOffsetMatches.size() < 2) continue;
                matchingLogs.add(currentOffsetMatches);
            }
        }
        if (matchingLogs.size() < 1) {
            throw new Exception("Unable to match initial attacks for fight analysis.");
        }
        matchingLogs.sort(Comparator.comparing(ArrayList::size).reversed());
        int bestTickDiff = 0;
        boolean foundValidTickDiff = false;
        for (ArrayList logMatches : matchingLogs) {
            int tickDiff = 0;
            boolean tickDiffValid = true;
            for (int i = 0; i < logMatches.size(); ++i) {
                FightLogEntry[] match = (FightLogEntry[])logMatches.get(i);
                int curTickDiff = match[0].getTick() - match[1].getTick();
                if (i == 0) {
                    tickDiff = curTickDiff;
                    continue;
                }
                if (curTickDiff == tickDiff) continue;
                tickDiffValid = false;
                break;
            }
            if (!tickDiffValid) continue;
            bestTickDiff = tickDiff;
            foundValidTickDiff = true;
            break;
        }
        if (!foundValidTickDiff) {
            throw new Exception("Could not find matching initial attack logs in order to merge fights.");
        }
        for (FightLogEntry log : opponentFightLogEntries) {
            log.setTick(log.getTick() + bestTickDiff);
        }
        this.analyzedMatchingLogs = new ArrayList();
        PvpPerformanceTrackerPlugin.PLUGIN.getClientThread().invokeLater(() -> {
            mainFightLogEntries.stream().filter(log -> log.attackerName.equals(mainFight.competitor.getName())).forEachOrdered(log -> {
                if (log.isFullEntry()) {
                    opponentFightLogEntries.stream().filter(ol -> ol.getTick() == log.getTick()).filter(ol -> !ol.isFullEntry()).filter(ol -> ol.attackerName.equals(mainFight.opponent.getName())).findFirst().ifPresent(matchingDefenderLog -> this.addCompetitorAttack((FightLogEntry)log, (FightLogEntry)matchingDefenderLog));
                } else {
                    opponentFightLogEntries.stream().filter(ol -> ol.getTick() == log.getTick()).filter(FightLogEntry::isFullEntry).filter(ol -> ol.attackerName.equals(mainFight.opponent.getName())).findFirst().ifPresent(matchingAttackerLog -> this.addOpponentAttack((FightLogEntry)matchingAttackerLog, (FightLogEntry)log));
                }
            });
            SwingUtilities.invokeLater(swingCallback);
        });
    }

    void addCompetitorAttack(FightLogEntry attackerLog, FightLogEntry defenderLog) {
        this.competitor.addAttack(attackerLog, defenderLog);
        this.analyzedMatchingLogs.add(new FightLogEntry[]{attackerLog, defenderLog});
    }

    void addOpponentAttack(FightLogEntry attackerLog, FightLogEntry defenderLog) {
        this.opponent.addAttack(attackerLog, defenderLog);
        this.analyzedMatchingLogs.add(new FightLogEntry[]{attackerLog, defenderLog});
    }

    public ArrayList<FightLogEntry[]> getAnalyzedMatchingLogs() {
        return this.analyzedMatchingLogs;
    }

    public FightPerformance getMainFight() {
        return this.mainFight;
    }

    public FightPerformance getOpposingFight() {
        return this.opposingFight;
    }
}

