/*
 * Decompiled with CFR 0.152.
 */
package matsyir.pvpperformancetracker;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.JsonPrimitive;
import com.google.inject.Provides;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import matsyir.pvpperformancetracker.PvpPerformanceTrackerConfig;
import matsyir.pvpperformancetracker.PvpPerformanceTrackerOverlay;
import matsyir.pvpperformancetracker.PvpPerformanceTrackerPanel;
import matsyir.pvpperformancetracker.controllers.FightPerformance;
import matsyir.pvpperformancetracker.models.CombatLevels;
import matsyir.pvpperformancetracker.models.RangeAmmoData;
import matsyir.pvpperformancetracker.models.oldVersions.FightPerformance__1_5_5;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.HeadIcon;
import net.runelite.api.Player;
import net.runelite.api.Prayer;
import net.runelite.api.Skill;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.FakeXpDrop;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.InteractingChanged;
import net.runelite.api.events.StatChanged;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ClientShutdown;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="PvP Performance Tracker")
public class PvpPerformanceTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PvpPerformanceTrackerPlugin.class);
    public static final String PLUGIN_VERSION = "1.5.7";
    public static final String CONFIG_KEY = "pvpperformancetracker";
    public static final String DATA_FOLDER = "pvp-performance-tracker";
    public static final String FIGHT_HISTORY_DATA_FNAME = "FightHistoryData.json";
    public static final File FIGHT_HISTORY_DATA_DIR;
    public static PvpPerformanceTrackerConfig CONFIG;
    public static PvpPerformanceTrackerPlugin PLUGIN;
    public static Image PLUGIN_ICON;
    public static AsyncBufferedImage DEFAULT_NONE_SYMBOL;
    public static Gson GSON;
    private static final Set<Integer> LAST_MAN_STANDING_REGIONS;
    private NavigationButton navButton;
    private boolean navButtonShown = false;
    private PvpPerformanceTrackerPanel panel;
    @Inject
    private PvpPerformanceTrackerConfig config;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ConfigManager configManager;
    @Inject
    private RuneLiteConfig runeliteConfig;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private PvpPerformanceTrackerOverlay overlay;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private Gson injectedGson;
    public ArrayList<FightPerformance> fightHistory;
    private FightPerformance currentFight;
    private Map<Integer, ImageIcon> spriteCache;

    @Provides
    PvpPerformanceTrackerConfig getConfig(ConfigManager configManager) {
        return (PvpPerformanceTrackerConfig)configManager.getConfig(PvpPerformanceTrackerConfig.class);
    }

    protected void startUp() throws Exception {
        CONFIG = this.config;
        PLUGIN = this;
        this.fightHistory = new ArrayList();
        GSON = this.injectedGson.newBuilder().excludeFieldsWithoutExposeAnnotation().registerTypeAdapter(Double.class, (value, theType, context) -> value.isNaN() ? new JsonPrimitive((Number)0) : new JsonPrimitive((Number)BigDecimal.valueOf(value).setScale(3, RoundingMode.HALF_UP))).create();
        if (!this.config.pluginVersion().equals(PLUGIN_VERSION)) {
            this.update(this.config.pluginVersion());
        }
        this.panel = (PvpPerformanceTrackerPanel)((Object)this.injector.getInstance(PvpPerformanceTrackerPanel.class));
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"/skull_red.png");
        PLUGIN_ICON = new ImageIcon(icon).getImage();
        this.navButton = NavigationButton.builder().tooltip("PvP Fight History").icon(icon).priority(6).panel((PluginPanel)this.panel).build();
        this.importFightHistoryData();
        if (this.config.showFightHistoryPanel() && (!this.config.restrictToLms() || this.client.getGameState() == GameState.LOGGED_IN && this.isAtLMS())) {
            this.navButtonShown = true;
            this.clientToolbar.addNavigation(this.navButton);
        }
        this.overlayManager.add((Overlay)this.overlay);
        this.spriteCache = new HashMap<Integer, ImageIcon>();
        this.clientThread.invokeLater(() -> {
            DEFAULT_NONE_SYMBOL = this.itemManager.getImage(20594);
        });
    }

    protected void shutDown() throws Exception {
        this.saveFightHistoryData();
        this.clientToolbar.removeNavigation(this.navButton);
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals(CONFIG_KEY)) {
            return;
        }
        switch (event.getKey()) {
            case "showFightHistoryPanel": 
            case "restrictToLms": {
                boolean isAtLms = this.isAtLMS();
                if (!this.navButtonShown && this.config.showFightHistoryPanel() && (!this.config.restrictToLms() || isAtLms)) {
                    SwingUtilities.invokeLater(() -> this.clientToolbar.addNavigation(this.navButton));
                    this.navButtonShown = true;
                    break;
                }
                if (!this.navButtonShown || this.config.showFightHistoryPanel() && (!this.config.restrictToLms() || isAtLms)) break;
                SwingUtilities.invokeLater(() -> this.clientToolbar.removeNavigation(this.navButton));
                this.navButtonShown = false;
                break;
            }
            case "showOverlayTitle": 
            case "showOverlayNames": 
            case "showOverlayOffPray": 
            case "showOverlayDeservedDmg": 
            case "showOverlayDmgDealt": 
            case "showOverlayMagicHits": 
            case "showOverlayOffensivePray": 
            case "showOverlayHpHealed": 
            case "showOverlayGhostBarrage": {
                this.overlay.setLines();
                break;
            }
            case "fightHistoryLimit": 
            case "fightHistoryRenderLimit": {
                if (this.config.fightHistoryLimit() > 0 && this.fightHistory.size() > this.config.fightHistoryLimit()) {
                    int numToRemove = this.fightHistory.size() - this.config.fightHistoryLimit();
                    this.fightHistory.removeIf(f -> this.fightHistory.indexOf(f) < numToRemove);
                }
                this.panel.rebuild();
                break;
            }
            case "exactNameFilter": {
                this.panel.rebuild();
                break;
            }
            case "settingsConfigured": {
                boolean enableConfigWarning = !this.config.settingsConfigured();
                this.panel.setConfigWarning(enableConfigWarning);
            }
        }
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged event) {
        Actor opponent;
        if (this.config.restrictToLms() && !this.isAtLMS()) {
            return;
        }
        this.stopFightIfOver();
        if (this.hasOpponent() && this.currentFight.fightStarted() || !(event.getSource() instanceof Player) || !(event.getTarget() instanceof Player)) {
            return;
        }
        if (event.getSource().equals(this.client.getLocalPlayer())) {
            opponent = event.getTarget();
        } else if (event.getTarget().equals(this.client.getLocalPlayer())) {
            opponent = event.getSource();
        } else {
            return;
        }
        if (!this.hasOpponent() || !this.currentFight.getOpponent().getName().equals(opponent.getName())) {
            this.currentFight = new FightPerformance(this.client.getLocalPlayer(), (Player)opponent);
            this.overlay.setFight(this.currentFight);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (this.config.restrictToLms()) {
            if (this.isAtLMS()) {
                if (!this.navButtonShown && this.config.showFightHistoryPanel()) {
                    this.clientToolbar.addNavigation(this.navButton);
                    this.navButtonShown = true;
                }
            } else if (this.navButtonShown) {
                this.clientToolbar.removeNavigation(this.navButton);
                this.navButtonShown = false;
            }
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        this.stopFightIfOver();
        this.clientThread.invokeLater(() -> {
            if (this.hasOpponent() && event.getActor() instanceof Player && event.getActor().getName() != null) {
                this.currentFight.checkForAttackAnimations((Player)event.getActor(), new CombatLevels(this.client));
            }
        });
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied event) {
        int hitType = event.getHitsplat().getHitsplatType();
        if (!this.hasOpponent() || !(event.getActor() instanceof Player) || hitType != 16 && hitType != 20 && hitType != 21 && hitType != 17 && hitType != 43 && hitType != 45 && hitType != 2 && hitType != 5) {
            return;
        }
        this.currentFight.addDamageDealt(event.getActor().getName(), event.getHitsplat().getAmount());
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        int magicXp;
        Skill skill = statChanged.getSkill();
        if (!this.hasOpponent()) {
            return;
        }
        if (skill == Skill.HITPOINTS) {
            this.currentFight.updateCompetitorHp(this.client.getBoostedSkillLevel(Skill.HITPOINTS));
        }
        if (skill == Skill.MAGIC && (magicXp = this.client.getSkillExperience(Skill.MAGIC)) > this.currentFight.competitor.getLastGhostBarrageCheckedMageXp()) {
            this.currentFight.competitor.setLastGhostBarrageCheckedMageXp(PLUGIN.getClient().getSkillExperience(Skill.MAGIC));
            this.clientThread.invokeLater(this::checkForGhostBarrage);
        }
    }

    @Subscribe
    public void onFakeXpDrop(FakeXpDrop fakeXpDrop) {
        if (!this.hasOpponent() || fakeXpDrop.getSkill() != Skill.MAGIC) {
            return;
        }
        this.clientThread.invokeLater(this::checkForGhostBarrage);
    }

    private void checkForGhostBarrage() {
        if (!this.hasOpponent()) {
            return;
        }
        this.currentFight.checkForLocalGhostBarrage(new CombatLevels(this.client), this.client.getLocalPlayer());
    }

    public void resetConfiguration() {
        super.resetConfiguration();
        this.resetFightHistory();
    }

    @Subscribe
    public void onClientShutdown(ClientShutdown event) {
        event.waitFor(this.executor.submit(this::saveFightHistoryData));
    }

    private void update(String oldVersion) {
        switch (oldVersion) {
            case "1.4.0": 
            case "1.4.1": 
            case "1.4.2": 
            case "1.4.3": 
            case "1.4.4": 
            case "1.4.5": 
            case "1.4.6": 
            case "1.4.7": 
            case "1.4.8": 
            case "1.5.0": 
            case "1.5.1": 
            case "1.5.2": 
            case "1.5.3": 
            case "1.5.4": 
            case "1.5.5": {
                this.updateFrom1_5_5to1_5_6();
            }
        }
        this.configManager.setConfiguration(CONFIG_KEY, "pluginVersion", PLUGIN_VERSION);
    }

    private void updateFrom1_5_5to1_5_6() {
        try {
            log.info("Updating data from 1.5.5 (or earlier) to 1.5.6...");
            FIGHT_HISTORY_DATA_DIR.mkdirs();
            File fightHistoryData = new File(FIGHT_HISTORY_DATA_DIR, FIGHT_HISTORY_DATA_FNAME);
            if (!fightHistoryData.exists()) {
                FileWriter writer = new FileWriter(fightHistoryData);
                writer.write("[]");
                ((Writer)writer).close();
                return;
            }
            this.fightHistory.clear();
            Arrays.asList((FightPerformance__1_5_5[])GSON.fromJson((Reader)new FileReader(fightHistoryData), FightPerformance__1_5_5[].class)).forEach(oldFight -> this.fightHistory.add(new FightPerformance((FightPerformance__1_5_5)oldFight)));
            this.saveFightHistoryData();
            log.info("Successfully updated from 1.5.5 to 1.5.6");
        }
        catch (Exception e) {
            log.warn("Error while updating fight history data from 1.5.5 to 1.5.6: " + e.getMessage());
        }
    }

    private boolean hasOpponent() {
        return this.currentFight != null;
    }

    private void stopFightIfOver() {
        if (this.hasOpponent() && this.currentFight.isFightOver()) {
            if (this.currentFight.fightStarted()) {
                this.addToFightHistory(this.currentFight);
            }
            this.currentFight = null;
        }
    }

    private void saveFightHistoryData() {
        try {
            File fightHistoryData = new File(FIGHT_HISTORY_DATA_DIR, FIGHT_HISTORY_DATA_FNAME);
            FileWriter writer = new FileWriter(fightHistoryData);
            GSON.toJson(this.fightHistory, (Appendable)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (Exception e) {
            log.warn("Error ignored while updating fight history data: " + e.getMessage());
        }
    }

    void addToFightHistory(FightPerformance fight) {
        if (fight == null) {
            return;
        }
        this.fightHistory.add(fight);
        if (this.config.fightHistoryLimit() > 0 && this.fightHistory.size() > this.config.fightHistoryLimit()) {
            int numToRemove = this.fightHistory.size() - this.config.fightHistoryLimit();
            this.fightHistory.removeIf(f -> this.fightHistory.indexOf(f) < numToRemove);
            this.panel.rebuild();
        } else {
            this.panel.addFight(fight);
        }
    }

    void importFightHistoryData() {
        try {
            FIGHT_HISTORY_DATA_DIR.mkdirs();
            File fightHistoryData = new File(FIGHT_HISTORY_DATA_DIR, FIGHT_HISTORY_DATA_FNAME);
            if (!fightHistoryData.exists()) {
                FileWriter writer = new FileWriter(fightHistoryData);
                writer.write("[]");
                ((Writer)writer).close();
            }
            List<FightPerformance> savedFights = Arrays.asList((FightPerformance[])GSON.fromJson((Reader)new FileReader(fightHistoryData), FightPerformance[].class));
            this.fightHistory.clear();
            this.importFights(savedFights);
        }
        catch (Exception e) {
            log.warn("Error while deserializing fight history data: " + e.getMessage());
            return;
        }
        this.panel.rebuild();
    }

    public void importUserFightHistoryData(String data) {
        try {
            List<FightPerformance> savedFights = Arrays.asList((FightPerformance[])GSON.fromJson(data, FightPerformance[].class));
            this.importFights(savedFights);
            this.createConfirmationModal(true, "Fight history data was successfully imported.");
        }
        catch (Exception e) {
            log.warn("Error while importing user's fight history data: " + e.getMessage());
            this.createConfirmationModal(false, "Fight history data was invalid, and could not be imported.");
            return;
        }
        this.panel.rebuild();
    }

    public void initializeImportedFight(FightPerformance f) {
        if (f.getCompetitor() == null || f.getOpponent() == null || f.getCompetitor().getFightLogEntries() == null || f.getOpponent().getFightLogEntries() == null) {
            return;
        }
        f.getCompetitor().getFightLogEntries().forEach(l -> {
            l.attackerName = f.getCompetitor().getName();
        });
        f.getOpponent().getFightLogEntries().forEach(l -> {
            l.attackerName = f.getOpponent().getName();
        });
    }

    void importFights(List<FightPerformance> fights) throws NullPointerException {
        if (fights == null || fights.size() < 1) {
            return;
        }
        fights.removeIf(Objects::isNull);
        this.fightHistory.addAll(fights);
        this.fightHistory.sort(FightPerformance::compareTo);
        if (this.config.fightHistoryLimit() > 0 && this.fightHistory.size() > this.config.fightHistoryLimit()) {
            int numToRemove = this.fightHistory.size() - this.config.fightHistoryLimit();
            this.fightHistory.removeIf(f -> this.fightHistory.indexOf(f) < numToRemove);
        }
        for (FightPerformance f2 : this.fightHistory) {
            this.initializeImportedFight(f2);
        }
    }

    public void resetFightHistory() {
        this.fightHistory.clear();
        this.saveFightHistoryData();
        this.panel.rebuild();
    }

    public void removeFight(FightPerformance fight) {
        this.fightHistory.remove(fight);
        this.panel.rebuild();
    }

    public boolean isAtLMS() {
        int[] mapRegions = this.client.getMapRegions();
        for (int region : LAST_MAN_STANDING_REGIONS) {
            if (!ArrayUtils.contains((int[])mapRegions, (int)region)) continue;
            return true;
        }
        return false;
    }

    public void sendChatMessage(String chatMessage) {
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.TRADE).runeLiteFormattedMessage(chatMessage).build());
    }

    public void createConfirmationModal(boolean success, String message) {
        SwingUtilities.invokeLater(() -> {
            JOptionPane optionPane = new JOptionPane();
            optionPane.setMessage(message);
            optionPane.setOptionType(-1);
            JDialog dialog = optionPane.createDialog((Component)((Object)this.panel), "PvP Tracker: " + (success ? "Success" : "Error"));
            if (dialog.isAlwaysOnTopSupported()) {
                dialog.setAlwaysOnTop(this.runeliteConfig.gameAlwaysOnTop());
            }
            dialog.setIconImage(PLUGIN_ICON);
            dialog.setVisible(true);
        });
    }

    public void exportFightHistory() {
        String fightHistoryDataJson = GSON.toJson((Object)this.fightHistory.toArray(new FightPerformance[0]), FightPerformance[].class);
        StringSelection contents = new StringSelection(fightHistoryDataJson);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(contents, null);
        this.createConfirmationModal(true, "Fight history data was copied to the clipboard.");
    }

    public void exportFight(FightPerformance fight) {
        Object confirmMessage;
        if (fight == null) {
            return;
        }
        String fightDataJson = GSON.toJson((Object)fight, FightPerformance.class);
        StringSelection contents = new StringSelection(fightDataJson);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(contents, null);
        boolean success = false;
        if (fight.getCompetitor() != null && fight.getCompetitor().getName() != null && fight.getOpponent() != null && fight.getOpponent().getName() != null) {
            success = true;
            confirmMessage = "Fight data of " + fight.getCompetitor().getName() + " vs " + fight.getOpponent().getName() + " was copied to the clipboard.";
        } else {
            confirmMessage = "Warning: Fight data was copied to the clipboard, but it's likely corrupted.";
        }
        this.createConfirmationModal(success, (String)confirmMessage);
    }

    public void copyFightAsDiscordMsg(FightPerformance fight) {
        if (fight == null) {
            return;
        }
        String fightMsg = fight.getAsDiscordMessage();
        StringSelection contents = new StringSelection(fightMsg);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(contents, null);
        this.createConfirmationModal(true, "Discord message of fight data was copied to the clipboard.");
    }

    public int currentlyUsedOffensivePray() {
        return this.client.isPrayerActive(Prayer.PIETY) ? 946 : (this.client.isPrayerActive(Prayer.ULTIMATE_STRENGTH) ? 125 : (this.client.isPrayerActive(Prayer.RIGOUR) ? 1420 : (this.client.isPrayerActive(Prayer.EAGLE_EYE) ? 504 : (this.client.isPrayerActive(Prayer.AUGURY) ? 1421 : (this.client.isPrayerActive(Prayer.MYSTIC_MIGHT) ? 505 : 0)))));
    }

    public int getSpriteForHeadIcon(HeadIcon icon) {
        if (icon == null) {
            return -1;
        }
        switch (icon) {
            case MELEE: {
                return 129;
            }
            case RANGED: {
                return 128;
            }
            case MAGIC: {
                return 127;
            }
            case SMITE: {
                return 132;
            }
            case RETRIBUTION: {
                return 131;
            }
            case REDEMPTION: {
                return 130;
            }
        }
        return -1;
    }

    public int getSpriteForSkill(Skill skill) {
        switch (skill) {
            case ATTACK: {
                return 197;
            }
            case STRENGTH: {
                return 198;
            }
            case DEFENCE: {
                return 199;
            }
            case RANGED: {
                return 200;
            }
            case MAGIC: {
                return 202;
            }
            case HITPOINTS: {
                return 203;
            }
        }
        return -1;
    }

    public void addSpriteToLabelIfValid(JLabel label, int spriteId, Runnable swingCallback) {
        if (spriteId <= 0) {
            DEFAULT_NONE_SYMBOL.addTo(label);
            label.setToolTipText("N/A");
            if (swingCallback != null) {
                SwingUtilities.invokeLater(swingCallback);
            }
            return;
        }
        if (this.spriteCache.containsKey(spriteId)) {
            label.setIcon(this.spriteCache.get(spriteId));
            if (swingCallback != null) {
                SwingUtilities.invokeLater(swingCallback);
            }
            return;
        }
        this.clientThread.invokeLater(() -> {
            BufferedImage sprite = this.spriteManager.getSprite(spriteId, 0);
            if (sprite != null) {
                ImageIcon icon = new ImageIcon(sprite);
                this.spriteCache.put(spriteId, icon);
                label.setIcon(icon);
            } else {
                DEFAULT_NONE_SYMBOL.addTo(label);
                label.setToolTipText("N/A");
            }
            if (swingCallback != null) {
                SwingUtilities.invokeLater(swingCallback);
            }
        });
    }

    public void addSpriteToLabelIfValid(JLabel label, int spriteId) {
        this.addSpriteToLabelIfValid(label, spriteId, null);
    }

    public void addItemToLabelIfValid(JLabel label, int itemId, boolean verifyId, Runnable swingCallback, String tooltipOverride) {
        if (itemId > 512 || !verifyId) {
            int finalItemId = itemId - (verifyId ? 512 : 0);
            this.clientThread.invokeLater(() -> {
                this.itemManager.getImage(finalItemId).addTo(label);
                if (tooltipOverride != null && tooltipOverride.length() > 0) {
                    label.setToolTipText(tooltipOverride);
                } else {
                    String name = this.itemManager.getItemComposition(finalItemId).getName();
                    label.setToolTipText(name != null ? name : "Item Name Not Found");
                }
                if (swingCallback != null) {
                    SwingUtilities.invokeLater(swingCallback);
                }
            });
        } else {
            DEFAULT_NONE_SYMBOL.addTo(label);
            label.setToolTipText("N/A: empty slot or invalid item");
            if (swingCallback != null) {
                SwingUtilities.invokeLater(swingCallback);
            }
        }
    }

    public void addItemToLabelIfValid(JLabel label, RangeAmmoData data, boolean verifyId, Runnable swingCallback) {
        this.addItemToLabelIfValid(label, data.getItemId(), verifyId, swingCallback, data.toString());
    }

    public void addItemToLabelIfValid(JLabel label, int itemId, boolean verifyId, Runnable swingCallback) {
        this.addItemToLabelIfValid(label, itemId, verifyId, swingCallback, null);
    }

    public void addItemToLabelIfValid(JLabel label, int itemId) {
        this.addItemToLabelIfValid(label, itemId, true, null);
    }

    public static int fixItemId(int itemId) {
        return itemId > 512 ? itemId - 512 : itemId;
    }

    public static int[] fixItemIds(int[] itemIds) {
        if (itemIds == null || itemIds.length < 1) {
            return new int[]{0};
        }
        int[] fixedItemIds = new int[itemIds.length];
        for (int i = 0; i < itemIds.length; ++i) {
            fixedItemIds[i] = PvpPerformanceTrackerPlugin.fixItemId(itemIds[i]);
        }
        return fixedItemIds;
    }

    public void updateNameFilterConfig(String newFilterName) {
        this.configManager.setConfiguration(CONFIG_KEY, "nameFilter", newFilterName.trim().toLowerCase());
    }

    NavigationButton getNavButton() {
        return this.navButton;
    }

    PvpPerformanceTrackerPanel getPanel() {
        return this.panel;
    }

    public Client getClient() {
        return this.client;
    }

    public ClientThread getClientThread() {
        return this.clientThread;
    }

    public RuneLiteConfig getRuneliteConfig() {
        return this.runeliteConfig;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public FightPerformance getCurrentFight() {
        return this.currentFight;
    }

    static {
        LAST_MAN_STANDING_REGIONS = ImmutableSet.of((Object)12344, (Object)12600, (Object)13658, (Object)13659, (Object)13660, (Object)13914, (Object[])new Integer[]{13915, 13916, 13918, 13919, 13920, 14174, 14175, 14176, 14430, 14431, 14432});
        FIGHT_HISTORY_DATA_DIR = new File(RuneLite.RUNELITE_DIR, DATA_FOLDER);
        FIGHT_HISTORY_DATA_DIR.mkdirs();
    }
}

