/*
 * Decompiled with CFR 0.152.
 */
package matsyir.pvpperformancetracker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import matsyir.pvpperformancetracker.PvpPerformanceTrackerConfig;
import matsyir.pvpperformancetracker.PvpPerformanceTrackerPlugin;
import matsyir.pvpperformancetracker.controllers.FightPerformance;
import matsyir.pvpperformancetracker.views.FightPerformancePanel;
import matsyir.pvpperformancetracker.views.TotalStatsPanel;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;

class PvpPerformanceTrackerPanel
extends PluginPanel {
    private final JPanel fightHistoryContainer = new JPanel();
    private final TotalStatsPanel totalStatsPanel = new TotalStatsPanel();
    private final PvpPerformanceTrackerPlugin plugin;
    private final PvpPerformanceTrackerConfig config;

    @Inject
    private PvpPerformanceTrackerPanel(final PvpPerformanceTrackerPlugin plugin, PvpPerformanceTrackerConfig config) {
        super(false);
        this.plugin = plugin;
        this.config = config;
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setBorder(new EmptyBorder(8, 8, 8, 8));
        JPanel mainContent = new JPanel(new BorderLayout());
        this.fightHistoryContainer.setLayout(new BoxLayout(this.fightHistoryContainer, 1));
        this.add(this.totalStatsPanel);
        JPanel filterLine = new JPanel(new BorderLayout());
        JLabel filterLabel = new JLabel("Filter Usernames:");
        filterLabel.setHorizontalAlignment(0);
        final JTextField nameFilter = new JTextField(config.nameFilter());
        filterLine.setMaximumSize(new Dimension(225, (int)filterLine.getPreferredSize().getHeight()));
        nameFilter.getDocument().addDocumentListener(new DocumentListener(){

            private void updateNameFilterValue() {
                plugin.updateNameFilterConfig(nameFilter.getText());
                if (!nameFilter.getText().startsWith(" ")) {
                    PvpPerformanceTrackerPanel.this.rebuild();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateNameFilterValue();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateNameFilterValue();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateNameFilterValue();
            }
        });
        filterLine.add((Component)filterLabel, "North");
        filterLine.add((Component)nameFilter, "Center");
        this.add(Box.createRigidArea(new Dimension(0, 4)));
        this.add(filterLine);
        JScrollPane scrollableContainer = new JScrollPane(mainContent);
        scrollableContainer.setBackground(ColorScheme.DARK_GRAY_COLOR);
        scrollableContainer.getVerticalScrollBar().setPreferredSize(new Dimension(6, 0));
        mainContent.add((Component)this.fightHistoryContainer, "North");
        this.add(Box.createRigidArea(new Dimension(0, 4)));
        this.add(scrollableContainer);
    }

    public void addFight(FightPerformance fight) {
        if (!this.config.nameFilter().equals("") && (this.config.exactNameFilter() ? !fight.getCompetitor().getName().toLowerCase().equals(this.config.nameFilter()) && !fight.getOpponent().getName().toLowerCase().equals(this.config.nameFilter()) : !fight.getCompetitor().getName().toLowerCase().startsWith(this.config.nameFilter()) && !fight.getOpponent().getName().toLowerCase().startsWith(this.config.nameFilter()))) {
            return;
        }
        this.totalStatsPanel.addFight(fight);
        SwingUtilities.invokeLater(() -> {
            this.fightHistoryContainer.add((Component)new FightPerformancePanel(fight), 0);
            if (this.fightHistoryContainer.getComponentCount() > this.config.fightHistoryRenderLimit()) {
                int numFightsToRemove = this.fightHistoryContainer.getComponentCount() - this.config.fightHistoryRenderLimit();
                for (int i = 0; i < numFightsToRemove && this.fightHistoryContainer.getComponentCount() > 0; ++i) {
                    this.fightHistoryContainer.remove(this.fightHistoryContainer.getComponentCount() - 1);
                }
            }
            this.updateUI();
        });
    }

    public void addFights(ArrayList<FightPerformance> fights) {
        if (!this.config.nameFilter().equals("")) {
            fights.removeIf(f -> this.config.exactNameFilter() ? !f.getCompetitor().getName().toLowerCase().equals(this.config.nameFilter()) && !f.getOpponent().getName().toLowerCase().equals(this.config.nameFilter()) : !f.getCompetitor().getName().toLowerCase().startsWith(this.config.nameFilter()) && !f.getOpponent().getName().toLowerCase().startsWith(this.config.nameFilter()));
        }
        this.totalStatsPanel.addFights(fights);
        SwingUtilities.invokeLater(() -> {
            if (fights.size() > this.config.fightHistoryRenderLimit()) {
                int numFightsToRemove = fights.size() - this.config.fightHistoryRenderLimit();
                fights.removeIf(f -> fights.indexOf(f) < numFightsToRemove);
                this.fightHistoryContainer.removeAll();
            } else {
                int fightsToAdd = fights.size();
                int fightsToRemove = this.fightHistoryContainer.getComponentCount() - this.config.fightHistoryRenderLimit() + fightsToAdd;
                if (fightsToRemove > 0) {
                    for (int i = 0; i < fightsToRemove && this.fightHistoryContainer.getComponentCount() > 0; ++i) {
                        this.fightHistoryContainer.remove(this.fightHistoryContainer.getComponentCount() - 1);
                    }
                }
            }
            fights.forEach(f -> this.fightHistoryContainer.add((Component)new FightPerformancePanel((FightPerformance)f), 0));
            this.updateUI();
        });
    }

    public void rebuild() {
        this.totalStatsPanel.reset();
        this.fightHistoryContainer.removeAll();
        if (this.plugin.fightHistory.size() > 0) {
            ArrayList<FightPerformance> fightsToAdd = new ArrayList<FightPerformance>(this.plugin.fightHistory);
            this.addFights(fightsToAdd);
        }
        SwingUtilities.invokeLater(() -> this.updateUI());
    }

    public void setConfigWarning(boolean enable) {
        this.totalStatsPanel.setConfigWarning(enable);
    }
}

