/*
 * Decompiled with CFR 0.152.
 */
package com.PlayerCoder1;

import com.PlayerCoder1.TranslationPanel;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.json.JSONObject;

@PluginDescriptor(name="Translation Plugin", description="Translates everything in the chatbox", tags={"Translation", "Language"})
public class TranslationPlugin
extends Plugin {
    private static final int MAX_MESSAGES = 13;
    private final LinkedList<String> lastMessages = new LinkedList();
    private ExecutorService executorService;
    private TranslationPanel panel;
    private NavigationButton navButton;
    private String targetLanguage = "ES";
    @Inject
    private OkHttpClient client;
    @Inject
    private ClientToolbar clientToolbar;

    protected void startUp() {
        this.executorService = Executors.newFixedThreadPool(10);
        this.panel = new TranslationPanel(this);
        BufferedImage icon = ImageUtil.loadImageResource(TranslationPlugin.class, (String)"panel_icon.png");
        this.navButton = NavigationButton.builder().tooltip("Translation").icon(icon).priority(5).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() {
        this.executorService.shutdown();
        this.clientToolbar.removeNavigation(this.navButton);
    }

    public List<String> getLastMessages() {
        return this.lastMessages;
    }

    public void setTargetLanguage(String targetLanguage) {
        this.targetLanguage = targetLanguage;
    }

    public String getTargetLanguage() {
        return this.targetLanguage;
    }

    public String translateText(String originalText) throws IOException, ApiLimitExceededException {
        String encodedText = URLEncoder.encode(originalText, StandardCharsets.UTF_8);
        String url = "https://api.mymemory.translated.net/get?q=" + encodedText + "&langpair=en|" + this.targetLanguage;
        Request request = new Request.Builder().url(url).build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                if (response.code() == 429) {
                    throw new ApiLimitExceededException("API usage limit exceeded");
                }
                throw new IOException("Unexpected code " + response);
            }
            ResponseBody responseBody = response.body();
            if (responseBody != null) {
                JSONObject jsonResponse = new JSONObject(responseBody.string());
                String string = jsonResponse.getJSONObject("responseData").getString("translatedText");
                return string;
            }
            throw new IOException("Response body is null");
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        String originalMessage = chatMessage.getMessage();
        String playerName = chatMessage.getName();
        this.executorService.submit(() -> {
            try {
                String translatedMessage = this.translateText(originalMessage);
                SwingUtilities.invokeLater(() -> {
                    this.lastMessages.addFirst(playerName + ": " + translatedMessage);
                    while (this.lastMessages.size() > 13) {
                        this.lastMessages.removeLast();
                    }
                    this.panel.updateMessages();
                });
            }
            catch (ApiLimitExceededException e) {
                SwingUtilities.invokeLater(() -> {
                    JOptionPane.showMessageDialog(null, "You have reached the 5000 words limit for today. Please wait 24 hours to use the plugin again.", "Error", 0);
                    this.shutDown();
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public static class ApiLimitExceededException
    extends Exception {
        public ApiLimitExceededException(String message) {
            super(message);
        }
    }
}

