/*
 * Decompiled with CFR 0.152.
 */
package com.PlayerCoder1;

import com.PlayerCoder1.TranslationPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.PluginPanel;

public class TranslationPanel
extends PluginPanel {
    private final TranslationPlugin plugin;
    private final DefaultListModel<String> listModel = new DefaultListModel();
    private final JComboBox<String> languageComboBox;

    public TranslationPanel(TranslationPlugin plugin) {
        this.plugin = plugin;
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(30, 30, 30));
        this.languageComboBox = new JComboBox<String>(new String[]{"ES", "FR", "IT", "NL"});
        this.languageComboBox.addActionListener(e -> {
            String selectedLanguage = (String)this.languageComboBox.getSelectedItem();
            plugin.setTargetLanguage(selectedLanguage);
        });
        JPanel topPanel = new JPanel(new FlowLayout(0));
        topPanel.setBackground(new Color(30, 30, 30));
        topPanel.add(new JLabel("Target Language: "));
        topPanel.add(this.languageComboBox);
        this.add(topPanel, "North");
        JList<String> messageList = new JList<String>(this.listModel);
        messageList.setBackground(new Color(30, 30, 30));
        messageList.setForeground(Color.WHITE);
        messageList.setFont(new Font("Arial", 0, 12));
        messageList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                label.setBorder(new EmptyBorder(10, 10, 10, 10));
                return label;
            }
        });
        JScrollPane scrollPane = new JScrollPane(messageList);
        scrollPane.setBorder(null);
        scrollPane.setHorizontalScrollBarPolicy(32);
        this.add(scrollPane, "Center");
    }

    public void updateMessages() {
        SwingUtilities.invokeLater(() -> {
            this.listModel.clear();
            for (String message : this.plugin.getLastMessages()) {
                this.listModel.addElement(message);
            }
        });
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 500);
    }
}

