/*
 * Decompiled with CFR 0.152.
 */
package com.clanKDR;

import com.clanKDR.ClanKDRConfig;
import com.clanKDR.ClanKDROverlay;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.clan.ClanMember;
import net.runelite.api.clan.ClanSettings;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Clan KDR")
public class ClanKDRPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ClanKDRPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClanKDRConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ClanKDROverlay overlay;
    private int clanKills = 0;
    private int clanDeaths = 0;
    private int clanKillsTotalValue = 0;
    private int clanDeathsTotalValue = 0;

    @Provides
    ClanKDRConfig provideConfig(ConfigManager configManager) {
        return (ClanKDRConfig)configManager.getConfig(ClanKDRConfig.class);
    }

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.resetKDR();
    }

    private void resetKDR() {
        this.clanKills = 0;
        this.clanDeaths = 0;
        this.clanKillsTotalValue = 0;
        this.clanDeathsTotalValue = 0;
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        ClanSettings clanSettings;
        if (event.getType() != ChatMessageType.CLAN_MESSAGE) {
            return;
        }
        if (event.getMessage().contains("has defeated")) {
            if (this.config.excludeFriendlyFire()) {
                String playerKilled = StringUtils.substringBetween((String)event.getMessage(), (String)"has defeated ", (String)" and received");
                clanSettings = this.client.getClanSettings();
                for (ClanMember clanMember : clanSettings.getMembers()) {
                    if (!Text.toJagexName((String)clanMember.getName()).equalsIgnoreCase(Text.toJagexName((String)playerKilled))) continue;
                    return;
                }
            }
            String killValue = StringUtils.substringBetween((String)event.getMessage(), (String)"(", (String)")");
            if (this.config.excludeLowLoot()) {
                if (killValue == null) {
                    return;
                }
                int value = this.getKillValue(killValue);
                if (value <= this.config.minimumValue()) {
                    return;
                }
            }
            ++this.clanKills;
            if (killValue != null) {
                this.clanKillsTotalValue += this.getKillValue(killValue);
            }
        }
        if (event.getMessage().contains("has been defeated")) {
            String deathValue;
            if (this.config.excludeFriendlyFire()) {
                String playerKiller = event.getMessage().contains("Wilderness") ? StringUtils.substringBetween((String)event.getMessage(), (String)"has been defeated by ", (String)" in The Wilderness") : StringUtils.substringBetween((String)event.getMessage(), (String)"has been defeated by ", (String)" and lost");
                clanSettings = this.client.getClanSettings();
                for (ClanMember clanMember : clanSettings.getMembers()) {
                    if (!Text.toJagexName((String)clanMember.getName()).equalsIgnoreCase(Text.toJagexName((String)playerKiller))) continue;
                    return;
                }
            }
            if ((deathValue = StringUtils.substringBetween((String)event.getMessage(), (String)"(", (String)")")) != null) {
                this.clanDeathsTotalValue += this.getKillValue(deathValue);
                ++this.clanDeaths;
            } else if (!this.config.excludeZeroValueDeaths()) {
                ++this.clanDeaths;
            }
        }
    }

    private int getKillValue(String killMsg) {
        return Integer.parseInt(killMsg.replace(",", "").replace("coins", "").replace(" ", ""));
    }

    int getClanKills() {
        return this.clanKills;
    }

    int getClanDeaths() {
        return this.clanDeaths;
    }

    int getClanKillsTotalValue() {
        return this.clanKillsTotalValue;
    }

    int getClanDeathsTotalValue() {
        return this.clanDeathsTotalValue;
    }
}

