/*
 * Decompiled with CFR 0.152.
 */
package com.clanKDR;

import com.clanKDR.ClanKDRConfig;
import com.clanKDR.ClanKDRPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class ClanKDROverlay
extends OverlayPanel {
    private final ClanKDRPlugin plugin;
    private final ClanKDRConfig config;
    @Inject
    private Client client;
    private final DecimalFormat decFormat = new DecimalFormat("###,###");

    @Inject
    private ClanKDROverlay(ClanKDRPlugin plugin, ClanKDRConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.BOTTOM_RIGHT);
        this.setPriority(OverlayPriority.LOW);
        this.panelComponent.setWrap(true);
        this.panelComponent.setOrientation(ComponentOrientation.HORIZONTAL);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Clan KDR overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        if (this.client.getClanChannel() != null) {
            this.panelComponent.getChildren().add(TitleComponent.builder().text(this.client.getClanChannel().getName()).build());
            this.panelComponent.getChildren().add(TitleComponent.builder().text("Kills: " + this.plugin.getClanKills() + " | Deaths: " + this.plugin.getClanDeaths()).build());
            if (this.config.showValue()) {
                this.panelComponent.getChildren().add(TitleComponent.builder().text("Kills Value: " + this.decFormat.format(this.plugin.getClanKillsTotalValue())).build());
                this.panelComponent.getChildren().add(TitleComponent.builder().text("Deaths Value: " + this.decFormat.format(this.plugin.getClanDeathsTotalValue())).build());
            }
        }
        return super.render(graphics);
    }
}

