/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.ui;

import com.twitchliveloadout.marketplace.MarketplaceManager;
import com.twitchliveloadout.marketplace.products.StreamerProduct;
import com.twitchliveloadout.marketplace.products.TwitchProductCost;
import com.twitchliveloadout.marketplace.transactions.TwitchTransaction;
import com.twitchliveloadout.ui.EntityActionPanel;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchTransactionPanel
extends EntityActionPanel<TwitchTransaction> {
    private static final Logger log = LoggerFactory.getLogger(TwitchTransactionPanel.class);
    private final MarketplaceManager marketplaceManager;

    public TwitchTransactionPanel(JPanel parentPanel, MarketplaceManager marketplaceManager) {
        super(parentPanel, "Invalid Twitch Transaction", false, "Are you sure you want to rerun this donation Random Event?", "Rerun Random Event", EntityActionPanel.RERUN_ICON, EntityActionPanel.RERUN_HOVER_ICON);
        this.marketplaceManager = marketplaceManager;
    }

    @Override
    protected String[] getLines() {
        TwitchTransaction twitchTransaction = (TwitchTransaction)this.getEntity();
        StreamerProduct streamerProduct = this.marketplaceManager.getStreamerProductByTransaction(twitchTransaction);
        String viewerName = twitchTransaction.user_name;
        TwitchProductCost productCost = twitchTransaction.product_data.cost;
        Integer costAmount = productCost.amount;
        String costCurrency = productCost.type;
        Instant transactionAt = Instant.parse(twitchTransaction.timestamp);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss - dd MMM yyyy").withZone(ZoneId.systemDefault());
        String transactionAtString = formatter.format(transactionAt);
        String streamerProductName = "Unknown";
        if (streamerProduct != null) {
            streamerProductName = streamerProduct.name;
        }
        String[] lines = new String[]{"<b>" + streamerProductName + "</b>", "Donation of <b color='yellow'>" + costAmount + " " + costCurrency + "</b>", "By <b color='yellow'>" + viewerName + "</b>", "At " + transactionAtString};
        return lines;
    }

    @Override
    protected void executeAction() {
        TwitchTransaction twitchTransaction = (TwitchTransaction)this.getEntity();
        String transactionId = twitchTransaction != null ? twitchTransaction.id : "unknown";
        log.info("A transaction is manually requested for a rerun, transaction ID: " + transactionId);
        this.marketplaceManager.rerunTransaction(twitchTransaction);
    }
}

