/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.ui;

import com.twitchliveloadout.TwitchLiveLoadoutConfig;
import com.twitchliveloadout.TwitchLiveLoadoutPlugin;
import com.twitchliveloadout.fights.FightStateManager;
import com.twitchliveloadout.marketplace.MarketplaceManager;
import com.twitchliveloadout.twitch.TwitchApi;
import com.twitchliveloadout.twitch.TwitchState;
import com.twitchliveloadout.ui.CanvasListener;
import com.twitchliveloadout.ui.CombatPanel;
import com.twitchliveloadout.ui.ConnectivityPanel;
import com.twitchliveloadout.ui.MarketplacePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.materialtabs.MaterialTab;
import net.runelite.client.ui.components.materialtabs.MaterialTabGroup;

public class TwitchLiveLoadoutPanel
extends PluginPanel {
    private final JPanel mainPanel = new JPanel(new GridBagLayout());
    private final MaterialTabGroup tabGroup = new MaterialTabGroup(this.mainPanel);
    private final MaterialTab connectivityTab;
    private final MaterialTab combatTab;
    private final MaterialTab marketplaceTab;
    private final ConnectivityPanel connectivityPanel;
    private final CombatPanel combatPanel;
    private final MarketplacePanel marketplacePanel;

    public TwitchLiveLoadoutPanel(TwitchLiveLoadoutPlugin plugin, TwitchApi twitchApi, TwitchState twitchState, FightStateManager fightStateManager, MarketplaceManager marketplaceManager, CanvasListener canvasListener, TwitchLiveLoadoutConfig config) {
        super(true);
        this.setLayout(new BorderLayout());
        this.combatPanel = new CombatPanel(fightStateManager);
        this.connectivityPanel = new ConnectivityPanel(plugin, twitchApi, twitchState, canvasListener, config);
        this.marketplacePanel = new MarketplacePanel(marketplaceManager);
        this.connectivityTab = new MaterialTab("Status", this.tabGroup, (JComponent)this.connectivityPanel);
        this.marketplaceTab = new MaterialTab("Donation", this.tabGroup, (JComponent)this.marketplacePanel);
        this.combatTab = new MaterialTab("Combat", this.tabGroup, (JComponent)this.combatPanel);
        this.tabGroup.setBorder((Border)new EmptyBorder(5, 0, 0, 0));
        this.tabGroup.addTab(this.connectivityTab);
        this.tabGroup.addTab(this.marketplaceTab);
        this.tabGroup.addTab(this.combatTab);
        this.tabGroup.select(this.connectivityTab);
        this.add((Component)this.tabGroup, "North");
        this.add(this.mainPanel, "Center");
    }

    public void onGameTick() {
        this.marketplacePanel.onGameTick();
    }

    public void rebuild() {
        this.connectivityPanel.rebuild();
        this.combatPanel.rebuild();
        this.marketplacePanel.rebuild();
        this.repaint();
        this.revalidate();
    }

    public CombatPanel getCombatPanel() {
        return this.combatPanel;
    }

    public ConnectivityPanel getConnectivityPanel() {
        return this.connectivityPanel;
    }

    public MarketplacePanel getMarketplacePanel() {
        return this.marketplacePanel;
    }
}

