/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.ui;

import com.twitchliveloadout.marketplace.MarketplaceDuration;
import com.twitchliveloadout.marketplace.products.MarketplaceProduct;
import com.twitchliveloadout.marketplace.products.TwitchProductCost;
import com.twitchliveloadout.marketplace.transactions.TwitchTransaction;
import com.twitchliveloadout.ui.EntityActionPanel;
import com.twitchliveloadout.ui.MarketplacePanel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketplaceProductPanel
extends EntityActionPanel<MarketplaceProduct> {
    private static final Logger log = LoggerFactory.getLogger(MarketplaceProductPanel.class);

    public MarketplaceProductPanel(JPanel parentPanel) {
        super(parentPanel, "Invalid Random Event donation", false, "Are you sure you want to stop the effects of this donation?", "Stop Random Event", EntityActionPanel.DELETE_ICON, EntityActionPanel.DELETE_HOVER_ICON);
    }

    @Override
    protected String[] getLines() {
        MarketplaceProduct marketplaceProduct = (MarketplaceProduct)this.getEntity();
        boolean isActive = marketplaceProduct.isActive();
        boolean isExpired = marketplaceProduct.isExpired();
        long expiresInMs = marketplaceProduct.getExpiresInMs();
        String streamerProductName = marketplaceProduct.getStreamerProduct().name;
        String viewerName = marketplaceProduct.getTransaction().user_name;
        TwitchProductCost productCost = marketplaceProduct.getTwitchProduct().cost;
        Integer costAmount = productCost.amount;
        String costCurrency = productCost.type;
        String statusLine = "<b color='green'>ACTIVE</b>";
        if (isExpired) {
            statusLine = "<b color='red'>EXPIRED</b>";
        } else if (!isActive) {
            statusLine = "<b color='orange'>PAUSED</b>";
        }
        String[] lines = new String[]{statusLine, "<b>" + streamerProductName + "</b>", "Donation of <b color='yellow'>" + costAmount + " " + costCurrency + "</b>", "By <b color='yellow'>" + viewerName + "</b>", "Expires in " + MarketplaceDuration.humanizeDurationMs(expiresInMs)};
        return lines;
    }

    @Override
    protected void executeAction() {
        MarketplaceProduct marketplaceProduct = (MarketplaceProduct)this.getEntity();
        MarketplacePanel marketplacePanel = (MarketplacePanel)this.parentPanel;
        TwitchTransaction twitchTransaction = marketplaceProduct.getTransaction();
        String transactionId = twitchTransaction != null ? twitchTransaction.id : "unknown";
        log.info("A marketplace product is manually requested to be stopped, transaction ID: " + transactionId);
        marketplaceProduct.stop(false);
        marketplacePanel.rebuild();
    }
}

