/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.ui;

import com.twitchliveloadout.marketplace.LambdaIterator;
import com.twitchliveloadout.marketplace.MarketplaceManager;
import com.twitchliveloadout.marketplace.MarketplaceProductSorter;
import com.twitchliveloadout.marketplace.products.MarketplaceProduct;
import com.twitchliveloadout.marketplace.products.StreamerProduct;
import com.twitchliveloadout.marketplace.transactions.TwitchTransaction;
import com.twitchliveloadout.ui.EntityActionPanel;
import com.twitchliveloadout.ui.MarketplaceProductPanel;
import com.twitchliveloadout.ui.Styles;
import com.twitchliveloadout.ui.TextPanel;
import com.twitchliveloadout.ui.TwitchTransactionPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketplacePanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(MarketplacePanel.class);
    private static final String PLAYBACK_PANEL = "PLAYBACK_PANEL";
    private static final String SUCCESS_TEXT_COLOR = "#00ff00";
    private static final String WARNING_TEXT_COLOR = "#ffa500";
    private static final String ERROR_TEXT_COLOR = "#ff0000";
    private final GridBagConstraints constraints = new GridBagConstraints();
    private final GridBagConstraints productListConstraints = new GridBagConstraints();
    private final GridBagConstraints transactionListConstraints = new GridBagConstraints();
    private final CardLayout cardLayout = new CardLayout();
    private final JPanel wrapper = new JPanel(this.cardLayout);
    private final GridBagConstraints playbackConstraints = new GridBagConstraints();
    private final TextPanel statusPanel = new TextPanel("Status:", "<html><b color='#ffa500'>SETTING UP</b></html>");
    private final TextPanel availableDonationsPanel = new TextPanel("Configured Donations:", "<html>No donations are configured.</html>");
    private final TextPanel queuedTransactionsPanel = new TextPanel("Queued Donations:", "<html>No donations are queued.</html>");
    private final JPanel playbackWrapper = new JPanel(new BorderLayout());
    private final TextPanel playbackControlsPanel = new TextPanel("Playback Controls:", "<html>Pause and start to temporarily block distractions. Currently active ones will still expire when paused!</html>");
    private final JPanel startPanel = new JPanel(new BorderLayout());
    private final JLabel startLabel = new JLabel();
    private final JPanel productListPanel = new JPanel(new GridBagLayout());
    private final TextPanel productListTitlePanel = new TextPanel("Active random events:", "<html>List of active random events.</html>");
    private final JPanel productListWrapper = new JPanel(new BorderLayout());
    private final CopyOnWriteArrayList<MarketplaceProductPanel> productPanels = new CopyOnWriteArrayList();
    private final JPanel transactionListPanel = new JPanel(new GridBagLayout());
    private final TextPanel transactionListTitlePanel = new TextPanel("Recent donations:", "<html>List of all recent donations.</html>");
    private final JPanel transactionListWrapper = new JPanel(new BorderLayout());
    private final CopyOnWriteArrayList<TwitchTransactionPanel> transactionPanels = new CopyOnWriteArrayList();
    private final MarketplaceManager marketplaceManager;
    private boolean rebuildRequested = false;

    public MarketplacePanel(MarketplaceManager marketplaceManager) {
        super(new GridBagLayout());
        this.marketplaceManager = marketplaceManager;
        this.initializeLayout();
    }

    public void onGameTick() {
        if (this.rebuildRequested) {
            this.rebuild();
        }
    }

    public void requestRebuild() {
        this.rebuildRequested = true;
    }

    public void rebuild() {
        this.rebuildRequested = false;
        this.repopulatePanels();
        this.updateTexts();
    }

    private void initializeLayout() {
        int i;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.playbackConstraints.fill = 2;
        this.playbackConstraints.weightx = 1.0;
        this.playbackConstraints.gridx = 0;
        this.playbackConstraints.gridy = 0;
        this.productListConstraints.fill = 2;
        this.productListConstraints.weightx = 1.0;
        this.productListConstraints.gridx = 0;
        this.productListConstraints.gridy = 0;
        this.transactionListConstraints.fill = 2;
        this.transactionListConstraints.weightx = 1.0;
        this.transactionListConstraints.gridx = 0;
        this.transactionListConstraints.gridy = 0;
        this.playbackWrapper.setLayout(new GridBagLayout());
        this.playbackWrapper.setBorder(new EmptyBorder(10, 0, 10, 0));
        this.playbackWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.playbackWrapper.add((Component)this.statusPanel, this.playbackConstraints);
        ++this.playbackConstraints.gridy;
        this.playbackWrapper.add((Component)this.playbackControlsPanel, this.playbackConstraints);
        ++this.playbackConstraints.gridy;
        this.playbackWrapper.add((Component)this.startPanel, this.playbackConstraints);
        ++this.playbackConstraints.gridy;
        this.playbackWrapper.add((Component)this.availableDonationsPanel, this.playbackConstraints);
        ++this.playbackConstraints.gridy;
        this.playbackWrapper.add((Component)this.queuedTransactionsPanel, this.playbackConstraints);
        ++this.playbackConstraints.gridy;
        this.playbackWrapper.add((Component)this.productListTitlePanel, this.playbackConstraints);
        ++this.playbackConstraints.gridy;
        this.playbackWrapper.add((Component)this.productListWrapper, this.playbackConstraints);
        ++this.playbackConstraints.gridy;
        this.playbackWrapper.add((Component)this.transactionListTitlePanel, this.playbackConstraints);
        ++this.playbackConstraints.gridy;
        this.playbackWrapper.add((Component)this.transactionListWrapper, this.playbackConstraints);
        ++this.playbackConstraints.gridy;
        this.productListWrapper.setLayout(new GridBagLayout());
        this.productListWrapper.setBorder(new EmptyBorder(10, 0, 10, 0));
        this.productListWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.productListPanel.setBorder(new EmptyBorder(10, 0, 10, 0));
        this.productListPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.productListWrapper.add((Component)this.productListPanel, this.productListConstraints);
        ++this.productListConstraints.gridy;
        this.transactionListWrapper.setLayout(new GridBagLayout());
        this.transactionListWrapper.setBorder(new EmptyBorder(10, 0, 10, 0));
        this.transactionListWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.transactionListPanel.setBorder(new EmptyBorder(10, 0, 10, 0));
        this.transactionListPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.transactionListWrapper.add((Component)this.transactionListPanel, this.transactionListConstraints);
        ++this.transactionListConstraints.gridy;
        this.wrapper.add((Component)this.playbackWrapper, PLAYBACK_PANEL);
        ++this.constraints.gridy;
        this.add((Component)this.wrapper, "North");
        this.cardLayout.show(this.wrapper, PLAYBACK_PANEL);
        this.initializePanelButton(this.startPanel, this.startLabel, this.getPlaybackButtonTitle(), () -> {
            boolean isMarketplaceActive = this.marketplaceManager.isActive();
            if (isMarketplaceActive) {
                this.marketplaceManager.pauseActiveProducts();
            } else {
                this.marketplaceManager.playActiveProducts();
            }
            this.updateTexts();
            this.rebuildProductPanels();
        });
        for (i = 0; i < 50; ++i) {
            MarketplaceProductPanel marketplaceProductPanel = new MarketplaceProductPanel(this);
            this.productPanels.add(marketplaceProductPanel);
            this.productListPanel.add((Component)marketplaceProductPanel, this.productListConstraints);
            ++this.productListConstraints.gridy;
            marketplaceProductPanel.rebuild();
        }
        for (i = 0; i < 50; ++i) {
            TwitchTransactionPanel twitchTransactionPanel = new TwitchTransactionPanel(this, this.marketplaceManager);
            this.transactionPanels.add(twitchTransactionPanel);
            this.transactionListPanel.add((Component)twitchTransactionPanel, this.transactionListConstraints);
            ++this.transactionListConstraints.gridy;
            twitchTransactionPanel.rebuild();
        }
        this.repaint();
        this.revalidate();
    }

    private void repopulatePanels() {
        EntityActionPanel panel;
        CopyOnWriteArrayList<MarketplaceProduct> activeProducts = this.marketplaceManager.getActiveProducts();
        CopyOnWriteArrayList<TwitchTransaction> archivedTransactions = this.marketplaceManager.getArchivedTransactions();
        int marketplaceProductPanelIndex = 0;
        int twitchTransactionPanelIndex = 0;
        Collections.sort(activeProducts, new MarketplaceProductSorter());
        LambdaIterator.handleAll(this.productPanels, productPanel -> productPanel.setEntity(null));
        LambdaIterator.handleAll(this.transactionPanels, transactionPanel -> transactionPanel.setEntity(null));
        for (MarketplaceProduct marketplaceProduct : activeProducts) {
            panel = this.productPanels.get(marketplaceProductPanelIndex);
            if (panel == null) {
                log.warn("An invalid marketplace product panel index was requested: " + marketplaceProductPanelIndex);
                break;
            }
            panel.setEntity(marketplaceProduct);
            ++marketplaceProductPanelIndex;
        }
        for (TwitchTransaction twitchTransaction : archivedTransactions) {
            panel = this.transactionPanels.get(twitchTransactionPanelIndex);
            if (panel == null) {
                log.warn("An invalid transaction product panel index was requested: " + twitchTransactionPanelIndex);
                break;
            }
            panel.setEntity(twitchTransaction);
            ++twitchTransactionPanelIndex;
        }
        this.rebuildProductPanels();
        this.rebuildTransactionPanels();
    }

    public void rebuildProductPanels() {
        LambdaIterator.handleAll(this.productPanels, panel -> panel.rebuild());
    }

    public void rebuildTransactionPanels() {
        LambdaIterator.handleAll(this.transactionPanels, panel -> panel.rebuild());
    }

    public void updateTexts() {
        CopyOnWriteArrayList<MarketplaceProduct> activeProducts = this.marketplaceManager.getActiveProducts();
        CopyOnWriteArrayList<StreamerProduct> streamerProducts = this.marketplaceManager.getStreamerProducts();
        CopyOnWriteArrayList<TwitchTransaction> queuedTransactions = this.marketplaceManager.getQueuedTransactions();
        CopyOnWriteArrayList<TwitchTransaction> archivedTransactions = this.marketplaceManager.getArchivedTransactions();
        int streamerProductAmount = streamerProducts.size();
        int queuedTransactionAmount = queuedTransactions.size();
        int activeProductAmount = activeProducts.size();
        int archivedTransactionAmount = archivedTransactions.size();
        String statusText = "<html><b color='#00ff00'>Receiving donations and activating Random Events is ACTIVE</b></html>";
        Object availableDonationsText = "<html>You have <b color='#00ff00'>configured " + streamerProductAmount + " Random Event donations</b>.</html>";
        if (!this.marketplaceManager.isActive()) {
            statusText = "<html><b color='#ff0000'>Random Event donations are temporarily PAUSED</b></html>";
        }
        if (!this.marketplaceManager.getConfig().marketplaceEnabled()) {
            statusText = "<html><b color='#ff0000'>Random Event donations are DISABLED in the plugin settings</b></html>";
        }
        if (this.marketplaceManager.isFetchingEbsTransactionsErrored()) {
            statusText = "<html><b color='#ff0000'>Random Event donations are NOT AVAILABLE right now and therefore disabled. Contact support if the issue persists.</b></html>";
        }
        if (streamerProductAmount <= 0) {
            availableDonationsText = "<html>There are <b color='#ff0000'>no Random Event donations configured<b>. Go to the Live Loadout Twitch Extension configuration page where you copied your token to set them up.</html>";
        }
        this.statusPanel.setText(statusText);
        this.startLabel.setText(this.getPlaybackButtonTitle());
        this.availableDonationsPanel.setText((String)availableDonationsText);
        this.queuedTransactionsPanel.setText("There are " + queuedTransactionAmount + " donations queued.");
        this.productListTitlePanel.setText("There are " + activeProductAmount + " random events active.");
        this.transactionListTitlePanel.setText("There are " + archivedTransactionAmount + " recent donations.");
    }

    private String getPlaybackButtonTitle() {
        return "<html><b color='yellow'>" + (this.marketplaceManager.isActive() ? "PAUSE ALL" : "PLAY ALL") + "</b></html>";
    }

    private void initializePanelButton(final JPanel panel, JLabel label, String buttonTitle, final ButtonCallback buttonCallback) {
        panel.setLayout(new BorderLayout());
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        panel.add((Component)label, "Center");
        Styles.styleBigLabel(label, buttonTitle);
        panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                buttonCallback.execute();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                panel.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
                panel.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                panel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                panel.setCursor(new Cursor(0));
            }
        });
    }

    public static interface ButtonCallback {
        public void execute();
    }
}

