/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.ui;

import com.twitchliveloadout.TwitchLiveLoadoutPlugin;
import com.twitchliveloadout.fights.Fight;
import com.twitchliveloadout.fights.FightStateManager;
import com.twitchliveloadout.ui.Styles;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;

public class FightPanel
extends JPanel {
    private final FightStateManager fightStateManager;
    private Fight fight;
    private static final ImageIcon DELETE_ICON;
    private static final ImageIcon DELETE_HOVER_ICON;
    private final JPanel wrapper = new JPanel(new GridBagLayout());
    private final JLabel actorNameLabel = new JLabel();
    private final JLabel deleteLabel = new JLabel();

    public FightPanel(final FightStateManager fightStateManager) {
        this.fightStateManager = fightStateManager;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 0, 10, 0));
        Styles.styleBigLabel(this.actorNameLabel, "N/A");
        this.deleteLabel.setIcon(DELETE_ICON);
        this.deleteLabel.setToolTipText("Reset fight statistics");
        this.deleteLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int confirm = JOptionPane.showConfirmDialog(FightPanel.this, "Are you sure you want to reset this fight?", "Warning", 2);
                if (confirm == 0) {
                    fightStateManager.deleteFight(FightPanel.this.fight);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                FightPanel.this.deleteLabel.setIcon(DELETE_HOVER_ICON);
                FightPanel.this.deleteLabel.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                FightPanel.this.deleteLabel.setIcon(DELETE_ICON);
                FightPanel.this.deleteLabel.setCursor(new Cursor(0));
            }
        });
        this.wrapper.setLayout(new BorderLayout());
        this.wrapper.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.wrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.wrapper.add((Component)this.actorNameLabel, "West");
        this.wrapper.add((Component)this.deleteLabel, "East");
        this.add((Component)this.wrapper, "North");
    }

    public void setFight(Fight fight) {
        this.fight = fight;
    }

    public void rebuild() {
        if (this.fight == null) {
            return;
        }
        String actorName = this.fight.getActorName();
        FightStateManager.ActorType actorType = this.fight.getActorType();
        this.actorNameLabel.setText(actorName + " (" + actorType.getName() + ")");
    }

    static {
        BufferedImage deleteImg = ImageUtil.loadImageResource(TwitchLiveLoadoutPlugin.class, (String)"/delete_icon.png");
        DELETE_ICON = new ImageIcon(deleteImg);
        DELETE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)deleteImg, (int)-100));
    }
}

