/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.ui;

import com.twitchliveloadout.TwitchLiveLoadoutPlugin;
import com.twitchliveloadout.ui.Styles;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityActionPanel<EntityType>
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(EntityActionPanel.class);
    protected static final ImageIcon DELETE_ICON;
    protected static final ImageIcon DELETE_HOVER_ICON;
    protected static final ImageIcon RERUN_ICON;
    protected static final ImageIcon RERUN_HOVER_ICON;
    private EntityType entity;
    protected final JPanel parentPanel;
    protected final String invalidText;
    private final JPanel wrapper = new JPanel(new GridBagLayout());
    private final JLabel nameLabel = new JLabel();
    private final JLabel actionLabel = new JLabel();

    public EntityActionPanel(final JPanel parentPanel, String invalidText, final boolean enableConfirm, final String confirmText, String actionTooltipText, final ImageIcon actionIcon, final ImageIcon actionHoverIcon) {
        this.parentPanel = parentPanel;
        this.invalidText = invalidText;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 0, 10, 0));
        Styles.styleBigLabel(this.nameLabel, "N/A");
        this.actionLabel.setIcon(actionIcon);
        this.actionLabel.setToolTipText(actionTooltipText);
        this.actionLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (EntityActionPanel.this.entity == null) {
                    return;
                }
                if (!enableConfirm) {
                    EntityActionPanel.this.executeAction();
                    return;
                }
                int confirm = JOptionPane.showConfirmDialog(parentPanel, confirmText, "Warning", 2);
                if (confirm == 0) {
                    EntityActionPanel.this.executeAction();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                EntityActionPanel.this.actionLabel.setIcon(actionHoverIcon);
                EntityActionPanel.this.actionLabel.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                EntityActionPanel.this.actionLabel.setIcon(actionIcon);
                EntityActionPanel.this.actionLabel.setCursor(new Cursor(0));
            }
        });
        this.wrapper.setLayout(new BorderLayout());
        this.wrapper.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.wrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.wrapper.add((Component)this.nameLabel, "West");
        this.wrapper.add((Component)this.actionLabel, "East");
        this.add((Component)this.wrapper, "North");
    }

    public void setEntity(EntityType entity) {
        this.entity = entity;
    }

    public EntityType getEntity() {
        return this.entity;
    }

    public void rebuild() {
        if (this.entity == null) {
            this.nameLabel.setText(this.invalidText);
            this.setVisible(false);
            return;
        }
        CharSequence[] lines = this.getLines();
        String name = String.join((CharSequence)"<br/>", lines);
        this.setVisible(true);
        this.nameLabel.setText("<html>" + name + "</html>");
    }

    protected abstract String[] getLines();

    protected abstract void executeAction();

    static {
        BufferedImage deleteImg = ImageUtil.loadImageResource(TwitchLiveLoadoutPlugin.class, (String)"/delete_icon.png");
        BufferedImage rerunImg = ImageUtil.loadImageResource(TwitchLiveLoadoutPlugin.class, (String)"/rerun_icon.png");
        DELETE_ICON = new ImageIcon(deleteImg);
        DELETE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)deleteImg, (int)-100));
        RERUN_ICON = new ImageIcon(rerunImg);
        RERUN_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)rerunImg, (int)-100));
    }
}

