/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.ui;

import com.google.gson.JsonObject;
import com.twitchliveloadout.TwitchLiveLoadoutConfig;
import com.twitchliveloadout.TwitchLiveLoadoutPlugin;
import com.twitchliveloadout.twitch.TwitchApi;
import com.twitchliveloadout.twitch.TwitchState;
import com.twitchliveloadout.ui.CanvasListener;
import com.twitchliveloadout.ui.TextPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;

public class ConnectivityPanel
extends JPanel {
    private static final String DEFAULT_TEXT_COLOR = "#ffffff";
    private static final String SUCCESS_TEXT_COLOR = "#00ff00";
    private static final String WARNING_TEXT_COLOR = "#ffa500";
    private static final String ERROR_TEXT_COLOR = "#ff0000";
    private static final int WARNING_BEFORE_EXPIRY = 300;
    private static final ImageIcon ARROW_RIGHT_ICON = new ImageIcon(ImageUtil.loadImageResource(ConnectivityPanel.class, (String)"/arrow_right.png"));
    private static final ImageIcon DISCORD_ICON = new ImageIcon(ImageUtil.loadImageResource(ConnectivityPanel.class, (String)"/discord_icon.png"));
    private static final ImageIcon WIKI_ICON = new ImageIcon(ImageUtil.loadImageResource(ConnectivityPanel.class, (String)"/wiki_icon.png"));
    private static final String SETUP_GUIDE_URL = "https://liveloadout.com/#get-started";
    private static final String DISCORD_INVITE_URL = "https://discord.gg/3Fjm5HTFGM";
    private final GridBagConstraints constraints = new GridBagConstraints();
    private final JPanel wrapper = new JPanel(new GridBagLayout());
    private final TextPanel syncingStatusPanel = new TextPanel("Syncing status", "N/A");
    private final TextPanel twitchStatusPanel = new TextPanel("Twitch Status", "N/A");
    private final TextPanel authPanel = new TextPanel("Twitch Token Validity", "N/A");
    private final TextPanel rateLimitPanel = new TextPanel("Twitch API Limit", "N/A");
    private final TextPanel statePanel = new TextPanel("Loadout State Size", "N/A");
    private JPanel actionsContainer = new JPanel();
    private final TwitchLiveLoadoutPlugin plugin;
    private final TwitchApi twitchApi;
    private final TwitchState twitchState;
    private final CanvasListener canvasListener;
    private final TwitchLiveLoadoutConfig config;

    public ConnectivityPanel(TwitchLiveLoadoutPlugin plugin, TwitchApi twitchApi, TwitchState twitchState, CanvasListener canvasListener, TwitchLiveLoadoutConfig config) {
        super(new GridBagLayout());
        this.plugin = plugin;
        this.twitchApi = twitchApi;
        this.twitchState = twitchState;
        this.canvasListener = canvasListener;
        this.config = config;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.actionsContainer.setBorder(new EmptyBorder(10, 0, 0, 0));
        this.actionsContainer.setLayout(new GridLayout(0, 1, 0, 10));
        this.actionsContainer.add(ConnectivityPanel.buildLinkPanel(DISCORD_ICON, "Get support on the", "Discord server", () -> LinkBrowser.browse((String)DISCORD_INVITE_URL)));
        this.actionsContainer.add(ConnectivityPanel.buildLinkPanel(WIKI_ICON, "Go to online", "setup guide", () -> LinkBrowser.browse((String)SETUP_GUIDE_URL)));
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.wrapper.add(this.actionsContainer);
        this.constraints.gridy += 2;
        this.wrapper.add((Component)this.twitchStatusPanel, this.constraints);
        ++this.constraints.gridy;
        this.wrapper.add((Component)this.syncingStatusPanel, this.constraints);
        ++this.constraints.gridy;
        this.wrapper.add((Component)this.authPanel, this.constraints);
        ++this.constraints.gridy;
        this.wrapper.add((Component)this.rateLimitPanel, this.constraints);
        ++this.constraints.gridy;
        this.wrapper.add((Component)this.statePanel, this.constraints);
        ++this.constraints.gridy;
        this.add((Component)this.wrapper, "North");
    }

    public void rebuild() {
        long unixTimestamp = System.currentTimeMillis() / 1000L;
        int rateLimitRemaining = this.twitchApi.getLastRateLimitRemaining();
        String syncingStatusText = "The logged in account is currently syncing to Twitch.";
        String syncingStatusColor = SUCCESS_TEXT_COLOR;
        int responseCode = this.twitchApi.getLastResponseCode();
        Object twitchStatusText = this.twitchApi.getLastResponseMessage();
        String twitchStatusColor = SUCCESS_TEXT_COLOR;
        long tokenExpiry = 0L;
        Object authText = "No valid Twitch Token. See instructions above how to get a new token.";
        String authColor = ERROR_TEXT_COLOR;
        String rateLimitText = "There are " + rateLimitRemaining + " request points available before hitting the Twitch API rate limit.";
        String rateLimitColor = DEFAULT_TEXT_COLOR;
        if (!this.config.syncEnabled()) {
            syncingStatusText = "Syncing is currently disabled in the plugin settings. Nothing is being sent to Twitch.";
            syncingStatusColor = ERROR_TEXT_COLOR;
        } else if (!this.plugin.isLoggedIn()) {
            syncingStatusText = "This client is currently not logged into an account. Twitch only receives connectivity updates without any loadout information.";
            syncingStatusColor = WARNING_TEXT_COLOR;
        }
        try {
            JsonObject decodedToken = this.twitchApi.getDecodedToken();
            tokenExpiry = decodedToken.get("exp").getAsLong();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd MMMM YYYY, HH:mm");
            String tokenExpiryFormatted = Instant.ofEpochSecond(tokenExpiry).atZone(ZoneId.systemDefault()).format(formatter);
            long secondsUntilExpired = tokenExpiry - unixTimestamp;
            if (secondsUntilExpired > 0L) {
                authText = "Twitch Token is VALID and expires at: <br/>" + tokenExpiryFormatted;
                authColor = secondsUntilExpired > 300L ? DEFAULT_TEXT_COLOR : ERROR_TEXT_COLOR;
            } else {
                authText = "Token has EXPIRED at: <br/>" + tokenExpiryFormatted;
            }
        }
        catch (Exception decodedToken) {
            // empty catch block
        }
        if (authColor.equals(ERROR_TEXT_COLOR)) {
            twitchStatusText = "Could not send data to Twitch due to invalid token. Paste the new token in the 'Your copied Twitch Extension Token' setting of the plugin. To get a new token in Twitch navigate to: 'Creator Dashboard' > 'Extensions' > 'OSRS Live Loadout' > 'Configure' > 'Copy Token'.";
            twitchStatusColor = ERROR_TEXT_COLOR;
        }
        String state = this.twitchApi.getLastCompressedState();
        byte[] stateBytes = state.getBytes();
        float stateUsagePercentage = (float)stateBytes.length / 5120.0f * 100.0f;
        String currentCyclicState = this.twitchState.getCurrentCyclicEntry().getKey();
        String stateText = String.format("%.2f", Float.valueOf(stateUsagePercentage)) + "% used of Twitch storage for general data and part of " + currentCyclicState + ".";
        String stateColor = DEFAULT_TEXT_COLOR;
        if (this.twitchApi.isErrorResponseCode(responseCode)) {
            twitchStatusText = (String)twitchStatusText + "<br/><br/>An error occurred wth code: " + responseCode;
            twitchStatusColor = ERROR_TEXT_COLOR;
        }
        if (stateUsagePercentage >= 100.0f) {
            stateText = stateText + "<br/><br/>An error occurred: state is too large to send to Twitch (current slice: " + currentCyclicState + "). Please disable some synced information via the plugin settings in RuneLite and report this to the plugin maintainer via the linked Discord above.";
            stateColor = ERROR_TEXT_COLOR;
        }
        if (rateLimitRemaining <= 10) {
            rateLimitText = rateLimitText + "<br/><br/>Which is almost depleted! Consider having fewer RuneLite clients open at the same time with the plugin active.";
            rateLimitColor = ERROR_TEXT_COLOR;
        }
        this.syncingStatusPanel.setText(this.getTextInColor(syncingStatusText, syncingStatusColor));
        this.twitchStatusPanel.setText(this.getTextInColor((String)twitchStatusText, twitchStatusColor));
        this.authPanel.setText(this.getTextInColor((String)authText, authColor));
        this.rateLimitPanel.setText(this.getTextInColor(rateLimitText, rateLimitColor));
        this.statePanel.setText(this.getTextInColor(stateText, stateColor));
    }

    public String getTextInColor(String text, String color) {
        return "<html><body style=\"color: " + color + ";\">" + text + "</body></html>";
    }

    private static JPanel buildLinkPanel(ImageIcon icon, String topText, String bottomText, final Runnable callback) {
        final JPanel container = new JPanel();
        container.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        container.setLayout(new BorderLayout());
        container.setBorder(new EmptyBorder(10, 10, 10, 10));
        final Color hoverColor = ColorScheme.DARKER_GRAY_HOVER_COLOR;
        final Color pressedColor = ColorScheme.DARKER_GRAY_COLOR.brighter();
        JLabel iconLabel = new JLabel(icon);
        container.add((Component)iconLabel, "West");
        final JPanel textContainer = new JPanel();
        textContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        textContainer.setLayout(new GridLayout(2, 1));
        textContainer.setBorder(new EmptyBorder(5, 10, 5, 10));
        container.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                container.setBackground(pressedColor);
                textContainer.setBackground(pressedColor);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                callback.run();
                container.setBackground(hoverColor);
                textContainer.setBackground(hoverColor);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                container.setBackground(hoverColor);
                textContainer.setBackground(hoverColor);
                container.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                container.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                textContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                container.setCursor(new Cursor(0));
            }
        });
        JLabel topLine = new JLabel(topText);
        topLine.setForeground(Color.WHITE);
        topLine.setFont(FontManager.getRunescapeSmallFont());
        JLabel bottomLine = new JLabel(bottomText);
        bottomLine.setForeground(Color.WHITE);
        bottomLine.setFont(FontManager.getRunescapeSmallFont());
        textContainer.add(topLine);
        textContainer.add(bottomLine);
        container.add((Component)textContainer, "Center");
        JLabel arrowLabel = new JLabel(ARROW_RIGHT_ICON);
        container.add((Component)arrowLabel, "East");
        return container;
    }
}

