/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.ui;

import com.twitchliveloadout.fights.Fight;
import com.twitchliveloadout.fights.FightSorter;
import com.twitchliveloadout.fights.FightStateManager;
import com.twitchliveloadout.ui.FightPanel;
import com.twitchliveloadout.ui.Styles;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.components.PluginErrorPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombatPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(CombatPanel.class);
    private static final String FIGHT_LIST_PANEL = "FIGHT_LIST_PANEL";
    private static final String ERROR_PANEL = "ERROR_PANEL";
    private final GridBagConstraints constraints = new GridBagConstraints();
    private final GridBagConstraints fightListConstraints = new GridBagConstraints();
    private final CardLayout cardLayout = new CardLayout();
    private final JPanel wrapper = new JPanel(this.cardLayout);
    private final JPanel fightListPanel = new JPanel(new GridBagLayout());
    private final JPanel fightListWrapper = new JPanel(new BorderLayout());
    private final CopyOnWriteArrayList<FightPanel> fightPanels = new CopyOnWriteArrayList();
    private final JPanel deleteAllPanel = new JPanel(new BorderLayout());
    private final JLabel deleteAllLabel = new JLabel();
    private final PluginErrorPanel errorPanel = new PluginErrorPanel();
    private final JPanel errorWrapper = new JPanel(new BorderLayout());
    private final FightStateManager fightStateManager;

    public CombatPanel(final FightStateManager fightStateManager) {
        super(new GridBagLayout());
        this.fightStateManager = fightStateManager;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.fightListConstraints.fill = 2;
        this.fightListConstraints.weightx = 1.0;
        this.fightListConstraints.gridx = 0;
        this.fightListConstraints.gridy = 0;
        this.fightListPanel.setBorder(new EmptyBorder(10, 0, 10, 0));
        this.fightListPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.deleteAllPanel.setLayout(new BorderLayout());
        this.deleteAllPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.deleteAllPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.deleteAllPanel.add((Component)this.deleteAllLabel, "Center");
        Styles.styleBigLabel(this.deleteAllLabel, "Delete All Fights");
        this.deleteAllPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int confirm = JOptionPane.showConfirmDialog(CombatPanel.this, "Are you sure you want to reset ALL fights?", "Warning", 2);
                if (confirm == 0) {
                    fightStateManager.deleteAllFights();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                CombatPanel.this.deleteAllPanel.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
                CombatPanel.this.deleteAllPanel.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                CombatPanel.this.deleteAllPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                CombatPanel.this.deleteAllPanel.setCursor(new Cursor(0));
            }
        });
        this.fightListWrapper.setLayout(new GridBagLayout());
        this.fightListWrapper.setBorder(new EmptyBorder(10, 0, 10, 0));
        this.fightListWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.fightListWrapper.add((Component)this.deleteAllPanel, this.constraints);
        ++this.constraints.gridy;
        this.fightListWrapper.add((Component)this.fightListPanel, this.constraints);
        ++this.constraints.gridy;
        this.errorPanel.setBorder((Border)new EmptyBorder(50, 20, 20, 20));
        this.errorPanel.setContent("No fights available", "Start combat with an enemy to manage the fights.");
        this.errorWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.errorWrapper.add((Component)this.errorPanel, "North");
        this.wrapper.add((Component)this.fightListWrapper, FIGHT_LIST_PANEL);
        this.wrapper.add((Component)this.errorWrapper, ERROR_PANEL);
        this.add((Component)this.wrapper, "North");
        for (int i = 0; i < 50; ++i) {
            FightPanel fightPanel = new FightPanel(fightStateManager);
            this.fightPanels.add(fightPanel);
        }
    }

    public void rebuild() {
        this.rebuildFightList();
        this.repaint();
        this.revalidate();
    }

    public void rebuildFightList() {
        CopyOnWriteArrayList<Fight> fights = new CopyOnWriteArrayList<Fight>();
        int fightPanelIndex = 0;
        fights.addAll(this.fightStateManager.getFights().values());
        Collections.sort(fights, new FightSorter());
        if (fights.size() <= 0) {
            this.cardLayout.show(this.wrapper, ERROR_PANEL);
            return;
        }
        this.cardLayout.show(this.wrapper, FIGHT_LIST_PANEL);
        this.fightListPanel.removeAll();
        this.fightListConstraints.gridy = 0;
        for (FightPanel fightPanel : this.fightPanels) {
            fightPanel.setFight(null);
        }
        for (Fight fight : fights) {
            FightPanel fightPanel = this.fightPanels.get(fightPanelIndex);
            if (fightPanel == null) {
                log.warn("An invalid fight panel index was requested: " + fightPanelIndex);
                break;
            }
            fightPanel.setFight(fight);
            fightPanel.rebuild();
            ++fightPanelIndex;
            this.fightListPanel.add((Component)fightPanel, this.fightListConstraints);
            ++this.fightListConstraints.gridy;
        }
    }
}

