/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.ui;

import com.twitchliveloadout.TwitchLiveLoadoutConfig;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.time.Duration;
import java.time.Instant;

public class CanvasListener
implements FocusListener {
    private final TwitchLiveLoadoutConfig config;
    private boolean inFocus = false;
    private Instant lastInFocusAt = null;

    public CanvasListener(TwitchLiveLoadoutConfig config) {
        this.config = config;
    }

    @Override
    public void focusGained(FocusEvent event) {
        this.enableFocus();
    }

    @Override
    public void focusLost(FocusEvent event) {
        this.disableFocus();
    }

    public void enableFocus() {
        if (this.inFocus) {
            return;
        }
        this.inFocus = true;
        this.lastInFocusAt = Instant.now();
    }

    public void disableFocus() {
        if (!this.inFocus) {
            return;
        }
        this.inFocus = false;
    }

    public long getInFocusDurationMs() {
        if (!this.inFocus || this.lastInFocusAt == null) {
            return 0L;
        }
        Instant now = Instant.now();
        long duration = Duration.between(this.lastInFocusAt, now).toMillis();
        return duration;
    }

    public boolean isInFocus() {
        return this.inFocus;
    }
}

