/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.twitch;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.twitchliveloadout.TwitchLiveLoadoutConfig;
import com.twitchliveloadout.TwitchLiveLoadoutPlugin;
import com.twitchliveloadout.marketplace.MarketplaceManager;
import com.twitchliveloadout.twitch.TwitchStateEntry;
import com.twitchliveloadout.twitch.TwitchThemeEntry;
import com.twitchliveloadout.ui.CanvasListener;
import com.twitchliveloadout.utilities.AccountType;
import java.time.Instant;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.runelite.api.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchState {
    private static final Logger log = LoggerFactory.getLogger(TwitchState.class);
    private final TwitchLiveLoadoutPlugin plugin;
    private final TwitchLiveLoadoutConfig config;
    private final CanvasListener canvasListener;
    private final Gson gson;
    public static final boolean STATE_STRESS_TEST_ENABLED = false;
    public static final int MAX_ITEM_QUANTITY = 8000;
    public static final int MAX_FIGHT_STATISTIC_VALUE = 700;
    public static final int MAX_SKILL_EXPERIENCE = 200000000;
    public static final int MAX_SKILL_LEVEL = 126;
    private final JsonObject currentState = new JsonObject();
    private static final int MAX_BANK_ITEMS_PER_SLICE = 250;
    private static final int MAX_COLLECTION_LOG_ITEMS_PER_SLICE = 250;
    private static final String COLLECTION_LOG_FILTER_SEPARATOR = ",";
    private final JsonObject cyclicState = new JsonObject();
    private TwitchStateEntry currentCyclicEntry = TwitchStateEntry.BANK_TABBED_ITEMS;
    private int currentCyclicSliceIndex = 0;
    private static final int WAS_IN_TOA_DEBOUNCE = 20000;
    private Instant lastWasInToA;

    public TwitchState(TwitchLiveLoadoutPlugin plugin, TwitchLiveLoadoutConfig config, CanvasListener canvasListener, Gson gson) {
        this.plugin = plugin;
        this.config = config;
        this.canvasListener = canvasListener;
        this.gson = gson;
        this.setOverlayTopPosition(config.overlayTopPosition());
        this.setVirtualLevelsEnabled(config.virtualLevelsEnabled());
        this.setTwitchTheme(config.twitchTheme());
        this.setInventoryItems(new Item[0], 0L);
        this.setEquipmentItems(new Item[0], 0L);
        this.setWeight(0);
    }

    public JsonObject getState() {
        return this.currentState;
    }

    public void setPlayerName(String playerName) {
        this.currentState.addProperty(TwitchStateEntry.PLAYER_NAME.getKey(), playerName);
    }

    public void setAccountHash(Long accountHash) {
        this.currentState.addProperty(TwitchStateEntry.ACCOUNT_HASH.getKey(), (Number)accountHash);
    }

    public void setAccountType(AccountType accountType) {
        if (accountType == null) {
            return;
        }
        this.currentState.addProperty(TwitchStateEntry.ACCOUNT_TYPE.getKey(), accountType.getKey());
    }

    public void setOverlayTopPosition(int overlayTopPosition) {
        if (overlayTopPosition < 25) {
            overlayTopPosition = 25;
        } else if (overlayTopPosition > 75) {
            overlayTopPosition = 75;
        }
        this.currentState.addProperty(TwitchStateEntry.TOP_POSITION.getKey(), (Number)overlayTopPosition);
    }

    public void setTwitchTheme(TwitchThemeEntry twitchTheme) {
        this.currentState.addProperty(TwitchStateEntry.THEME_TYPE.getKey(), twitchTheme.getKey());
    }

    public void setWeight(Integer weight) {
        this.currentState.addProperty(TwitchStateEntry.WEIGHT.getKey(), (Number)weight);
    }

    public void setSkillExperiences(int[] skillExperiences) {
        this.currentState.add(TwitchStateEntry.SKILL_EXPERIENCES.getKey(), (JsonElement)this.convertToJson(skillExperiences, 200000000));
    }

    public void setBoostedSkillLevels(int[] boostedSkillLevels) {
        this.currentState.add(TwitchStateEntry.BOOSTED_SKILL_LEVELS.getKey(), (JsonElement)this.convertToJson(boostedSkillLevels, 126));
    }

    public void setVirtualLevelsEnabled(boolean virtualLevelsEnabled) {
        this.currentState.addProperty(TwitchStateEntry.VIRTUAL_LEVELS_ENABLED.getKey(), Boolean.valueOf(virtualLevelsEnabled));
    }

    public void setFightStatistics(JsonObject fightStatistics) {
        this.currentState.add(TwitchStateEntry.FIGHT_STATISTICS.getKey(), (JsonElement)fightStatistics);
    }

    public void setInventoryItems(Item[] items, long totalPrice) {
        this.setItems(TwitchStateEntry.INVENTORY_ITEMS.getKey(), items);
        this.setItemsPrice(TwitchStateEntry.INVENTORY_PRICE.getKey(), totalPrice);
    }

    public void setEquipmentItems(Item[] items, long totalPrice) {
        this.setItems(TwitchStateEntry.EQUIPMENT_ITEMS.getKey(), items);
        this.setItemsPrice(TwitchStateEntry.EQUIPMENT_PRICE.getKey(), totalPrice);
    }

    public void setLootingBagItems(Item[] items, long totalPrice) {
        this.setItems(TwitchStateEntry.LOOTING_BAG_ITEMS.getKey(), items);
        this.setItemsPrice(TwitchStateEntry.LOOTING_BAG_PRICE.getKey(), totalPrice);
        this.plugin.setConfiguration("looting-bag-items", this.convertToJson(items));
        this.plugin.setConfiguration("looting-bag-price", totalPrice);
    }

    private void setItems(String itemsKey, Item[] items) {
        this.setItems(itemsKey, this.convertToJson(items));
    }

    private void setItems(String itemsKey, JsonArray items) {
        this.currentState.add(itemsKey, (JsonElement)items);
    }

    private void setItemsPrice(String priceKey, String totalPrice) {
        this.setItemsPrice(priceKey, Long.parseLong(totalPrice));
    }

    private void setItemsPrice(String priceKey, long totalPrice) {
        this.currentState.addProperty(priceKey, (Number)totalPrice);
    }

    public void setCurrentProductCooldowns(ConcurrentHashMap<String, Instant> cooldownsUntil) {
        Instant now = Instant.now();
        JsonObject currentProductCooldowns = new JsonObject();
        cooldownsUntil.forEach((streamerProductId, cooldownUntil) -> {
            if (now.isAfter((Instant)cooldownUntil)) {
                return;
            }
            currentProductCooldowns.addProperty(streamerProductId, cooldownUntil.toString());
        });
        this.currentState.add(TwitchStateEntry.CURRENT_PRODUCT_COOLDOWNS.getKey(), (JsonElement)currentProductCooldowns);
    }

    public void setCurrentSharedCooldown(Instant sharedCooldownUntil) {
        Instant now = Instant.now();
        if (sharedCooldownUntil == null || now.isAfter(sharedCooldownUntil)) {
            return;
        }
        this.currentState.addProperty(TwitchStateEntry.CURRENT_SHARED_COOLDOWN.getKey(), sharedCooldownUntil.toString());
    }

    public void setInvocations(JsonArray invocations) {
        this.cyclicState.add(TwitchStateEntry.INVOCATIONS.getKey(), (JsonElement)invocations);
        this.plugin.setConfiguration("invocations", invocations);
    }

    public void setInvocationsRaidLevel(String raidLevel) {
        try {
            int parsedRaidLevel = Integer.parseInt(raidLevel);
            this.cyclicState.addProperty(TwitchStateEntry.INVOCATIONS_RAID_LEVEL.getKey(), (Number)parsedRaidLevel);
            this.plugin.setConfiguration("invocations-raid-level", parsedRaidLevel);
        }
        catch (Exception exception) {
            this.plugin.logSupport("Could not set invocations raid level due to the following error:", exception);
        }
    }

    public void setBankItems(Item[] items, int[] tabAmounts) {
        JsonArray tabbedBankItems = new JsonArray();
        int currentItemAmount = 0;
        for (int tabAmount : tabAmounts) {
            Item[] tabItems = Arrays.copyOfRange(items, currentItemAmount, currentItemAmount + tabAmount);
            tabbedBankItems.add((JsonElement)this.convertToJson(tabItems));
            currentItemAmount += tabAmount;
        }
        Item[] zeroTabItems = Arrays.copyOfRange(items, currentItemAmount, items.length);
        JsonArray prependedTabbedBankItems = new JsonArray();
        prependedTabbedBankItems.add((JsonElement)this.convertToJson(zeroTabItems));
        prependedTabbedBankItems.addAll(tabbedBankItems);
        this.setBankItems(prependedTabbedBankItems);
    }

    public void setBankItems(JsonArray tabbedBankItems) {
        this.cyclicState.add(TwitchStateEntry.BANK_TABBED_ITEMS.getKey(), (JsonElement)tabbedBankItems);
        this.plugin.setConfiguration("bank-items", tabbedBankItems);
    }

    public void setBankItemsPrice(long totalPrice) {
        this.cyclicState.addProperty(TwitchStateEntry.BANK_PRICE.getKey(), (Number)totalPrice);
        this.plugin.setConfiguration("bank-price", totalPrice);
    }

    public void setCollectionLog(JsonObject collectionLog) {
        this.cyclicState.add(TwitchStateEntry.COLLECTION_LOG.getKey(), (JsonElement)collectionLog);
        this.plugin.setConfiguration("collection-log", collectionLog);
    }

    public void setQuests(JsonArray quests) {
        this.cyclicState.add(TwitchStateEntry.QUESTS.getKey(), (JsonElement)quests);
        this.plugin.setConfiguration("quests", quests);
    }

    public JsonObject getCollectionLog() {
        return this.cyclicState.getAsJsonObject(TwitchStateEntry.COLLECTION_LOG.getKey());
    }

    public JsonArray getTabbedBankItems() {
        return this.cyclicState.getAsJsonArray(TwitchStateEntry.BANK_TABBED_ITEMS.getKey());
    }

    public JsonObject getFilteredState() {
        JsonObject filteredState = this.getState().deepCopy();
        filteredState = this.addCyclicState(filteredState);
        filteredState = this.addContentId(filteredState);
        filteredState = this.verifyClientActivityStatus(filteredState);
        filteredState = this.addConnectionStatus(filteredState);
        filteredState = this.addMarketplaceSettings(filteredState);
        filteredState = this.removeDisabledState(filteredState);
        return filteredState;
    }

    public JsonObject addCyclicState(JsonObject state) {
        if (this.currentCyclicEntry == TwitchStateEntry.BANK_TABBED_ITEMS) {
            String bankTabbedItemsKey = TwitchStateEntry.BANK_TABBED_ITEMS.getKey();
            String bankPriceKey = TwitchStateEntry.BANK_PRICE.getKey();
            if (!this.cyclicState.has(bankTabbedItemsKey) || !this.cyclicState.has(bankPriceKey)) {
                return state;
            }
            AtomicInteger currentItemAmount = new AtomicInteger();
            JsonArray allTabbedBankItems = this.cyclicState.getAsJsonArray(bankTabbedItemsKey);
            JsonArray slicedTabbedBankItems = new JsonArray();
            JsonArray emptyItem = new JsonArray();
            emptyItem.add((Number)-1);
            emptyItem.add((Number)-1);
            for (int tabIndex = 0; tabIndex < allTabbedBankItems.size(); ++tabIndex) {
                JsonArray tabItems = allTabbedBankItems.get(tabIndex).getAsJsonArray();
                JsonArray slicedTabItems = new JsonArray();
                for (int itemIndex = 0; itemIndex < tabItems.size(); ++itemIndex) {
                    boolean afterSliceStart = currentItemAmount.get() >= this.currentCyclicSliceIndex;
                    boolean beforeSliceEnd = currentItemAmount.get() < this.currentCyclicSliceIndex + 250;
                    currentItemAmount.addAndGet(1);
                    if (!afterSliceStart || !beforeSliceEnd) {
                        slicedTabItems.add((JsonElement)emptyItem);
                        continue;
                    }
                    slicedTabItems.add(tabItems.get(itemIndex));
                }
                slicedTabbedBankItems.add((JsonElement)slicedTabItems);
            }
            state.add(bankTabbedItemsKey, (JsonElement)slicedTabbedBankItems);
            state.addProperty(bankPriceKey, (Number)this.cyclicState.get(bankPriceKey).getAsLong());
            return state;
        }
        if (this.currentCyclicEntry == TwitchStateEntry.COLLECTION_LOG) {
            JsonObject collectionLog = this.getCollectionLog();
            JsonObject slicedCollectionLog = new JsonObject();
            AtomicInteger skippedItemAmount = new AtomicInteger();
            AtomicInteger includedItemAmount = new AtomicInteger();
            if (collectionLog == null) {
                return state;
            }
            collectionLog.keySet().forEach(tabTitle -> {
                JsonObject categories = collectionLog.getAsJsonObject(tabTitle);
                categories.keySet().forEach(categoryTitle -> {
                    JsonObject category = categories.getAsJsonObject(categoryTitle);
                    JsonArray items = category.getAsJsonArray("i");
                    if (items == null) {
                        return;
                    }
                    if (!this.shouldIncludeInCollectionLog((String)tabTitle, (String)categoryTitle)) {
                        return;
                    }
                    int itemAmount = items.size();
                    if (skippedItemAmount.get() < this.currentCyclicSliceIndex) {
                        skippedItemAmount.addAndGet(itemAmount);
                        return;
                    }
                    if (includedItemAmount.get() > 250) {
                        return;
                    }
                    includedItemAmount.addAndGet(itemAmount);
                    if (!slicedCollectionLog.has(tabTitle)) {
                        slicedCollectionLog.add(tabTitle, (JsonElement)new JsonObject());
                    }
                    JsonObject tabLog = slicedCollectionLog.getAsJsonObject(tabTitle);
                    tabLog.add(categoryTitle, (JsonElement)category);
                });
            });
            state.add(TwitchStateEntry.COLLECTION_LOG.getKey(), (JsonElement)slicedCollectionLog);
        }
        if (this.currentCyclicEntry == TwitchStateEntry.QUESTS) {
            JsonArray quests = this.cyclicState.getAsJsonArray(TwitchStateEntry.QUESTS.getKey());
            state.add(TwitchStateEntry.QUESTS.getKey(), (JsonElement)quests);
        }
        if (this.currentCyclicEntry == TwitchStateEntry.INVOCATIONS) {
            JsonArray invocations = this.cyclicState.getAsJsonArray(TwitchStateEntry.INVOCATIONS.getKey());
            JsonElement invocationsRaidLevelElement = this.cyclicState.get(TwitchStateEntry.INVOCATIONS_RAID_LEVEL.getKey());
            Integer invocationsRaidLevel = invocationsRaidLevelElement == null ? null : Integer.valueOf(invocationsRaidLevelElement.getAsInt());
            state.add(TwitchStateEntry.INVOCATIONS.getKey(), (JsonElement)invocations);
            state.addProperty(TwitchStateEntry.INVOCATIONS_RAID_LEVEL.getKey(), (Number)invocationsRaidLevel);
        }
        return state;
    }

    public JsonObject addContentId(JsonObject state) {
        state.addProperty(TwitchStateEntry.CONTENT_ID.getKey(), Long.toString(Instant.now().toEpochMilli()));
        return state;
    }

    private boolean shouldIncludeInCollectionLog(String tabTitle, String categoryTitle) {
        String filter = this.config.collectionLogFilter().trim().toLowerCase();
        String[] filterPieces = filter.split(COLLECTION_LOG_FILTER_SEPARATOR);
        String trimmedTabTitle = tabTitle.trim().toLowerCase();
        String trimmedCategoryTitle = categoryTitle.trim().toLowerCase();
        if (filter.equals("")) {
            return true;
        }
        for (String filterPiece : filterPieces) {
            String trimmedFilterPiece = filterPiece.trim();
            if (!trimmedTabTitle.contains(trimmedFilterPiece) && !trimmedCategoryTitle.contains(trimmedFilterPiece)) continue;
            return true;
        }
        return false;
    }

    public void nextCyclicState() {
        if (this.currentCyclicEntry == TwitchStateEntry.BANK_TABBED_ITEMS) {
            int newSliceIndex;
            int itemAmount = this.getBankItemAmount();
            this.currentCyclicSliceIndex = newSliceIndex = this.currentCyclicSliceIndex + 250;
            if (!this.config.bankEnabled() || this.currentCyclicSliceIndex >= itemAmount) {
                this.currentCyclicEntry = TwitchStateEntry.COLLECTION_LOG;
                this.currentCyclicSliceIndex = 0;
            }
        } else if (this.currentCyclicEntry == TwitchStateEntry.COLLECTION_LOG) {
            int newSliceIndex;
            int itemAmount = this.getCollectionLogItemAmount();
            this.currentCyclicSliceIndex = newSliceIndex = this.currentCyclicSliceIndex + 250;
            if (!this.config.collectionLogEnabled() || this.currentCyclicSliceIndex >= itemAmount) {
                this.currentCyclicEntry = TwitchStateEntry.QUESTS;
                this.currentCyclicSliceIndex = 0;
            }
        } else if (this.currentCyclicEntry == TwitchStateEntry.QUESTS) {
            this.currentCyclicEntry = TwitchStateEntry.INVOCATIONS;
            this.currentCyclicSliceIndex = 0;
        } else if (this.currentCyclicEntry == TwitchStateEntry.INVOCATIONS) {
            this.currentCyclicEntry = TwitchStateEntry.BANK_TABBED_ITEMS;
            this.currentCyclicSliceIndex = 0;
        }
    }

    private JsonObject verifyClientActivityStatus(JsonObject state) {
        JsonElement accountHashElement = state.get(TwitchStateEntry.ACCOUNT_HASH.getKey());
        Long accountHash = accountHashElement == null ? -1L : accountHashElement.getAsLong();
        if (accountHash == null || accountHash == -1L) {
            state = new JsonObject();
        }
        if (!this.plugin.isLoggedIn(true)) {
            state = new JsonObject();
        }
        return state;
    }

    private JsonObject addConnectionStatus(JsonObject state) {
        JsonObject connectionStatus = new JsonObject();
        boolean isLoggedIn = this.plugin.isLoggedIn(true);
        connectionStatus.addProperty("status", Boolean.valueOf(true));
        connectionStatus.addProperty("isLoggedIn", Boolean.valueOf(isLoggedIn));
        state.add(TwitchStateEntry.CONNECTION_STATUS.getKey(), (JsonElement)connectionStatus);
        return state;
    }

    private JsonObject addMarketplaceSettings(JsonObject state) {
        MarketplaceManager marketplaceManager = this.plugin.getMarketplaceManager();
        boolean isEnabled = this.config.marketplaceEnabled();
        boolean isActive = marketplaceManager != null && marketplaceManager.isActive() && !marketplaceManager.isFetchingEbsTransactionsErrored();
        state.addProperty(TwitchStateEntry.MARKETPLACE_ENABLED.getKey(), Boolean.valueOf(isEnabled));
        state.addProperty(TwitchStateEntry.MARKETPLACE_ACTIVE.getKey(), Boolean.valueOf(isActive));
        state.addProperty(TwitchStateEntry.MARKETPLACE_PROTECTION_ENABLED.getKey(), Boolean.valueOf(this.config.marketplaceProtectionEnabled()));
        state.addProperty(TwitchStateEntry.SHARED_COOLDOWN.getKey(), (Number)this.config.marketplaceSharedCooldownS());
        return state;
    }

    private JsonObject removeDisabledState(JsonObject state) {
        boolean hasInvocations;
        if (!this.config.syncEnabled()) {
            for (TwitchStateEntry stateEntry : TwitchStateEntry.values()) {
                if (!stateEntry.isNullable()) continue;
                state.add(stateEntry.getKey(), null);
            }
        }
        if (!this.config.playerInfoEnabled()) {
            state.add(TwitchStateEntry.PLAYER_NAME.getKey(), null);
        }
        if (!this.config.inventoryEnabled()) {
            state.add(TwitchStateEntry.INVENTORY_ITEMS.getKey(), null);
            state.add(TwitchStateEntry.INVENTORY_PRICE.getKey(), null);
        }
        if (!this.config.equipmentEnabled()) {
            state.add(TwitchStateEntry.EQUIPMENT_ITEMS.getKey(), null);
            state.add(TwitchStateEntry.EQUIPMENT_PRICE.getKey(), null);
        }
        if (!this.config.lootingBagEnabled()) {
            state.add(TwitchStateEntry.LOOTING_BAG_ITEMS.getKey(), null);
            state.add(TwitchStateEntry.LOOTING_BAG_PRICE.getKey(), null);
        }
        if (!this.config.bankEnabled()) {
            state.add(TwitchStateEntry.BANK_TABBED_ITEMS.getKey(), null);
            state.add(TwitchStateEntry.BANK_PRICE.getKey(), null);
        }
        if (!this.config.bankPriceEnabled()) {
            state.add(TwitchStateEntry.BANK_PRICE.getKey(), null);
        }
        if (!this.config.collectionLogEnabled()) {
            state.add(TwitchStateEntry.COLLECTION_LOG.getKey(), null);
        }
        if (!this.config.fightStatisticsEnabled()) {
            state.add(TwitchStateEntry.FIGHT_STATISTICS.getKey(), null);
        }
        if (!this.config.itemGoalsEnabled()) {
            state.add(TwitchStateEntry.ITEM_GOALS.getKey(), null);
        }
        if (!this.config.skillsEnabled()) {
            state.add(TwitchStateEntry.SKILL_EXPERIENCES.getKey(), null);
            state.add(TwitchStateEntry.BOOSTED_SKILL_LEVELS.getKey(), null);
        }
        if (!this.config.weightEnabled()) {
            state.add(TwitchStateEntry.WEIGHT.getKey(), null);
        }
        if (!this.config.marketplaceEnabled()) {
            state.addProperty(TwitchStateEntry.MARKETPLACE_ENABLED.getKey(), Boolean.valueOf(false));
            state.add(TwitchStateEntry.CURRENT_PRODUCT_COOLDOWNS.getKey(), null);
        }
        if (!this.config.invocationsEnabled()) {
            state.add(TwitchStateEntry.INVOCATIONS.getKey(), null);
        }
        if (!this.config.invocationsEnabled() || !this.config.invocationsRaidLevelEnabled()) {
            state.add(TwitchStateEntry.INVOCATIONS_RAID_LEVEL.getKey(), null);
        }
        if (!this.config.questsEnabled()) {
            state.add(TwitchStateEntry.QUESTS.getKey(), null);
        }
        if (this.plugin.isLoggedIn() && this.config.autoDetectInToaRaidEnabled() && !this.wasInToaDebounced() && state.has(TwitchStateEntry.INVOCATIONS.getKey()) && (hasInvocations = state.get(TwitchStateEntry.INVOCATIONS.getKey()).isJsonArray())) {
            state.add(TwitchStateEntry.INVOCATIONS.getKey(), null);
            state.add(TwitchStateEntry.INVOCATIONS_RAID_LEVEL.getKey(), null);
        }
        return state;
    }

    private JsonArray convertToJson(Item[] items) {
        JsonArray itemsJson = new JsonArray();
        if (items == null) {
            return itemsJson;
        }
        for (Item item : items) {
            JsonArray itemJson = new JsonArray();
            int id = item.getId();
            int quantity = item.getQuantity();
            itemJson.add((Number)id);
            itemJson.add((Number)quantity);
            itemsJson.add((JsonElement)itemJson);
        }
        return itemsJson;
    }

    private JsonArray convertToJson(int[] array, int maxValue) {
        int length = array.length;
        int[] copiedArray = new int[length];
        System.arraycopy(array, 0, copiedArray, 0, length);
        JsonArray json = this.gson.toJsonTree((Object)copiedArray).getAsJsonArray();
        return json;
    }

    private int getCollectionLogItemAmount() {
        JsonObject collectionLog = this.getCollectionLog();
        AtomicInteger amount = new AtomicInteger();
        if (collectionLog == null) {
            return amount.get();
        }
        collectionLog.keySet().forEach(tabTitle -> {
            JsonObject categories = collectionLog.getAsJsonObject(tabTitle);
            categories.keySet().forEach(categoryTitle -> {
                JsonObject category = categories.getAsJsonObject(categoryTitle);
                JsonArray items = category.getAsJsonArray("i");
                if (items == null) {
                    return;
                }
                if (!this.shouldIncludeInCollectionLog((String)tabTitle, (String)categoryTitle)) {
                    return;
                }
                amount.addAndGet(items.size());
            });
        });
        return amount.get();
    }

    private int getBankItemAmount() {
        JsonArray tabbedBankItems = this.getTabbedBankItems();
        int amount = 0;
        if (tabbedBankItems == null) {
            return amount;
        }
        for (int tabIndex = 0; tabIndex < tabbedBankItems.size(); ++tabIndex) {
            JsonArray tabItems = tabbedBankItems.get(tabIndex).getAsJsonArray();
            amount += tabItems.size();
        }
        return amount;
    }

    public void onPlayerNameChanged(String playerName) {
        this.reloadCache();
    }

    private void reloadCache() {
        this.cyclicState.remove(TwitchStateEntry.COLLECTION_LOG.getKey());
        this.cyclicState.remove(TwitchStateEntry.BANK_TABBED_ITEMS.getKey());
        this.cyclicState.remove(TwitchStateEntry.BANK_PRICE.getKey());
        this.cyclicState.remove(TwitchStateEntry.QUESTS.getKey());
        this.cyclicState.remove(TwitchStateEntry.INVOCATIONS.getKey());
        this.cyclicState.remove(TwitchStateEntry.INVOCATIONS_RAID_LEVEL.getKey());
        this.currentState.add(TwitchStateEntry.LOOTING_BAG_ITEMS.getKey(), null);
        this.currentState.addProperty(TwitchStateEntry.LOOTING_BAG_PRICE.getKey(), (Number)0);
        this.loadDataFromCache("collection-log", rawCollectionLog -> {
            JsonObject parsedCollectionLog = new JsonParser().parse(rawCollectionLog).getAsJsonObject();
            this.setCollectionLog(parsedCollectionLog);
        });
        this.loadDataFromCache("bank-items", rawItems -> {
            JsonArray parsedTabbedItems = new JsonParser().parse(rawItems).getAsJsonArray();
            this.setBankItems(parsedTabbedItems);
        });
        this.loadDataFromCache("bank-price", price -> this.setBankItemsPrice(Long.parseLong(price)));
        this.loadDataFromCache("quests", rawQuests -> {
            JsonArray parsedQuests = new JsonParser().parse(rawQuests).getAsJsonArray();
            this.setQuests(parsedQuests);
        });
        this.loadDataFromCache("looting-bag-items", rawItems -> {
            JsonArray parsedItems = new JsonParser().parse(rawItems).getAsJsonArray();
            this.setItems(TwitchStateEntry.LOOTING_BAG_ITEMS.getKey(), parsedItems);
        });
        this.loadDataFromCache("looting-bag-price", price -> this.setItemsPrice(TwitchStateEntry.LOOTING_BAG_PRICE.getKey(), price));
        this.loadDataFromCache("invocations", rawInvocations -> {
            JsonArray parsedInvocations = new JsonParser().parse(rawInvocations).getAsJsonArray();
            this.setInvocations(parsedInvocations);
        });
        this.loadDataFromCache("invocations-raid-level", raidLevel -> this.setInvocationsRaidLevel(raidLevel));
    }

    private void loadDataFromCache(String cacheKey, CacheDataHandler handler) {
        String rawCacheData = this.plugin.getConfiguration(cacheKey);
        if (rawCacheData == null || rawCacheData.trim().isEmpty()) {
            return;
        }
        try {
            handler.execute(rawCacheData);
        }
        catch (Exception exception) {
            log.warn("Could not handle cache data with from cache key '" + cacheKey + "': ", (Throwable)exception);
        }
    }

    public void setInToA(boolean isInToA) {
        if (isInToA) {
            this.lastWasInToA = Instant.now();
        }
    }

    private boolean wasInToaDebounced() {
        if (this.lastWasInToA == null) {
            return false;
        }
        return Instant.now().minusMillis(20000L).isBefore(this.lastWasInToA);
    }

    public TwitchStateEntry getCurrentCyclicEntry() {
        return this.currentCyclicEntry;
    }

    public static interface CacheDataHandler {
        public void execute(String var1);
    }
}

