/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.twitch;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.twitchliveloadout.TwitchLiveLoadoutConfig;
import com.twitchliveloadout.TwitchLiveLoadoutPlugin;
import com.twitchliveloadout.twitch.TwitchPubSubTargetType;
import com.twitchliveloadout.twitch.TwitchSegmentType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchApi {
    private static final Logger log = LoggerFactory.getLogger(TwitchApi.class);
    public static final int MAX_PAYLOAD_SIZE = 5120;
    public static final int MIN_SCHEDULE_DEFAULT_DELAY = 1300;
    public static final int MIN_SCHEDULE_LOGGED_OUT_DELAY = 6000;
    public static final int MIN_SCHEDULE_GROUP_DELAY = 6000;
    public static final int MAX_SCHEDULED_STATE_AMOUNT = 50;
    public static final String DEFAULT_EXTENSION_CLIENT_ID = "cuhr4y87yiqd92qebs1mlrj3z5xfp6";
    public static final String DEFAULT_TWITCH_EBS_BASE_URL = "https://liveloadout.com";
    public static final String DEFAULT_TWITCH_BASE_URL = "https://api.twitch.tv/helix/extensions";
    private static final String RATE_LIMIT_REMAINING_HEADER = "Ratelimit-Remaining";
    public static final int MIN_SYNC_DELAY = 0;
    public static final int BASE_SYNC_DELAY = 1000;
    public static final double LOW_RATE_LIMIT_DELAY_MULTIPLIER = 2.0;
    public static final int LOW_RATE_LIMIT_REMAINING = 50;
    public static final double HIGH_RATE_LIMIT_DELAY_MULTIPLIER = 0.5;
    public static final int HIGH_RATE_LIMIT_REMAINING = 90;
    public static final boolean NOTIFY_IN_CHAT_ENABLED = true;
    private static final int SEND_PUBSUB_TIMEOUT_MS = 10000;
    private static final int GET_CONFIGURATION_SERVICE_TIMEOUT_MS = 5000;
    private static final int GET_EBS_PRODUCTS_TIMEOUT_MS = 10000;
    private static final int GET_EBS_TRANSACTIONS_TIMEOUT_MS = 10000;
    private static final int ERROR_CHAT_MESSAGE_THROTTLE = 900000;
    private static final String USER_AGENT = "RuneLite";
    private final ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(1);
    private final OkHttpClient httpClientTemplate;
    private final OkHttpClient ebsTransactionsHttpClient;
    private final OkHttpClient configurationSegmentHttpClient;
    private final OkHttpClient pubSubHttpClient;
    final OkHttpClient ebsProductsHttpClient;
    private final TwitchLiveLoadoutPlugin plugin;
    private final Client client;
    private final TwitchLiveLoadoutConfig config;
    private final ChatMessageManager chatMessageManager;
    private Instant lastScheduleStateTime = null;
    private String lastCompressedState = "";
    private int lastRateLimitRemaining = 100;
    private String lastResponseMessage = "Unknown status";
    private int lastResponseCode = 200;
    private long lastErrorChatMessage = 0L;
    private final ConcurrentHashMap<TwitchSegmentType, JsonObject> configurationSegmentContents = new ConcurrentHashMap();

    public TwitchApi(TwitchLiveLoadoutPlugin plugin, Client client, TwitchLiveLoadoutConfig config, ChatMessageManager chatMessageManager, OkHttpClient httpClientTemplate) {
        this.plugin = plugin;
        this.client = client;
        this.config = config;
        this.chatMessageManager = chatMessageManager;
        this.httpClientTemplate = httpClientTemplate;
        this.ebsTransactionsHttpClient = this.createHttpClient(10000);
        this.configurationSegmentHttpClient = this.createHttpClient(5000);
        this.pubSubHttpClient = this.createHttpClient(10000);
        this.ebsProductsHttpClient = this.createHttpClient(10000);
    }

    public void shutDown() {
        this.clearScheduledBroadcasterStates();
        this.scheduledExecutor.shutdown();
    }

    public void scheduleBroadcasterState(final JsonObject state) {
        int delay = this.config.syncDelay() * 1000;
        if ((delay += 1000) < 0) {
            delay = 0;
        }
        this.scheduledExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    TwitchApi.this.sendAsyncPubSubState(state);
                }
                catch (Exception exception) {
                    TwitchApi.this.plugin.logSupport("Could not send the pub sub state due to the following error: ", exception);
                }
            }
        }, (long)delay, TimeUnit.MILLISECONDS);
        this.lastScheduleStateTime = Instant.now();
    }

    public boolean canScheduleState() {
        int delayMs;
        if (this.scheduledExecutor.isShutdown()) {
            return false;
        }
        if (this.scheduledExecutor.getQueue().size() >= 50) {
            return false;
        }
        if (this.lastScheduleStateTime == null) {
            return true;
        }
        boolean isLoggedIn = this.plugin.isLoggedIn(true);
        Instant now = Instant.now();
        int n = delayMs = isLoggedIn ? 1300 : 6000;
        if (this.lastRateLimitRemaining < 50) {
            delayMs = (int)((double)delayMs * 2.0);
        }
        if (this.lastRateLimitRemaining > 90) {
            delayMs = (int)((double)delayMs * 0.5);
        }
        Instant minTime = this.lastScheduleStateTime.plusMillis(delayMs);
        return now.isAfter(minTime);
    }

    public void clearScheduledBroadcasterStates() {
        this.scheduledExecutor.getQueue().clear();
    }

    private boolean sendAsyncPubSubState(JsonObject state) {
        try {
            JsonObject data = new JsonObject();
            JsonArray targets = new JsonArray();
            String channelId = this.getChannelId();
            if (channelId == null) {
                return false;
            }
            targets.add(TwitchPubSubTargetType.BROADCAST.getTarget());
            String compressedState = this.compressState(state);
            data.addProperty("message", compressedState);
            data.addProperty("broadcaster_id", channelId);
            data.add("target", (JsonElement)targets);
            this.sendAsyncPubSubMessage(data, response -> this.verifyStateUpdateResponse("PubSub", response, compressedState), exception -> this.plugin.logSupport("Could not send pub sub state due to the following error: ", exception));
            this.lastCompressedState = compressedState;
        }
        catch (Exception exception2) {
            this.plugin.logSupport("Could not send pub sub state due to the following error: ", exception2);
            return false;
        }
        return true;
    }

    private void sendAsyncPubSubMessage(JsonObject data, HttpResponseHandler responseHandler, HttpErrorHandler errorHandler) {
        String url = "https://api.twitch.tv/helix/extensions/pubsub";
        this.performPostRequest("https://api.twitch.tv/helix/extensions/pubsub", data, this.pubSubHttpClient, responseHandler, errorHandler);
    }

    public void fetchAsyncEbsProducts(HttpResponseHandler responseHandler, HttpErrorHandler errorHandler) {
        String url = "https://liveloadout.com/api/marketplace-products";
        JsonObject data = new JsonObject();
        this.performPostRequest(url, data, this.ebsProductsHttpClient, responseHandler, errorHandler);
    }

    public void fetchAsyncEbsTransactions(String lastTransactionId, HttpResponseHandler responseHandler, HttpErrorHandler errorHandler) {
        String url = "https://liveloadout.com/api/marketplace-transactions";
        JsonObject data = new JsonObject();
        if (lastTransactionId != null) {
            data.addProperty("lastTransactionId", lastTransactionId);
        }
        this.performPostRequest(url, data, this.ebsTransactionsHttpClient, responseHandler, errorHandler);
    }

    public void fetchAsyncConfigurationSegment(TwitchSegmentType segmentType) throws Exception {
        String clientId = DEFAULT_EXTENSION_CLIENT_ID;
        String channelId = this.getChannelId();
        String baseUrl = "https://api.twitch.tv/helix/extensions/configurations";
        if (channelId == null) {
            return;
        }
        String url = "https://api.twitch.tv/helix/extensions/configurations?broadcaster_id=" + channelId + "&extension_id=cuhr4y87yiqd92qebs1mlrj3z5xfp6&segment=" + segmentType.getKey();
        this.performGetRequest(url, this.configurationSegmentHttpClient, response -> {
            try {
                String rawSegmentResult = response.body().string();
                JsonObject segmentResult = this.parseJson(rawSegmentResult);
                String rawSegmentContent = segmentResult.getAsJsonArray("data").get(0).getAsJsonObject().get("content").getAsString();
                JsonObject segmentContent = this.parseJson(rawSegmentContent);
                this.configurationSegmentContents.put(segmentType, segmentContent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, error -> {});
    }

    private void verifyStateUpdateResponse(String type, Response response, String compressedState) throws Exception {
        int responseCode = response.code();
        String responseText = response.body().string();
        int compressesStateSize = compressedState.getBytes("UTF-8").length;
        long now = Instant.now().getEpochSecond();
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        String nowFormatted = Instant.ofEpochSecond(now).atZone(ZoneId.systemDefault()).format(dateFormatter);
        long errorChatMessageDeltaTime = now - this.lastErrorChatMessage;
        boolean isLoggedIn = this.client.getGameState() == GameState.LOGGED_IN;
        boolean canSendErrorChatMessage = errorChatMessageDeltaTime > 900000L;
        Object responseCodeMessage = "An unknown error occurred. Please report this to the RuneLite plugin maintainer.";
        switch (responseCode) {
            case 401: 
            case 403: {
                responseCodeMessage = "Twitch Extension Token is expired. Get a new token via the Twitch extension configuration and copy it to the RuneLite plugin settings.";
                break;
            }
            case 400: 
            case 404: {
                responseCodeMessage = "Something has changed with Twitch. Please report this to the RuneLite plugin maintainer.";
            }
        }
        if (!this.isErrorResponseCode(responseCode)) {
            responseCodeMessage = "The latest information is successfully synced to Twitch.";
        }
        responseCodeMessage = (String)responseCodeMessage + " The time of this message was: " + nowFormatted;
        response.close();
        this.lastResponseMessage = responseCodeMessage;
        this.lastResponseCode = responseCode;
        this.lastRateLimitRemaining = Integer.parseInt(response.header(RATE_LIMIT_REMAINING_HEADER, "100"));
        if (this.isErrorResponseCode(responseCode)) {
            log.debug("Could not update state via {}, http code was: {}", (Object)type, (Object)responseCode);
            log.debug("The state was ({} bytes compressed): ", (Object)compressesStateSize);
            log.debug("The response body was {}", (Object)responseText);
            if (this.isAuthErrorResponseCode(responseCode) && isLoggedIn && canSendErrorChatMessage) {
                ChatMessageBuilder message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("Could not synchronize loadout to Twitch " + type + " (code: " + responseCode + "). ").append((String)responseCodeMessage).append(ChatColorType.NORMAL);
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.ITEM_EXAMINE).runeLiteFormattedMessage(message.build()).build());
                this.lastErrorChatMessage = now;
            }
            throw new Exception("Could not set the Twitch PubSub State due to invalid response code: " + responseCode);
        }
        log.debug("Successfully sent state with response code: {}", (Object)responseCode);
    }

    @Nullable
    private String getChannelId() {
        try {
            JsonObject decodedToken = this.getDecodedToken();
            return decodedToken.get("channel_id").getAsString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public JsonObject getDecodedToken() throws Exception {
        String[] parts = this.splitToken(this.getToken());
        String payloadBase64String = parts[1];
        String payloadString = new String(Base64.getDecoder().decode(payloadBase64String), StandardCharsets.UTF_8);
        JsonObject payload = this.parseJson(payloadString);
        return payload;
    }

    public JsonObject getConfigurationSegmentContent(TwitchSegmentType segmentType) {
        return this.configurationSegmentContents.get((Object)segmentType);
    }

    private String[] splitToken(String token) throws Exception {
        String[] parts = token.split("\\.");
        if (parts.length == 2 && token.endsWith(".")) {
            parts = new String[]{parts[0], parts[1], ""};
        }
        if (parts.length != 3) {
            throw new Exception(String.format("The token was expected to have 3 parts, but got %s.", parts.length));
        }
        return parts;
    }

    public String compressState(JsonObject state) {
        try {
            String jsonString = state.toString();
            byte[] compressedState = TwitchApi.compress(jsonString);
            String compressedStateString = new String(Base64.getEncoder().encode(compressedState), StandardCharsets.UTF_8);
            return compressedStateString;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] compress(String str) throws IOException {
        if (str == null || str.length() == 0) {
            return null;
        }
        ByteArrayOutputStream obj = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(obj);
        gzip.write(str.getBytes("UTF-8"));
        gzip.flush();
        gzip.close();
        return obj.toByteArray();
    }

    public boolean isAuthErrorResponseCode(int responseCode) {
        return responseCode == 403;
    }

    public boolean isErrorResponseCode(int responseCode) {
        return responseCode > 299 || responseCode < 200;
    }

    private String getToken() {
        return this.config.twitchToken();
    }

    private JsonObject parseJson(String rawJson) {
        return new JsonParser().parse(rawJson).getAsJsonObject();
    }

    public void performGetRequest(String url, OkHttpClient httpClient, HttpResponseHandler responseHandler, HttpErrorHandler errorHandler) {
        String token = this.config.twitchToken();
        Request request = new Request.Builder().header("Client-ID", DEFAULT_EXTENSION_CLIENT_ID).header("Authorization", "Bearer " + token).header("User-Agent", USER_AGENT).header("Content-Type", "application/json").get().url(url).build();
        this.performRequest(request, httpClient, responseHandler, errorHandler);
    }

    public void performPostRequest(String url, JsonObject data, OkHttpClient httpClient, HttpResponseHandler responseHandler, HttpErrorHandler errorHandler) {
        String token = this.config.twitchToken();
        Request request = new Request.Builder().header("Client-ID", DEFAULT_EXTENSION_CLIENT_ID).header("Authorization", "Bearer " + token).header("User-Agent", USER_AGENT).header("Content-Type", "application/json").post(RequestBody.create((MediaType)RuneLiteAPI.JSON, (String)data.toString())).url(url).build();
        this.performRequest(request, httpClient, responseHandler, errorHandler);
    }

    public void performRequest(Request request, OkHttpClient httpClient, final HttpResponseHandler responseHandler, final HttpErrorHandler errorHandler) {
        final HttpUrl url = request.url();
        httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException exception) {
                TwitchApi.this.plugin.logSupport("Could not send request to: " + url);
                TwitchApi.this.plugin.logSupport("The error that occurred was: ");
                TwitchApi.this.plugin.logSupport(exception.getMessage());
                errorHandler.execute(exception);
            }

            public void onResponse(Call call, Response response) {
                try {
                    responseHandler.execute(response);
                }
                catch (Exception exception) {
                    TwitchApi.this.plugin.logSupport("Could not handle the response that was received from: " + url);
                    TwitchApi.this.plugin.logSupport(exception.getMessage());
                }
                response.close();
            }
        });
    }

    public OkHttpClient createHttpClient(int timeoutMs) {
        return this.httpClientTemplate.newBuilder().callTimeout((long)timeoutMs, TimeUnit.MILLISECONDS).build();
    }

    public String getLastCompressedState() {
        return this.lastCompressedState;
    }

    public int getLastRateLimitRemaining() {
        return this.lastRateLimitRemaining;
    }

    public String getLastResponseMessage() {
        return this.lastResponseMessage;
    }

    public int getLastResponseCode() {
        return this.lastResponseCode;
    }

    public long getLastErrorChatMessage() {
        return this.lastErrorChatMessage;
    }

    public static interface HttpErrorHandler {
        public void execute(Exception var1);
    }

    public static interface HttpResponseHandler {
        public void execute(Response var1) throws Exception;
    }
}

