/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.raids;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.twitchliveloadout.TwitchLiveLoadoutPlugin;
import com.twitchliveloadout.twitch.TwitchState;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvocationsManager {
    private static final Logger log = LoggerFactory.getLogger(InvocationsManager.class);
    private static final int LOBBY_REGION_ID = 13454;
    private static final int WIDGET_RAID_OVERLAY_PARENT_ID = 481;
    private static final int WIDGET_RAID_OVERLAY_CHILD_ID = 40;
    private static final int WIDGET_ID_INVOCATIONS_PARENT = 774;
    private static final int WIDGET_ID_INVOCATIONS_LIST = 52;
    private static final int WIDGET_ID_INVOCATIONS_HEADER = 3;
    private static final int WIDGET_ID_PARTY_MEMBERS_PARENT = 773;
    private static final int WIDGET_ID_PARTY_MEMBERS_LIST = 5;
    private static final int WIDGET_ID_INVOCATIONS_RAID_LEVEL = 73;
    private static final int SCRIPT_ID_BUILD_TOA_PARTY_INTERFACE = 6729;
    private static final int SCRIPT_ID_TOA_PARTY_TOGGLE_REWARD_PANEL = 6732;
    private static final int INVOCATION_ACTIVE_TEXT_COLOR = 13868852;
    private static final int INVOCATION_INACTIVE_TEXT_COLOR = 0x9F9F9F;
    private final TwitchLiveLoadoutPlugin plugin;
    private final TwitchState twitchState;
    private final Client client;

    public InvocationsManager(TwitchLiveLoadoutPlugin plugin, TwitchState twitchState, Client client) {
        this.plugin = plugin;
        this.twitchState = twitchState;
        this.client = client;
    }

    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() != 6729 && event.getScriptId() != 6732) {
            return;
        }
        if (!this.isJoinedPartyInterface()) {
            return;
        }
        this.updateCurrentActiveInvocations();
        this.updateCurrentRaidLevel();
    }

    public boolean isJoinedPartyInterface() {
        Widget partyWidget = this.client.getWidget(773, 5);
        Widget headerWidget = this.client.getWidget(774, 3);
        if (partyWidget == null || headerWidget == null) {
            return false;
        }
        Widget[] headerChildren = headerWidget.getChildren();
        int headerWidgetTitleIndex = 1;
        if (headerChildren == null || headerChildren.length <= headerWidgetTitleIndex) {
            return false;
        }
        try {
            String partyText = partyWidget.getText();
            String headerText = headerWidget.getChild(headerWidgetTitleIndex).getText();
            String[] partyTextTokens = partyText.split("<br>");
            String[] headerTextTokens = headerText.split("Party of ");
            String leaderInParty = partyTextTokens[0];
            String leaderInHeader = headerTextTokens[1];
            return leaderInParty.equals(leaderInHeader);
        }
        catch (Exception exception) {
            log.warn("Could not check party due the following error:", (Throwable)exception);
            return false;
        }
    }

    public void checkIfInToA() {
        this.plugin.runOnClientThread(() -> {
            Player localPlayer = this.client.getLocalPlayer();
            if (localPlayer == null) {
                return;
            }
            LocalPoint localPoint = localPlayer.getLocalLocation();
            Widget raidOverlayWidget = this.client.getWidget(481, 40);
            if (localPoint == null) {
                return;
            }
            int currentRegionId = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPoint).getRegionID();
            boolean inLobby = currentRegionId == 13454;
            boolean hasOverlay = raidOverlayWidget != null && !raidOverlayWidget.isHidden();
            boolean inToA = inLobby || hasOverlay;
            this.twitchState.setInToA(inToA);
        });
    }

    private void updateCurrentRaidLevel() {
        Widget raidLevelWidget = this.client.getWidget(774, 73);
        if (raidLevelWidget == null) {
            return;
        }
        try {
            String raidLevelRaw = raidLevelWidget.getText();
            String[] raidLevelTokens = raidLevelRaw.split(" ");
            String raidLevel = raidLevelTokens[2];
            this.twitchState.setInvocationsRaidLevel(raidLevel);
        }
        catch (Exception exception) {
            log.warn("Could not get the raid level from one of the widgets due to the following error:", (Throwable)exception);
        }
    }

    private void updateCurrentActiveInvocations() {
        Widget invocationsWidget = this.client.getWidget(774, 52);
        if (invocationsWidget == null || invocationsWidget.isHidden() || invocationsWidget.getChildren() == null) {
            return;
        }
        JsonArray invocations = new JsonArray();
        Widget[] widgets = invocationsWidget.getChildren();
        for (int widgetIndex = 0; widgetIndex < widgets.length; ++widgetIndex) {
            Widget spriteWidget = widgets[widgetIndex];
            if (spriteWidget == null) continue;
            int spriteId = spriteWidget.getSpriteId();
            boolean isInvocationIcon = spriteId > -1;
            int titleWidgetIndex = widgetIndex + 1;
            int activeWidgetIndex = widgetIndex - 1;
            if (!isInvocationIcon || titleWidgetIndex >= widgets.length && activeWidgetIndex >= 0) continue;
            Widget titleWidget = widgets[titleWidgetIndex];
            String title = titleWidget.getText();
            int titleColor = titleWidget.getTextColor();
            boolean isActive = titleColor == 13868852;
            JsonObject invocation = new JsonObject();
            invocation.addProperty("title", title);
            invocation.addProperty("spriteId", (Number)spriteId);
            invocation.addProperty("active", Boolean.valueOf(isActive));
            invocations.add((JsonElement)invocation);
        }
        this.twitchState.setInvocations(invocations);
    }
}

