/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.quests;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.twitchliveloadout.TwitchLiveLoadoutPlugin;
import com.twitchliveloadout.twitch.TwitchState;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestManager {
    private static final Logger log = LoggerFactory.getLogger(QuestManager.class);
    private static final int QUEST_LIST_GROUP_ID = 399;
    private static final int QUEST_LIST_CHILD_ID = 7;
    private static final int CATEGORY_QUEST_TEXT_COLOR = 16750623;
    private static final int INVALID_QUEST_TEXT_COLOR = 0;
    private final TwitchLiveLoadoutPlugin plugin;
    private final TwitchState twitchState;
    private final Client client;

    public QuestManager(TwitchLiveLoadoutPlugin plugin, TwitchState twitchState, Client client) {
        this.plugin = plugin;
        this.twitchState = twitchState;
        this.client = client;
    }

    public void updateQuests() {
        Widget questListWidget = this.client.getWidget(399, 7);
        JsonArray questsState = new JsonArray();
        if (questListWidget == null) {
            return;
        }
        for (Widget questWidget : questListWidget.getDynamicChildren()) {
            String text = questWidget.getText();
            int textColor = questWidget.getTextColor();
            JsonArray questEntryState = new JsonArray();
            if (textColor == 16750623 || textColor == 0) continue;
            questEntryState.add(text);
            questEntryState.add((Number)textColor);
            questsState.add((JsonElement)questEntryState);
        }
        this.twitchState.setQuests(questsState);
    }
}

