/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.minimap;

import com.twitchliveloadout.TwitchLiveLoadoutPlugin;
import com.twitchliveloadout.twitch.TwitchState;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import javax.imageio.ImageIO;
import net.runelite.api.Client;
import net.runelite.api.SpritePixels;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinimapManager {
    private static final Logger log = LoggerFactory.getLogger(MinimapManager.class);
    private final TwitchLiveLoadoutPlugin plugin;
    private final TwitchState twitchState;
    private final Client client;

    public MinimapManager(TwitchLiveLoadoutPlugin plugin, TwitchState twitchState, Client client) {
        this.plugin = plugin;
        this.twitchState = twitchState;
        this.client = client;
    }

    public void updateMinimap() {
        this.plugin.runOnClientThread(() -> {});
    }

    private String getMiniMapAsBase64() throws IOException {
        BufferedImage image = this.getMiniMapAsBufferedImage();
        if (image == null) {
            return null;
        }
        String base64Image = this.convertBufferedImageToBase64(image);
        return base64Image;
    }

    private BufferedImage getMiniMapAsBufferedImage() {
        if (!this.plugin.isLoggedIn()) {
            return null;
        }
        int tileSize = 4;
        int sceneSize = 104;
        int radiusAroundPlayer = 12;
        int plane = this.client.getPlane();
        Tile[][] planeTiles = this.client.getScene().getTiles()[plane];
        LocalPoint playerLocation = this.client.getLocalPlayer().getLocalLocation();
        int playerX = playerLocation.getSceneX();
        int playerY = planeTiles[0].length - 1 - playerLocation.getSceneY();
        SpritePixels map = this.client.drawInstanceMap(plane);
        int fullWidth = map.getWidth();
        int fullHeight = map.getHeight();
        int[] pixels = map.getPixels();
        BufferedImage image = new BufferedImage(fullWidth, fullHeight, 1);
        image.setRGB(0, 0, fullWidth, fullHeight, pixels, 0, fullWidth);
        image = image.getSubimage(48, 48, tileSize * sceneSize, tileSize * sceneSize);
        image = image.getSubimage((playerX - radiusAroundPlayer) * tileSize, (playerY - radiusAroundPlayer) * tileSize, radiusAroundPlayer * 2 * tileSize, radiusAroundPlayer * 2 * tileSize);
        return image;
    }

    private String convertBufferedImageToBase64(BufferedImage image) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", os);
        return Base64.getEncoder().encodeToString(os.toByteArray());
    }
}

