/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.marketplace.transmogs;

import com.twitchliveloadout.TwitchLiveLoadoutPlugin;
import com.twitchliveloadout.marketplace.MarketplaceEffect;
import com.twitchliveloadout.marketplace.MarketplaceEffectManager;
import com.twitchliveloadout.marketplace.products.EbsEquipmentFrame;
import java.util.concurrent.ConcurrentHashMap;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.PlayerComposition;
import net.runelite.api.events.PlayerChanged;
import net.runelite.client.game.ItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransmogManager
extends MarketplaceEffectManager<EbsEquipmentFrame> {
    private static final Logger log = LoggerFactory.getLogger(TransmogManager.class);
    private final TwitchLiveLoadoutPlugin plugin;
    private final Client client;
    private final ItemManager itemManager;
    private final ConcurrentHashMap<String, int[]> originalEquipmentIdsLookup = new ConcurrentHashMap();

    public TransmogManager(TwitchLiveLoadoutPlugin plugin, Client client, ItemManager itemManager) {
        super(100);
        this.plugin = plugin;
        this.client = client;
        this.itemManager = itemManager;
    }

    public void onGameTick() {
        this.cleanInactiveEffects();
    }

    public void onPlayerChanged(PlayerChanged playerChanged) {
        boolean isLocalPlayer;
        Player player = playerChanged.getPlayer();
        Player localPlayer = this.client.getLocalPlayer();
        boolean bl = isLocalPlayer = localPlayer == player;
        if (!isLocalPlayer) {
            return;
        }
        this.registerOriginalEquipment(player);
        this.applyActiveEffects();
    }

    @Override
    protected void applyEffect(MarketplaceEffect<EbsEquipmentFrame> effect) {
        Player player = this.client.getLocalPlayer();
        if (!this.verifyPlayer(player)) {
            return;
        }
        PlayerComposition composition = player.getPlayerComposition();
        int[] currentEquipmentIds = composition.getEquipmentIds();
        EbsEquipmentFrame equipmentFrame = effect.getFrame();
        if (currentEquipmentIds == null) {
            return;
        }
        if (!this.hasOriginalEquipment(player)) {
            this.registerOriginalEquipment(player);
        }
        for (int slotId = 0; slotId < currentEquipmentIds.length; ++slotId) {
            Integer newEquipmentId = equipmentFrame.getEquipmentIdBySlotId(slotId);
            if (newEquipmentId == null || newEquipmentId < 0) continue;
            currentEquipmentIds[slotId] = newEquipmentId;
        }
        Integer npcId = equipmentFrame.npcId;
        if (npcId != null && npcId >= 0) {
            composition.setTransformedNpcId(npcId.intValue());
        }
        composition.setHash();
    }

    @Override
    protected void restoreEffect(MarketplaceEffect<EbsEquipmentFrame> effect) {
        Player player = this.client.getLocalPlayer();
        if (!this.verifyPlayer(player)) {
            return;
        }
        String playerName = player.getName();
        PlayerComposition composition = player.getPlayerComposition();
        EbsEquipmentFrame equipmentFrame = effect.getFrame();
        int[] originalEquipmentIds = this.originalEquipmentIdsLookup.get(playerName);
        int[] currentEquipmentIds = composition.getEquipmentIds();
        Integer npcId = equipmentFrame.npcId;
        if (npcId != null && npcId >= 0) {
            composition.setTransformedNpcId(-1);
        }
        if (originalEquipmentIds == null || currentEquipmentIds == null) {
            return;
        }
        System.arraycopy(originalEquipmentIds, 0, currentEquipmentIds, 0, currentEquipmentIds.length);
        composition.setHash();
        this.applyActiveEffects();
    }

    @Override
    protected void onAddEffect(MarketplaceEffect effect) {
        this.applyActiveEffects();
    }

    @Override
    protected void onDeleteEffect(MarketplaceEffect effect) {
    }

    private void registerOriginalEquipment(Player player) {
        if (!this.verifyPlayer(player)) {
            return;
        }
        String playerName = player.getName();
        PlayerComposition composition = player.getPlayerComposition();
        int[] equipmentIds = composition.getEquipmentIds();
        this.originalEquipmentIdsLookup.put(playerName, (int[])equipmentIds.clone());
    }

    private boolean hasOriginalEquipment(Player player) {
        if (!this.verifyPlayer(player)) {
            return false;
        }
        String playerName = player.getName();
        return this.originalEquipmentIdsLookup.containsKey(playerName);
    }

    private boolean verifyPlayer(Player player) {
        if (player == null) {
            return false;
        }
        String playerName = player.getName();
        PlayerComposition composition = player.getPlayerComposition();
        if (playerName == null || composition == null) {
            return false;
        }
        int[] equipmentIds = composition.getEquipmentIds();
        return equipmentIds != null;
    }
}

