/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.marketplace.spawns;

import com.twitchliveloadout.marketplace.LambdaIterator;
import com.twitchliveloadout.marketplace.MarketplaceColors;
import com.twitchliveloadout.marketplace.MarketplaceRandomizers;
import com.twitchliveloadout.marketplace.products.EbsInterval;
import com.twitchliveloadout.marketplace.products.EbsModelPlacement;
import com.twitchliveloadout.marketplace.products.EbsModelSet;
import com.twitchliveloadout.marketplace.products.EbsMovementFrame;
import com.twitchliveloadout.marketplace.products.EbsRandomRange;
import com.twitchliveloadout.marketplace.products.EbsRecolor;
import com.twitchliveloadout.marketplace.products.EbsSpawn;
import com.twitchliveloadout.marketplace.products.EbsTranslation;
import com.twitchliveloadout.marketplace.products.MarketplaceProduct;
import com.twitchliveloadout.marketplace.spawns.SpawnPoint;
import java.time.Instant;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import net.runelite.api.Animation;
import net.runelite.api.Client;
import net.runelite.api.ModelData;
import net.runelite.api.RuneLiteObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpawnedObject {
    private static final Logger log = LoggerFactory.getLogger(SpawnedObject.class);
    private final Instant spawnedAt;
    private final Client client;
    private final RuneLiteObject object;
    private final EbsSpawn spawn;
    private EbsModelSet modelSet;
    private ModelData modelData;
    private SpawnPoint spawnPoint;
    private final MarketplaceProduct product;
    private boolean respawnRequired = false;
    private Instant expiredAt;
    private int randomEffectCounter = 0;
    private Instant lastRandomEffectAt;
    private double currentScale = -1.0;
    private double currentRotationDegrees = 0.0;
    private int currentTranslateX = 0;
    private int currentTranslateY = 0;
    private int currentTranslateZ = 0;
    private int currentAnimationId;
    private Instant lockAnimationUntil;
    private final ConcurrentHashMap<String, String> stateFrameValues = new ConcurrentHashMap();

    public SpawnedObject(MarketplaceProduct product, Client client, SpawnPoint spawnPoint, EbsSpawn spawn, EbsModelSet modelSet, Instant expiredAt) {
        this.spawnedAt = Instant.now();
        this.product = product;
        this.client = client;
        this.object = client.createRuneLiteObject();
        this.spawnPoint = spawnPoint;
        this.spawn = spawn;
        this.modelSet = modelSet;
        this.expiredAt = expiredAt;
        this.updateModelSet(false);
        this.initializeObject();
        this.resetAnimation();
        this.updateLocation();
    }

    public void setModelSet(EbsModelSet modelSet) {
        if (modelSet == null) {
            return;
        }
        this.modelSet = modelSet;
    }

    public void updateModelSet(boolean preserveTransforms) {
        boolean shouldTranslateModel;
        if (this.modelSet == null) {
            return;
        }
        ArrayList<Integer> modelIds = this.modelSet.ids;
        EbsModelPlacement modelPlacement = this.spawn.modelPlacement;
        EbsTranslation modelSetTranslation = this.modelSet.translation;
        if (modelPlacement == null) {
            modelPlacement = new EbsModelPlacement();
        }
        EbsTranslation modelPlacementTranslation = modelPlacement.translation;
        int translateX = this.mergeTranslations("x", modelSetTranslation, modelPlacementTranslation);
        int translateY = this.mergeTranslations("y", modelSetTranslation, modelPlacementTranslation);
        int translateZ = this.mergeTranslations("z", modelSetTranslation, modelPlacementTranslation);
        double modelScale = MarketplaceRandomizers.getValidRandomNumberByRange(this.modelSet.scale, 1.0, 1.0, 0.0, 500.0);
        double modelRotationDegrees = MarketplaceRandomizers.getValidRandomNumberByRange(modelPlacement.rotation, 0.0, 360.0, 0.0, 360.0);
        ArrayList<EbsRecolor> recolors = this.modelSet.recolors;
        ArrayList modelDataChunks = new ArrayList();
        boolean shouldScaleModel = this.modelSet.scale != null;
        boolean shouldRotateModel = !"none".equals(modelPlacement.rotationType);
        boolean bl = shouldTranslateModel = translateX != 0 || translateY != 0 || translateZ != 0;
        if (modelIds != null) {
            modelIds.forEach(modelId -> modelDataChunks.add(this.client.loadModelData(modelId.intValue())));
            this.modelData = this.client.mergeModels(modelDataChunks.toArray(new ModelData[modelDataChunks.size()]), modelDataChunks.size());
        }
        if (this.modelData == null) {
            return;
        }
        if (recolors != null) {
            this.modelData.cloneColors();
            LambdaIterator.handleAll(recolors, recolor -> this.recolor((EbsRecolor)recolor));
        }
        if (shouldScaleModel) {
            this.scale(modelScale, false);
        }
        if (preserveTransforms) {
            this.rotate(this.currentRotationDegrees, true);
        } else if (shouldRotateModel) {
            this.rotate(modelRotationDegrees, false);
        }
        if (shouldTranslateModel) {
            this.translate(translateX, translateY, translateZ, false);
        }
        this.render();
    }

    private int mergeTranslations(String translateAxis, EbsTranslation translationOne, EbsTranslation translationTwo) {
        EbsRandomRange rangeOne = this.getTranslationRandomRange(translateAxis, translationOne);
        EbsRandomRange rangeTwo = this.getTranslationRandomRange(translateAxis, translationTwo);
        int amountOne = (int)MarketplaceRandomizers.getValidRandomNumberByRange(rangeOne, 0.0, 0.0, -1024.0, 1024.0);
        int amountTwo = (int)MarketplaceRandomizers.getValidRandomNumberByRange(rangeTwo, 0.0, 0.0, -1024.0, 1024.0);
        return amountOne + amountTwo;
    }

    private EbsRandomRange getTranslationRandomRange(String translateAxis, EbsTranslation translation) {
        if (translateAxis == null || translation == null) {
            return null;
        }
        switch (translateAxis) {
            case "x": {
                return translation.x;
            }
            case "y": {
                return translation.y;
            }
            case "z": {
                return translation.z;
            }
        }
        return null;
    }

    private void initializeObject() {
        this.object.setDrawFrontTilesFirst(true);
    }

    public void rotateTowards(LocalPoint targetPoint) {
        LocalPoint sourcePoint = this.spawnPoint.getLocalPoint(this.client);
        if (sourcePoint == null) {
            return;
        }
        int deltaX = sourcePoint.getX() - targetPoint.getX();
        int deltaY = sourcePoint.getY() - targetPoint.getY();
        double angleRadians = Math.atan2(deltaX, deltaY);
        double angleDegrees = Math.toDegrees(angleRadians);
        this.rotate(angleDegrees, false);
    }

    public void translate(int x, int y, int z, boolean forceUpdate) {
        if (this.currentTranslateX == x && this.currentTranslateY == y && this.currentTranslateZ == z && !forceUpdate) {
            return;
        }
        this.currentTranslateX = x;
        this.currentTranslateY = y;
        this.currentTranslateZ = z;
        this.modelData.cloneVertices();
        this.modelData.translate(x, y, z);
    }

    public void rotate(double angleDegrees, boolean forceUpdate) {
        if (this.currentRotationDegrees == angleDegrees && !forceUpdate) {
            return;
        }
        this.currentRotationDegrees = angleDegrees;
        if (angleDegrees < 0.0) {
            angleDegrees = 360.0 + angleDegrees % 360.0;
        }
        if (angleDegrees > 360.0) {
            angleDegrees %= 360.0;
        }
        int orientation = (int)(angleDegrees * 2047.0 / 360.0);
        this.setOrientation(orientation);
    }

    public void setOrientation(int orientation) {
        this.object.setOrientation(orientation);
    }

    public void scale(double scale, boolean forceUpdate) {
        int roundedScale = (int)scale;
        if (roundedScale < 0 || scale == this.currentScale && !forceUpdate) {
            return;
        }
        this.currentScale = scale;
        this.modelData.cloneVertices();
        this.modelData.scale(roundedScale, roundedScale, roundedScale);
        if (this.modelSet.scalePerOneTile != null) {
            double scalePerOneTile = this.modelSet.scalePerOneTile.intValue();
            double tileRadius = scale / scalePerOneTile;
            int radius = (int)(60.0 * tileRadius);
            this.object.setRadius(radius);
        }
    }

    private void recolor(EbsRecolor recolor) {
        if (recolor == null || this.modelData == null) {
            return;
        }
        Integer sourceColorIndex = recolor.sourceColorIndex;
        Integer sourceColorHsl = recolor.sourceColorHsl;
        Integer targetColorHsl = recolor.targetColorHsl;
        Integer targetColorHex = recolor.targetColorHex;
        if (targetColorHsl == null && targetColorHex != null) {
            targetColorHsl = MarketplaceColors.getColorHsl(targetColorHex);
        }
        if (targetColorHsl == null) {
            return;
        }
        if (sourceColorHsl != null) {
            this.recolorByColor(sourceColorHsl, targetColorHsl);
        } else if (this.isValidColorIndex(sourceColorIndex)) {
            this.recolorByIndex(sourceColorIndex, targetColorHsl);
        } else {
            for (short color : this.modelData.getFaceColors()) {
                this.recolorByColor(color, targetColorHsl);
            }
        }
    }

    private void recolorByColor(int sourceColorHsl, int targetColorHsl) {
        if (this.modelData == null) {
            return;
        }
        this.modelData.recolor((short)sourceColorHsl, (short)targetColorHsl);
    }

    private void recolorByIndex(int sourceColorIndex, int targetColorHsl) {
        if (!this.isValidColorIndex(sourceColorIndex)) {
            return;
        }
        short[] colors = this.modelData.getFaceColors();
        short sourceColorHsl = colors[sourceColorIndex];
        this.modelData.recolor(sourceColorHsl, (short)targetColorHsl);
    }

    private boolean isValidColorIndex(int colorIndex) {
        if (this.modelData == null) {
            return false;
        }
        return colorIndex >= 0 && colorIndex < this.modelData.getFaceColors().length;
    }

    public void setAnimation(int animationId, boolean shouldLoop) {
        Animation animation = null;
        if (animationId == this.currentAnimationId) {
            return;
        }
        if (animationId >= 0) {
            animation = this.client.loadAnimation(animationId);
        }
        this.object.setShouldLoop(shouldLoop);
        this.object.setAnimation(animation);
        this.currentAnimationId = animationId;
    }

    public boolean isAnimationLocked() {
        return this.lockAnimationUntil != null && Instant.now().isBefore(this.lockAnimationUntil);
    }

    public void lockAnimationUntil(long durationMs) {
        this.lockAnimationUntil = Instant.now().plusMillis(durationMs);
    }

    public void resetAnimation() {
        int idleAnimationId = this.getMovementAnimations().idle;
        if (idleAnimationId < 0) {
            this.setAnimation(-1, false);
            return;
        }
        this.setAnimation(idleAnimationId, true);
    }

    public EbsMovementFrame getMovementAnimations() {
        if (this.spawn.movementAnimations == null) {
            return new EbsMovementFrame();
        }
        return this.spawn.movementAnimations;
    }

    public String getStateFrameValue(String stateKey) {
        if (stateKey == null) {
            return null;
        }
        return this.stateFrameValues.get(stateKey);
    }

    public void setStateFrameValue(String stateKey, String stateValue) {
        if (stateKey == null) {
            return;
        }
        this.stateFrameValues.put(stateKey, stateValue);
    }

    public void show() {
        this.object.setActive(true);
        this.render();
    }

    public void hide() {
        this.object.setActive(false);
        this.object.setModel(null);
    }

    public boolean isInRegion() {
        return this.isInView(64);
    }

    public boolean isInChunk() {
        return this.isInView(8);
    }

    public boolean isInView(int radius) {
        LocalPoint playerLocalPoint;
        WorldPoint playerWorldPoint;
        WorldPoint worldPoint = this.spawnPoint.getWorldPoint();
        int distanceToPlayer = worldPoint.distanceTo(playerWorldPoint = WorldPoint.fromLocal((Client)this.client, (LocalPoint)(playerLocalPoint = this.client.getLocalPlayer().getLocalLocation())));
        boolean isInView = distanceToPlayer <= radius;
        return isInView;
    }

    public void render() {
        if (this.modelData == null) {
            return;
        }
        this.object.setModel(this.modelData.light(64, 850, -30, -50, -30));
    }

    public void respawn() {
        if (!this.isInRegion()) {
            return;
        }
        this.updateLocation();
        this.hide();
        this.show();
    }

    public void updateLocation() {
        LocalPoint localPoint = this.spawnPoint.getLocalPoint(this.client);
        int plane = this.spawnPoint.getPlane();
        if (localPoint == null) {
            return;
        }
        this.object.setLocation(localPoint, plane);
    }

    public void updateLastRandomEffectAt(boolean isTriggered) {
        EbsInterval randomInterval = this.spawn.randomEffectsInterval;
        Integer afterTriggerDelayMs = 0;
        if (randomInterval != null && isTriggered) {
            afterTriggerDelayMs = randomInterval.afterTriggerDelayMs;
        }
        this.lastRandomEffectAt = Instant.now().plusMillis(afterTriggerDelayMs.intValue());
    }

    public void registerRandomEffect() {
        ++this.randomEffectCounter;
        this.updateLastRandomEffectAt(true);
    }

    public void expireNow() {
        this.expiredAt = Instant.now();
    }

    public boolean isExpired() {
        return this.expiredAt != null && Instant.now().isAfter(this.expiredAt);
    }

    public Instant getSpawnedAt() {
        return this.spawnedAt;
    }

    public Client getClient() {
        return this.client;
    }

    public RuneLiteObject getObject() {
        return this.object;
    }

    public EbsSpawn getSpawn() {
        return this.spawn;
    }

    public EbsModelSet getModelSet() {
        return this.modelSet;
    }

    public ModelData getModelData() {
        return this.modelData;
    }

    public SpawnPoint getSpawnPoint() {
        return this.spawnPoint;
    }

    public void setSpawnPoint(SpawnPoint spawnPoint) {
        this.spawnPoint = spawnPoint;
    }

    public MarketplaceProduct getProduct() {
        return this.product;
    }

    public boolean isRespawnRequired() {
        return this.respawnRequired;
    }

    public void setRespawnRequired(boolean respawnRequired) {
        this.respawnRequired = respawnRequired;
    }

    public Instant getExpiredAt() {
        return this.expiredAt;
    }

    public int getRandomEffectCounter() {
        return this.randomEffectCounter;
    }

    public Instant getLastRandomEffectAt() {
        return this.lastRandomEffectAt;
    }
}

