/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.marketplace.spawns;

import java.awt.Color;
import net.runelite.api.JagexColor;
import net.runelite.api.ModelData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpawnUtilities {
    private static final Logger log = LoggerFactory.getLogger(SpawnUtilities.class);

    public static void scaleModel(ModelData model, double modelScale) {
        int modelSize = (int)(60.0 * modelScale);
        model.cloneVertices();
        model.scale(modelSize, modelSize, modelSize);
    }

    public static void recolorAllFaces(ModelData model, Color color) {
        SpawnUtilities.recolorAllFaces(model, color, 1.0);
    }

    public static void recolorAllFaces(ModelData model, Color color, double brightness) {
        short[] faceColors = model.getFaceColors();
        for (int faceColorIndex = 0; faceColorIndex < faceColors.length; ++faceColorIndex) {
            SpawnUtilities.recolorFace(model, faceColorIndex, color, brightness);
        }
    }

    public static void recolorFace(ModelData model, int faceColorIndex, Color color, double brightness) {
        short[] faceColors = model.getFaceColors();
        int rgb = color.getRGB();
        if (faceColorIndex < 0 || faceColorIndex >= faceColors.length) {
            log.warn("An invalid face color index was requested for a recolor: ", (Object)faceColorIndex);
            return;
        }
        short faceColor = faceColors[faceColorIndex];
        model.cloneVertices();
        model.recolor(faceColor, JagexColor.rgbToHSL((int)rgb, (double)brightness));
    }

    public static void rotateModel(ModelData modelData, double angleDegrees) {
        modelData.cloneVertices();
        double angleRadians = Math.toRadians(angleDegrees);
        for (int verticesIndex = 0; verticesIndex < modelData.getVerticesCount(); ++verticesIndex) {
            int[] xVertices = modelData.getVerticesX();
            int[] yVertices = modelData.getVerticesY();
            int[] zVertices = modelData.getVerticesZ();
            int x = xVertices[verticesIndex];
            int y = yVertices[verticesIndex];
            int z = zVertices[verticesIndex];
            xVertices[verticesIndex] = (int)((double)x * Math.cos(angleRadians) + (double)z * Math.sin(angleRadians));
            yVertices[verticesIndex] = y;
            zVertices[verticesIndex] = (int)((double)z * Math.cos(angleRadians) - (double)x * Math.sin(angleRadians));
        }
    }
}

