/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.marketplace.spawns;

import com.twitchliveloadout.marketplace.MarketplaceEffect;
import com.twitchliveloadout.marketplace.MarketplaceEffectManager;
import com.twitchliveloadout.marketplace.products.EbsModelOverheadFrame;
import com.twitchliveloadout.marketplace.spawns.OverheadTextOverlay;
import net.runelite.api.Client;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpawnOverheadManager
extends MarketplaceEffectManager<EbsModelOverheadFrame> {
    private static final Logger log = LoggerFactory.getLogger(SpawnOverheadManager.class);
    private final OverlayManager overlayManager;
    private final OverheadTextOverlay overheadTextOverlay;

    public SpawnOverheadManager(Client client, OverlayManager overlayManager) {
        super(100);
        this.overlayManager = overlayManager;
        this.overheadTextOverlay = new OverheadTextOverlay(client);
        overlayManager.add((Overlay)this.overheadTextOverlay);
    }

    public void onGameTick() {
        this.updateEffects();
    }

    @Override
    protected void applyEffect(MarketplaceEffect<EbsModelOverheadFrame> effect) {
        String text = effect.getFrame().text;
        if (effect.isApplied()) {
            return;
        }
        if (text != null && !text.isEmpty()) {
            this.overheadTextOverlay.addEffect(effect);
        }
    }

    @Override
    protected void restoreEffect(MarketplaceEffect<EbsModelOverheadFrame> effect) {
        if (!effect.isApplied()) {
            return;
        }
        this.overheadTextOverlay.removeEffect(effect);
    }

    @Override
    protected void onAddEffect(MarketplaceEffect<EbsModelOverheadFrame> effect) {
    }

    @Override
    protected void onDeleteEffect(MarketplaceEffect<EbsModelOverheadFrame> effect) {
    }

    public void removeOverlay() {
        this.overlayManager.remove((Overlay)this.overheadTextOverlay);
    }
}

